from unittest import makeSuite, TestSuite

from base import SquishdotBase

from re import search
from string import index
from DateTime import DateTime

class UnmoderatedCountTests(SquishdotBase):

    moderated = 0
    
    def setUp(self):        
        SquishdotBase.setUp(self)        
        if self.moderated:
            # put us into "articles and replies moderated" mode
            S= self.Site
            S.manage_edit(0,0,'both',30)
        #add a reply
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testreply',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        self.posting = self.Site[parent.id][id]
        self.parent = parent
       
    def test_addPosting(self):
        "test addPosting works in unmoderated mode"
        self.assertEqual(self.parent.revsub,0)
        self.assertEqual(self.parent.reply_cnt,1)

    def test_set_reviewed1(self):
        "Test set_reviewed on a reviewed reply, with reviewed=0"
        posting = self.posting
        self.Site.set_reviewed(posting,0)
        self.assertEqual(self.parent.revsub,1)
        self.assertEqual(self.parent.reply_cnt,0)
        
    def test_set_reviewed2(self):
        "Test set_reviewed on a reviewed reply, with reviewed=1"
        posting = self.posting
        self.Site.set_reviewed(posting,1)
        parent = posting.aq_parent
        self.assertEqual(self.parent.revsub,0)
        self.assertEqual(self.parent.reply_cnt,1)
   
    def test_delItem(self):
        "test addPosting works in unmoderated mode"
        self.Site.delItem(int(self.posting.id))
        self.assertEqual(self.parent.revsub,0)
        self.assertEqual(self.parent.reply_cnt,0)

class ModeratedCountTests(UnmoderatedCountTests):

    moderated = 1
    
    def test_addPosting(self):
        "test addPosting works in moderated mode"
        self.assertEqual(self.parent.revsub,1)
        self.assertEqual(self.parent.reply_cnt,0)
    
def test_suite():
    return TestSuite((
        makeSuite(UnmoderatedCountTests),
        makeSuite(ModeratedCountTests),
        ))

def debug():
   test_suite().debug()
    








