function defaultsPrefInit() {
  setRefreshDefault();
}

function setRefreshDefault() {
  var strings = document.getElementById("prefsStrings");
  var defaultRefreshInterval = speeddial_gPrefBranch.getIntPref('defaultRefreshInterval');
  var currentUnitIndex = SpeedDialUtils.getTimeUnitIndex(defaultRefreshInterval);
  var currentDefaultRefresh = document.getElementById("currentDefaultRefresh");
  
  if (defaultRefreshInterval > 0) {
    defaultRefreshInterval /= SpeedDialUtils.timeUnits[currentUnitIndex];
    currentDefaultRefresh.setAttribute("value", "" + defaultRefreshInterval + " " + strings.getString(SpeedDialUtils.timeUnitNames[currentUnitIndex]));
  } else {
    currentDefaultRefresh.setAttribute("value", strings.getString('never'));
  }
}

function showDefaultRefreshDialog() {
  openDialog("chrome://speeddial/content/settings/defaultRefresh.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent");
}

function applyRefreshSelectDialog() {
  openDialog("chrome://speeddial/content/settings/targetSelector.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [0, "defaultRefresh"]);
}

function applyJavascriptSelectDialog() {
  openDialog("chrome://speeddial/content/settings/targetSelector.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [0, "defaultJs"]);
}

function applyRowsColumnsSelectDialog() {
  openDialog("chrome://speeddial/content/settings/targetSelector.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [1, "defaultRowsColumns"]);
}

function applySizeSelectDialog() {
  openDialog("chrome://speeddial/content/settings/targetSelector.xul", "",
             "centerscreen,chrome,dialog,resizable,dependent", [1, "defaultSize"]);
}

function processTargetSelectorOutput(type, targetArray) {
  if (type == "defaultRefresh") {
    var defaultRefreshInterval = speeddial_gPrefBranch.getIntPref('defaultRefreshInterval');
    for (var c=0; c<targetArray.length; c++) {
      if (defaultRefreshInterval > 0) {
        speeddial_gPrefBranch.setIntPref("thumbnail-" + targetArray[c] + "-refreshinterval", defaultRefreshInterval);
      } else {
        if (speeddial_gPrefBranch.prefHasUserValue("thumbnail-" + targetArray[c] + "-refreshinterval")) {
          speeddial_gPrefBranch.clearUserPref("thumbnail-" + targetArray[c] + "-refreshinterval");
        }
      }
    }
  } else if (type == "defaultJs") {
    var defaultJs = document.getElementById("defaultDialJavascript").checked;
    for (var c=0; c<targetArray.length; c++) {
      speeddial_gPrefBranch.setBoolPref("thumbnail-" + targetArray[c] + "-js", defaultJs);
    }
  } else if (type == "defaultRowsColumns") {
    var defaultRows = parseInt(document.getElementById("rows").value);
    var defaultCols = parseInt(document.getElementById("columns").value);
    for (var c=0; c<targetArray.length; c++) {
//      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-rows", defaultRows);
//      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-columns", defaultCols);
      SpeedDialUtils.setNewGroupSize(targetArray[c], defaultRows, defaultCols);
    }
  } else if (type == "defaultSize") {
    var minimumWidth = parseInt(document.getElementById("minimumWidth").value);
    var minimumHeight = parseInt(document.getElementById("minimumHeight").value);
    var maximumWidth = parseInt(document.getElementById("maximumWidth").value);
    var maximumHeight = parseInt(document.getElementById("maximumHeight").value);
    var widthModifier = parseInt(document.getElementById("widthModifier").value);
    var heightModifier = parseInt(document.getElementById("heightModifier").value);
    var widthModifierType = document.getElementById("widthModifierType").selectedIndex;
    var heightModifierType = document.getElementById("heightModifierType").selectedIndex;
    for (var c=0; c<targetArray.length; c++) {
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-minimumWidth", minimumWidth);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-minimumHeight", minimumHeight);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-maximumWidth", maximumWidth);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-maximumHeight", maximumHeight);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-widthModifier", widthModifier);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-heightModifier", heightModifier);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-widthModifierType", widthModifierType);
      speeddial_gPrefBranch.setIntPref("group-" + targetArray[c] + "-heightModifierType", heightModifierType);
    }
  }
}

