var targetURL;
var mainArea;
var colorSelected;
var javascriptEnabled;

function Startup() {
  targetURL = window.arguments[0];
  colorSelected = window.arguments[1];
  javascriptEnabled = window.arguments[2];
  
  document.getElementById("currentColor").color = colorSelected;
  document.getElementById("currentColorText").value = document.getElementById("currentColor").color;
  mainArea = document.getElementById("pickerCanvas");
  
  // Capture thumbnail
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var windowIter = wm.getEnumerator('navigator:browser');
  
  if (windowIter.hasMoreElements()) {
    var firstWindow = windowIter.getNext();
    firstWindow.SpeedDial.thumbnailGenerationListeners.push(window);
    firstWindow.SpeedDial.addPrioritySchedule(0);
  }

  // Register observers
  mainArea.addEventListener("click", pickerMouseClick, false);
}

function Unload() {
  mainArea.removeEventListener("click", pickerMouseClick, false);
}

function onOK(event) {
  window.opener.setPickerData(document.getElementById("currentColorText").value);

  return true;
}

function onCancel(event) {
  return true;
}

function pickerMouseClick(e) {
  var pointData = mainArea.getContext('2d').getImageData(e.layerX, e.layerY, 1, 1);
  
  var newR = pointData.data[0].toString(16);
  if (newR.length < 2) newR = '0' + newR;
  var newG = pointData.data[1].toString(16);
  if (newG.length < 2) newG = '0' + newG;
  var newB = pointData.data[2].toString(16);
  if (newB.length < 2) newB = '0' + newB;

  var newColor = "#" + newR + newG + newB;
  document.getElementById("currentColorText").value = newColor;
  document.getElementById("currentColor").color = newColor;
}

function currentColorChanged() {
  var currentColorText = document.getElementById("currentColorText");
  var currentColor = document.getElementById("currentColor");
  
  if (currentColorText.value != currentColor.color) {
    currentColorText.value = currentColor.color;
  }
}

function currentColorTextChanged() {
  var currentColorText = document.getElementById("currentColorText");
  var currentColor = document.getElementById("currentColor");
  
  if (currentColorText.value != currentColor.color) {
    currentColor.color = currentColorText.value;
  }
}

// Call functions from thumbnail generator
function getTargetURL() {
  return targetURL;
}

function getJsEnabled() {
  return javascriptEnabled;
}

function getTargetCanvas() {
  return document.getElementById("pickerCanvas");
}

function thumbnailLoadError() {
  document.getElementById("pickerCanvas").style.display = "none";
  document.getElementById("loadingMessage").style.display = "none";
  document.getElementById("errorMessage").style.display = "block";
}

function thumbnailLoadCompleted() {
  document.getElementById("pickerCanvas").style.display = "block";
  document.getElementById("loadingMessage").style.display = "none";
}
