var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);
var isFirefox3 = false;

function Startup() {
  // Detect version
  var appInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo)
  // only if this is Firefox
  var versionChecker = Components.classes["@mozilla.org/xpcom/version-comparator;1"]
                      .getService(Components.interfaces.nsIVersionComparator);
  // only if the platform version is 1.9 or greater
  if (versionChecker.compare(appInfo.platformVersion, "1.9a1") >= 0) {
    isFirefox3 = true;
  }

  // Set the initial data
  document.getElementById("loadInNewWindow").checked = gPref.getBoolPref("extensions.speeddial.loadInNewWindow");
  document.getElementById("loadInNewTab").checked = gPref.getBoolPref("extensions.speeddial.loadInNewTab");
  document.getElementById("enableGroups").checked = gPref.getBoolPref("extensions.speeddial.enableGroups");
  document.getElementById("thumbnailRendering").selectedIndex = 0;
  
  if (isFirefox3) {
    document.getElementById("thumbnailRenderingBox").setAttribute("hidden", true);
  } else {
    var qualityRendering = gPref.getBoolPref("extensions.speeddial.oldResampling");
    if (qualityRendering) {
      document.getElementById("thumbnailRendering").selectedIndex = 1;
    } else {
      document.getElementById("thumbnailRendering").selectedIndex = 0;
    }
  }
}

function onOK(event) {
  // Set the changed data
  gPref.setBoolPref("extensions.speeddial.loadInNewWindow", document.getElementById("loadInNewWindow").checked);
  gPref.setBoolPref("extensions.speeddial.loadInNewTab", document.getElementById("loadInNewTab").checked);
  gPref.setBoolPref("extensions.speeddial.enableGroups", document.getElementById("enableGroups").checked);
    
  if (document.getElementById("addToolbarIcon").checked) {
    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
    var windowIter = wm.getEnumerator('navigator:browser');
   
    if (windowIter.hasMoreElements()) {
      var targetWindow = windowIter.getNext();
      if (targetWindow.wrappedJSObject) {
        targetWindow = targetWindow.wrappedJSObject;
      }
      targetWindow.SpeedDial.addToolbarIcon();
    }
  }

  if (document.getElementById("setAsHomePage").checked) {
    var aURL = "chrome://speeddial/content/speeddial.xul";
    var str = Components.classes["@mozilla.org/supports-string;1"]
                        .createInstance(Components.interfaces.nsISupportsString);
    str.data = aURL;
    gPref.setComplexValue("browser.startup.homepage",
                                 Components.interfaces.nsISupportsString, str);
    try {
      var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
      var windowIter = wm.getEnumerator('navigator:browser');
     
      if (windowIter.hasMoreElements()) {
        var targetWindow = windowIter.getNext();
        var homeButton = targetWindow.document.getElementById("home-button");
        homeButton.setAttribute("tooltiptext", aURL);
      }
    } catch (ex) {}
  }
  
  if (!isFirefox3) {
    var qualityRendering = (document.getElementById("thumbnailRendering").selectedIndex == 1);
    gPref.setBoolPref("extensions.speeddial.oldResampling", qualityRendering);
  }
  
  return true;
}

function onCancel(event) {
  return true;
}