/* sql.h
 *
 * common interface for sql-like database output plugins
 * 
 * (C) 2004 by Michal Kwiatkowski <ruby@joker.linuxstuff.pl>
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 
 *  as published by the Free Software Foundation
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <specter/specter.h>


struct sql_field {
	struct sql_field *next;
	char name[SPECTER_IRET_NAME_LEN];
	specter_iret_t *iret;
};

char *alloc_sql_insert(const char *fields[], const char *table,
		char **ret_buff, size_t *size, struct sql_field **ret_field);
char *fill_sql_insert(const struct sql_field *f, char *buff,
		const size_t length, size_t (*escape)(char *, const char *, size_t));
void free_sql_insert(char *buff, struct sql_field *f);

