-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Wf_Priority_Value
  (Node        : in     STree.SyntaxNode;
   Pragma_Kind : in     Dictionary.RavenscarPragmas;
   Error_Sym   : in     Dictionary.Symbol;
   Scope       : in     Dictionary.Scopes;
   The_Heap    : in out Heap.HeapRecord;
   Value_Rep   :    out LexTokenManager.Lex_String;
   Compatible  :    out Boolean) is
   Type_Sym              : Dictionary.Symbol;
   Result                : Exp_Record;
   Unused_Seq            : SeqAlgebra.Seq;
   Unused_Component_Data : ComponentManager.ComponentData;
begin
   -- check validity of argument
   -- must be integer and in appropriate System.[Interrupt_]Priority range
   SeqAlgebra.CreateSeq (The_Heap, Unused_Seq);
   ComponentManager.Initialise (Unused_Component_Data);
   -- ASSUME Node = expression OR annotation_expression
   if Syntax_Node_Type (Node => Node) = SP_Symbols.expression then
      -- ASSUME Node = expression
      --# accept Flow, 10, Unused_Component_Data, "Expected ineffective assignment";
      Walk_Expression_P.Walk_Expression
        (Exp_Node                => Node,
         Scope                   => Scope,
         Type_Context            => Dictionary.GetPredefinedIntegerType,
         Context_Requires_Static => True,
         Ref_Var                 => Unused_Seq,
         Result                  => Result,
         Component_Data          => Unused_Component_Data,
         The_Heap                => The_Heap);
      --# end accept;
   elsif Syntax_Node_Type (Node => Node) = SP_Symbols.annotation_expression then
      -- ASSUME Node = annotation_expression
      --# accept Flow, 10, Unused_Component_Data, "Expected ineffective assignment";
      Walk_Expression_P.Walk_Annotation_Expression
        (Exp_Node       => Node,
         Scope          => Scope,
         Type_Context   => Dictionary.GetPredefinedIntegerType,
         Context        => Precondition,
         Result         => Result,
         Component_Data => Unused_Component_Data,
         The_Heap       => The_Heap);
      --# end accept;
   else
      Result := Null_Exp_Record;
      Aggregate_Stack.Init;
   end if;

   SeqAlgebra.DisposeOfSeq (The_Heap, Unused_Seq);

   -- actual parameter must be fixed
   if not Result.Is_Constant then
      ErrorHandler.Semantic_Error
        (Err_Num   => 37,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;

   -- argument must be integer value
   Type_Sym := Dictionary.GetRootType (Result.Type_Symbol);
   if Dictionary.CompatibleTypes (Scope, Type_Sym, Dictionary.GetPredefinedIntegerType) then
      Compatible := True;
      -- range checking here if values known in Dictionary
      Check_Priority_Range
        (Error_Sym   => Error_Sym,
         Scope       => Scope,
         Pragma_Kind => Pragma_Kind,
         Err_Pos     => Node_Position (Node => Node),
         Value       => Result.Value,
         Value_Rep   => Value_Rep);
   else
      Compatible := False;
      Value_Rep  := LexTokenManager.Null_String;
      ErrorHandler.Semantic_Error
        (Err_Num   => 877,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;
end Wf_Priority_Value;
