-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function GetContext (TheSymbol : Symbol) return Contexts is
   Context : Contexts;

   --------------------------------------------------------------------------------

   function GetContextFromDeclaration (TheSymbol : Symbol) return Contexts
   --# global in Dict;
   is
   begin
      return RawDict.GetDeclarationContext (GetDeclaration (TheSymbol));
   end GetContextFromDeclaration;

   --------------------------------------------------------------------------------

begin

   case RawDict.GetSymbolDiscriminant (TheSymbol) is
      when TypeSymbol | ConstantSymbol | PackageSymbol | SubprogramSymbol =>
         Context := GetContextFromDeclaration (TheSymbol);
      when VariableSymbol =>
         if GetDeclaration (TheSymbol) = NullSymbol then
            Context := ProofContext;
         else
            Context := GetContextFromDeclaration (TheSymbol);
         end if;
      when QuantifiedVariableSymbol | ImplicitProofFunctionSymbol | ImplicitReturnVariableSymbol =>
         Context := ProofContext;
      when EnumerationLiteralSymbol | RecordComponentSymbol =>
         Context := GetContextFromDeclaration (GetType (TheSymbol));
      when LoopSymbol | LoopParameterSymbol =>
         Context := ProgramContext;
      when others =>
         Context := GetContextFromDeclaration (GetSubprogram (TheSymbol));
   end case;

   return Context;

end GetContext;
