-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function FirstSubprogramParameter (Subprogram : Symbol) return Iterator is
   SubprogramParameters : Iterator;

   --------------------------------------------------------------------------------

   function FirstAdaSubprogramParameter (Subprogram : Symbol) return Iterator
   --# global in Dict;
   is
      SubprogramParameter  : Symbol;
      SubprogramParameters : Iterator;
   begin

      SubprogramParameter := RawDict.GetSubprogramFirstParameter (Subprogram);

      if SubprogramParameter = NullSymbol then
         SubprogramParameters := NullIterator;
      else
         SubprogramParameters := Iterator'(SubprogramParameterIterator, IsAbstract, SubprogramParameter, NullSymbol);
      end if;

      return SubprogramParameters;

   end FirstAdaSubprogramParameter;

   --------------------------------------------------------------------------------

   function FirstImplicitProofFunctionParameter (ProofFunction : Symbol) return Iterator
   --# global in Dict;
   is
      AdaFunction          : Symbol;
      SubprogramParameters : Iterator;
      Abstraction          : Abstractions;
      GlobalVariables      : Iterator;
   begin

      AdaFunction          := GetAdaFunction (ProofFunction);
      SubprogramParameters := FirstAdaSubprogramParameter (AdaFunction);

      if RawDict.GetSubprogramImplicitProofFunction (IsAbstract, AdaFunction) = ProofFunction then
         Abstraction := IsAbstract;
      else
         Abstraction := IsRefined;
      end if;

      if IsNullIterator (SubprogramParameters) then
         GlobalVariables := FirstGlobalVariable (Abstraction, AdaFunction);
         if not IsNullIterator (GlobalVariables) then
            SubprogramParameters :=
              Iterator'
              (ImplicitProofFunctionGlobalIterator,
               Abstraction,
               CurrentSymbol (GlobalVariables),
               GlobalVariables.Context);
         end if;
      else
         SubprogramParameters :=
           Iterator'(ImplicitProofFunctionParameterIterator, Abstraction, CurrentSymbol (SubprogramParameters), ProofFunction);
      end if;

      return SubprogramParameters;

   end FirstImplicitProofFunctionParameter;

   --------------------------------------------------------------------------------

begin
   case RawDict.GetSymbolDiscriminant (Subprogram) is
      when SubprogramSymbol =>
         SubprogramParameters := FirstAdaSubprogramParameter (Subprogram);
      when TypeSymbol => -- a task type has no parameters
         SubprogramParameters := NullIterator;
      when others =>
         SubprogramParameters := FirstImplicitProofFunctionParameter (Subprogram);
   end case;
   return SubprogramParameters;
end FirstSubprogramParameter;
