-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddBody
  (CompilationUnit : in Symbol;
   Comp_Unit       : in ContextManager.UnitDescriptors;
   TheBody         : in Location;
   Hidden          : in Boolean) is

   Scope       : Scopes;
   Declaration : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteBody (CompilationUnit : in Symbol;
                        TheBody         : in Location;
                        Hidden          : in Boolean)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CompilationUnit,
   --#                                Dict,
   --#                                Hidden,
   --#                                LexTokenManager.State,
   --#                                TheBody;
   is
   begin
      if SPARK_IO.Is_Open (Dict.TemporaryFile) then
         if Hidden then
            WriteString (Dict.TemporaryFile, "hidden ");
         end if;
         WriteString (Dict.TemporaryFile, "body of ");
         WriteName (Dict.TemporaryFile, CompilationUnit);
         WriteString (Dict.TemporaryFile, " is at ");
         WriteLocation (Dict.TemporaryFile, TheBody);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteBody;

   --------------------------------------------------------------------------------

begin
   if not HasBodyStub (CompilationUnit) then

      Scope := GetScope (CompilationUnit);

      if RawDict.GetSymbolDiscriminant (CompilationUnit) = PackageSymbol
        and then RawDict.GetPackageParent (CompilationUnit) /= NullSymbol then -- adding child package body
         RawDict.CreateDeclaration
           (Item        => CompilationUnit,
            Context     => ProgramContext,
            Comp_Unit   => Comp_Unit,
            Loc         => TheBody.Start_Position,
            Declaration => Declaration);
         RawDict.SetDeclarationScope (Declaration, Scope);
      else
         if IsVisibleScope (Scope) or else IsPrivateScope (Scope) then
            Scope := GetLocalScope (Scope);
         end if;

         AddDeclaration
           (Item        => CompilationUnit,
            Comp_Unit   => Comp_Unit,
            Loc         => TheBody,
            Scope       => Scope,
            Context     => ProgramContext,
            Declaration => Declaration);

      end if;

      case RawDict.GetSymbolDiscriminant (CompilationUnit) is
         when PackageSymbol =>
            RawDict.SetPackageBody (CompilationUnit, Declaration);
         when TypeSymbol =>
            if RawDict.GetTypeDiscriminant (CompilationUnit) = ProtectedType then
               RawDict.SetProtectedTypeBody (CompilationUnit, Declaration);
            elsif RawDict.GetTypeDiscriminant (CompilationUnit) = TaskType then
               RawDict.SetTaskTypeBody (CompilationUnit, Declaration);
            end if;
         when others =>
            RawDict.SetSubprogramBody (CompilationUnit, Declaration);
      end case;

   end if;

   case RawDict.GetSymbolDiscriminant (CompilationUnit) is
      when PackageSymbol =>
         RawDict.SetPackageHasProperBody (CompilationUnit);
      when TypeSymbol =>
         if RawDict.GetTypeDiscriminant (CompilationUnit) = ProtectedType then
            RawDict.SetProtectedTypeHasProperBody (CompilationUnit);
         elsif RawDict.GetTypeDiscriminant (CompilationUnit) = TaskType then
            RawDict.SetTaskTypeHasProperBody (CompilationUnit, Hidden);
         end if;
      when others =>
         RawDict.SetSubprogramHasProperBody (CompilationUnit, Hidden);
   end case;

   WriteBody (CompilationUnit, TheBody, Hidden);

end AddBody;
