-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;
with Version;

package body Banner is

   procedure Put_String (S : String)
   --# global in out SPARK_IO.File_Sys;
   is
   begin
      SPARK_IO.Put_String (SPARK_IO.Standard_Output, S, 0);
   end Put_String;

   procedure Put_Char (C : Character)
   --# global in out SPARK_IO.File_Sys;
   is
   begin
      SPARK_IO.Put_Char (SPARK_IO.Standard_Output, C);
   end Put_Char;

   procedure Put_Line (S : String)
   --# global in out SPARK_IO.File_Sys;
   is
   begin
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, S, 0);
   end Put_Line;

   procedure New_Line
   --# global in out SPARK_IO.File_Sys;
   is
   begin
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, Positive'First);
   end New_Line;

   procedure Show_Banner (Plain_Mode : in Boolean) is
   begin
      Put_String ("Victor Wrapper");
      if not Plain_Mode then
         Put_Char (' ');
         Put_String (Version.Toolset_Banner_Line);
      end if;
      New_Line;
      Put_Line ("Using ViCToR (vct) which is currently an unsupported experimental feature.");
   end Show_Banner;

   procedure Show_Help (Plain_Mode : in Boolean) is
   begin
      Put_Line ("Usage: victor [OPTIONS] UNIT_NAME");
      New_Line;
      Put_Line ("UNIT_NAME is set of VCs to prove. For example, for the VC's");
      Put_Line ("   contained in foo/bar.vcg, specify 'foo/bar' as the unit name.");
      New_Line;
      Put_Line ("OPTIONS can be one or more of the below:");
      Put_Line ("   -h / -help   Show this help message.");
      Put_Line ("   -t=N         Time-out ViCToR after N seconds. Default is 5 seconds.");
      Put_Line ("   -m=X         Limit ViCToR to X MiB of virtual memory.");
      Put_Line ("   -v           Ignore .siv files and only use .vcg files.");
      Put_Line ("   -plain       Plain mode - supress timings and versions.");
      --  Put_Line ("   -solver=X    Select a different SMT solver. Possible values are:");
      --  Put_Line ("                   alt-ergo [default] (Shipped with SPARK)");
      --  Put_Line ("                   cvc3               (http://www.cs.nyu.edu/acsys/cvc3)");
      --  Put_Line ("                   yices              (http://yices.csl.sri.com)");
      --  Put_Line ("                   z3                 (http://research.microsoft.com/projects/z3)");
      New_Line;
      Put_Line ("Please note the -t and -m options are available only on Linux.");
      if not Plain_Mode then
         New_Line;
         Put_Line (Version.Toolset_Support_Line1);
         Put_Line (Version.Toolset_Support_Line2);
         Put_Line (Version.Toolset_Support_Line3);
         Put_Line (Version.Toolset_Support_Line4);
      end if;
   end Show_Help;

end Banner;
