-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Sparklalr_IO;
with Sparklalr_Common;
--# inherit Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_IO;

package Sparklalr_Error
--# own State;
is

   Error_Max : constant := 25;

   subtype Error_Range is Natural range 0 .. Error_Max;
   subtype Err_Col_T is Natural range 0 .. Sparklalr_Common.Line_Length;

   procedure Initialise (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_IO.Inputs;
   --#           out State;
   --# derives Sparklalr_IO.Inputs,
   --#         State               from F,
   --#                                  Sparklalr_Char_Class.Charmap,
   --#                                  Sparklalr_IO.Inputs;

   procedure Syn_Error (Error_Num : in Error_Range;
                        Col       : in Err_Col_T);
   --# global in out State;
   --# derives State from *,
   --#                    Col,
   --#                    Error_Num;

   procedure Error (F : in Sparklalr_IO.File_Type;
                    N : in Integer);
   --# global in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   F,
   --#                                   N &
   --#         State                from *;

   procedure Write_The_Line (F, Echo : in     Sparklalr_IO.File_Type;
                             Col     : in out Err_Col_T);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Col                  from  &
   --#         Sparklalr_IO.Inputs  from *,
   --#                                   F,
   --#                                   Sparklalr_Char_Class.Charmap,
   --#                                   State &
   --#         Sparklalr_IO.Outputs from *,
   --#                                   Col,
   --#                                   Echo,
   --#                                   State &
   --#         State                from *,
   --#                                   Col;

   procedure Set_Line_Out (I : in Err_Col_T;
                           C : in Character);
   --# global in out State;
   --# derives State from *,
   --#                    C,
   --#                    I;

   procedure List_Line_Errors (F   : in Sparklalr_IO.File_Type;
                               Col : in Err_Col_T);
   --# global in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   Col,
   --#                                   F,
   --#                                   State &
   --#         State                from *;

   -- Getter
   function Get_Prod_Err return Boolean;
   --# global in State;

end Sparklalr_Error;
