-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SLI;

separate (Sem.CompUnit.Wf_Full_Type_Declaration)
procedure wf_enum
  (Node       : in STree.SyntaxNode;
   Scope      : in Dictionary.Scopes;
   Ident_Node : in STree.SyntaxNode;
   DecLoc     : in LexTokenManager.Token_Position) is
   It                       : STree.Iterator;
   NextNode                 : STree.SyntaxNode;
   EnumSym                  : Dictionary.Symbol;
   ItemStr                  : LexTokenManager.Lex_String;
   PosNumber, LastPosNumber : Maths.Value;
   UnusedErrCode            : Maths.ErrorCode;
   StoreRep                 : LexTokenManager.Lex_String;

begin
   -- ASSUME Node = enumeration_type_definition
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Node) = SPSymbols.enumeration_type_definition,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Node = enumeration_type_definition in Wf_Enum");
   -- ASSUME Ident_Node = identifier
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Ident_Node) = SPSymbols.identifier,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Ident_Node = identifier in Wf_Enum");
   Dictionary.AddEnumerationType
     (Name            => Node_Lex_String (Node => Ident_Node),
      Comp_Unit       => ContextManager.Ops.Current_Unit,
      Declaration     => Dictionary.Location'(Start_Position => DecLoc,
                                              End_Position   => DecLoc),
      Scope           => Scope,
      Context         => Dictionary.ProgramContext,
      EnumerationType => EnumSym);
   if ErrorHandler.Generate_SLI then
      SLI.Generate_Xref_Symbol
        (Comp_Unit      => ContextManager.Ops.Current_Unit,
         Parse_Tree     => Ident_Node,
         Symbol         => EnumSym,
         Is_Declaration => True);
   end if;
   PosNumber := Maths.ZeroInteger;

   It := Find_First_Node (Node_Kind    => SPSymbols.identifier,
                          From_Root    => Node,
                          In_Direction => STree.Down);

   while not STree.IsNull (It) loop
      NextNode := Get_Node (It => It);
      ItemStr  := Node_Lex_String (Node => NextNode);
      if Dictionary.IsDefined (Name              => ItemStr,
                               Scope             => Scope,
                               Context           => Dictionary.ProofContext,
                               Full_Package_Name => False) then
         ErrorHandler.Semantic_Error
           (Err_Num   => 10,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => NextNode),
            Id_Str    => ItemStr);
      else
         Maths.StorageRep (PosNumber, StoreRep);
         Dictionary.AddEnumerationLiteral
           (Name        => ItemStr,
            Comp_Unit   => ContextManager.Ops.Current_Unit,
            Declaration => Dictionary.Location'(Start_Position => Node_Position (Node => NextNode),
                                                End_Position   => Node_Position (Node => NextNode)),
            Position    => StoreRep,
            The_Type    => EnumSym);

         LastPosNumber := PosNumber;
         --# accept Flow, 10, UnusedErrCode, "Expected ineffective assignment";
         Maths.Add (LastPosNumber, -- flow error: UnusedErrCode
                    Maths.OneInteger,
                    --to get
                    PosNumber, UnusedErrCode);
         --# end accept;
      end if;
      It := STree.NextNode (It);
   end loop;
   --# accept Flow, 33, UnusedErrCode, "Expected to be neither referenced nor exported";
end wf_enum;
