-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-- Synopsis
-- This procedure checks the validity of a pragma elaborate_body for SPARK 95
--------------------------------------------------------------------------------
separate (Sem.CompUnit)
procedure wf_elaborate_body (PragmaNode : in STree.SyntaxNode;
                             PackSym    : in Dictionary.Symbol) is
   IdNode  : STree.SyntaxNode;
   ExpNode : STree.SyntaxNode;

   procedure CheckRepresentSameName (Exp_Node : in STree.SyntaxNode;
                                     Pack_Sym : in Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Exp_Node,
   --#                                         LexTokenManager.State,
   --#                                         Pack_Sym,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         Exp_Node,
   --#                                         LexTokenManager.State,
   --#                                         Pack_Sym;
   is
      IsChain          : Boolean;
      IdNode, NextNode : STree.SyntaxNode;
      Name             : LexTokenManager.Lex_String;
   begin
      Name   := Dictionary.GetSimpleName (Item => Pack_Sym);
      IdNode := Exp_Node;
      loop
         IsChain  := Next_Sibling (IdNode) = STree.NullNode;
         NextNode := Child_Node (IdNode);
         exit when not IsChain or NextNode = STree.NullNode;

         IdNode := NextNode;
      end loop;

      if IsChain
        and then Syntax_Node_Type (Node => IdNode) = SPSymbols.identifier
        and then LexTokenManager.Lex_String_Case_Insensitive_Compare
        (Lex_Str1 => Node_Lex_String (Node => IdNode),
         Lex_Str2 => Name) =
        LexTokenManager.Str_Eq then
         STree.Set_Node_Lex_String (Sym  => Pack_Sym,
                                    Node => IdNode);
      else
         ErrorHandler.Semantic_Error
           (Err_Num   => 606,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Exp_Node),
            Id_Str    => Name);
      end if;
   end CheckRepresentSameName;

   ------------------------------------------------------------------

begin --wf_elaborate_body
   IdNode := Child_Node (PragmaNode);
   if Dictionary.IsPackage (PackSym) and then Dictionary.GetScope (PackSym) = Dictionary.GlobalScope then   --legal, library-level
                                                                                                            --package
      Dictionary.SetPackageElaborateBodyFound (PackSym);
      ExpNode := Child_Node (Child_Node (Next_Sibling (IdNode)));
      if Syntax_Node_Type (Node => ExpNode) /= SPSymbols.ADA_expression then
         --wrong number of arguments
         ErrorHandler.Semantic_Error
           (Err_Num   => 605,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => IdNode),
            Id_Str    => LexTokenManager.Null_String);
      else
         CheckRepresentSameName (Exp_Node => ExpNode,
                                 Pack_Sym => PackSym);
      end if;

   else --not a library level package
      ErrorHandler.Semantic_Error
        (Err_Num   => 72,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => PragmaNode),
         Id_Str    => LexTokenManager.Elaborate_Body_Token);
   end if;
end wf_elaborate_body;
