-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit.WalkStatements)
procedure down_loop (Node  : in     STree.SyntaxNode;
                     Scope : in out Dictionary.Scopes) is
   IdentNode           : STree.SyntaxNode;
   IterationSchemeNode : STree.SyntaxNode; --898
   LoopSym             : Dictionary.Symbol;
   LoopIdent           : LexTokenManager.Lex_String;

begin
   Dictionary.AddLoop
     (Scope         => Scope,
      Comp_Unit     => ContextManager.Ops.Current_Unit,
      LoopStatement => Dictionary.Location'(Start_Position => Node_Position (Node => Node),
                                            End_Position   => Node_Position (Node => Node)),
      TheLoop       => LoopSym);

   IdentNode := Child_Node (Child_Node (Node));
   if Syntax_Node_Type (Node => IdentNode) = SPSymbols.identifier then
      LoopIdent := Node_Lex_String (Node => IdentNode);
      if Dictionary.IsDefined (Name              => LoopIdent,
                               Scope             => Scope,
                               Context           => Dictionary.ProofContext,
                               Full_Package_Name => False) then
         ErrorHandler.Semantic_Error
           (Err_Num   => 10,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => IdentNode),
            Id_Str    => LoopIdent);
      else
         Dictionary.AddLoopName (LoopIdent, LoopSym);
      end if;
   end if;

   --898
   -- check for an iteration scheme, if one is found then mark loop as having exits
   IterationSchemeNode := Child_Node (Node);
   if Syntax_Node_Type (Node => IterationSchemeNode) = SPSymbols.simple_name then --loop name found
      IterationSchemeNode := Next_Sibling (IterationSchemeNode);  --skip loop name
   end if;
   IterationSchemeNode := Child_Node (IterationSchemeNode);
   if Syntax_Node_Type (Node => IterationSchemeNode) = SPSymbols.iteration_scheme then
      Dictionary.MarkLoopHasExits (LoopSym);
   end if;
   --898

   Scope := Dictionary.LocalScope (LoopSym);
end down_loop;
