-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckBinaryOperator
  (Operator      : in     SPSymbols.SPSymbol;
   Left          : in     Exp_Record;
   Right         : in     Exp_Record;
   Scope         : in     Dictionary.Scopes;
   T_Stack       : in     TypeContextStack.TStackType;
   Op_Pos        : in     LexTokenManager.Token_Position;
   Left_Pos      : in     LexTokenManager.Token_Position;
   Right_Pos     : in     LexTokenManager.Token_Position;
   Convert       : in     Boolean;
   Is_Annotation : in     Boolean;
   Result        : in out Exp_Record) is
   Left_Type_Local, Right_Type_Local : Dictionary.Symbol;

   -------------------------------------------------------------

   function Mixed_Type_Mult_Or_Div
     (Op                    : SPSymbols.SPSymbol;
      Left_Type, Right_Type : Dictionary.Symbol;
      Scope                 : Dictionary.Scopes)
     return                  Boolean
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   is
   begin
      return (Op = SPSymbols.multiply or else Op = SPSymbols.divide)
        and then (Dictionary.IsFixedPointTypeMark (Right_Type, Scope)
                    or else Dictionary.IsFixedPointTypeMark (Left_Type, Scope)
                    or else (CommandLineData.Ravenscar_Selected
                               and then (Left_Type = Dictionary.GetPredefinedTimeSpanType
                                           or else Right_Type = Dictionary.GetPredefinedTimeSpanType)));
   end Mixed_Type_Mult_Or_Div;

   -------------------------------------------------------------

   procedure Hetero_Impl_Type_Conv (Left_Type, Right_Type : in out Dictionary.Symbol;
                                    Scope                 : in     Dictionary.Scopes)
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   --# derives Left_Type,
   --#         Right_Type from CommandLineData.Content,
   --#                         Dictionary.Dict,
   --#                         Left_Type,
   --#                         Right_Type,
   --#                         Scope;
   is
   begin
      if Dictionary.IsUniversalIntegerType (Left_Type)
        and then (Dictionary.IsFixedPointTypeMark (Right_Type, Scope)
                    or else (CommandLineData.Ravenscar_Selected and then Dictionary.IsPredefinedTimeType (Right_Type))) then
         Left_Type := Dictionary.GetPredefinedIntegerType;
      elsif Dictionary.IsUniversalIntegerType (Right_Type)
        and then (Dictionary.IsFixedPointTypeMark (Left_Type, Scope)
                    or else (CommandLineData.Ravenscar_Selected and then Dictionary.IsPredefinedTimeType (Left_Type))) then
         Right_Type := Dictionary.GetPredefinedIntegerType;
      elsif CommandLineData.Content.Language_Profile /= CommandLineData.SPARK83
        and then Dictionary.IsUniversalRealType (Right_Type)
        and then Dictionary.IsFixedPointTypeMark (Left_Type, Scope) then
         Right_Type := Dictionary.GetUniversalFixedType;
      elsif CommandLineData.Content.Language_Profile /= CommandLineData.SPARK83
        and then Dictionary.IsUniversalRealType (Left_Type)
        and then Dictionary.IsFixedPointTypeMark (Right_Type, Scope) then
         Left_Type := Dictionary.GetUniversalFixedType;
      end if;
   end Hetero_Impl_Type_Conv;

begin -- CheckBinaryOperator
   Left_Type_Local  := Dictionary.GetRootType (Left.Type_Symbol);
   Right_Type_Local := Dictionary.GetRootType (Right.Type_Symbol);
   -- suppress type conversion in case of fixed point * or /
   if Convert then
      if Mixed_Type_Mult_Or_Div
        (Op         => Operator,
         Left_Type  => Left_Type_Local,
         Right_Type => Right_Type_Local,
         Scope      => Scope) then
         Hetero_Impl_Type_Conv (Left_Type  => Left_Type_Local,
                                Right_Type => Right_Type_Local,
                                Scope      => Scope);
      else
         HomoImplTypeConv
           (Operator            => Operator,
            Left_Type           => Left_Type_Local,
            Right_Type          => Right_Type_Local,
            Left_Val            => Left.Value,
            Right_Val           => Right.Value,
            Left_Has_Operators  => Left.Has_Operators,
            Right_Has_Operators => Right.Has_Operators,
            Left_Pos            => Left_Pos,
            Right_Pos           => Right_Pos,
            Is_Annotation       => Is_Annotation,
            T_Stack             => T_Stack,
            Scope               => Scope);
      end if;
   end if;

   if not Dictionary.BinaryOperatorIsDefined (Operator, Left_Type_Local, Right_Type_Local) then
      Result := UnknownTypeRecord;
      if (Dictionary.IsUniversalIntegerType (Left_Type_Local)
            and then Dictionary.IsModularTypeMark (Right_Type_Local, Scope)) then
         ErrorHandler.Semantic_Error_Sym
           (Err_Num   => 804,
            Reference => ErrorHandler.No_Reference,
            Position  => Op_Pos,
            Sym       => Right_Type_Local,
            Scope     => Scope);
      elsif (Dictionary.IsUniversalIntegerType (Right_Type_Local)
               and then Dictionary.IsModularTypeMark (Left_Type_Local, Scope)) then
         ErrorHandler.Semantic_Error_Sym
           (Err_Num   => 805,
            Reference => ErrorHandler.No_Reference,
            Position  => Op_Pos,
            Sym       => Left_Type_Local,
            Scope     => Scope);
      else
         ErrorHandler.Semantic_Error_Sym2
           (Err_Num   => 35,
            Reference => ErrorHandler.No_Reference,
            Position  => Op_Pos,
            Sym       => Left_Type_Local,
            Sym2      => Right_Type_Local,
            Scope     => Scope);
      end if;
   elsif not Is_Annotation
     and then not Dictionary.BinaryOperatorIsVisible (Operator, Left_Type_Local, Right_Type_Local, Scope) then
      Result := UnknownTypeRecord;
      ErrorHandler.Semantic_Error
        (Err_Num   => 309,
         Reference => ErrorHandler.No_Reference,
         Position  => Op_Pos,
         Id_Str    => LexTokenManager.Null_String);
   else
      -- check whether equality of floats is being used
      if not Is_Annotation
        and then (Operator = SPSymbols.equals or else Operator = SPSymbols.not_equal)
        and then (Dictionary.ContainsFloat (Left_Type_Local) or else Dictionary.ContainsFloat (Right_Type_Local)) then
         ErrorHandler.Semantic_Warning (Err_Num  => 308,
                                        Position => Op_Pos,
                                        Id_Str   => LexTokenManager.Null_String);
      end if;
      Result.Type_Symbol := Dictionary.GetBinaryOperatorType (Operator, Left_Type_Local, Right_Type_Local);
   end if;
end CheckBinaryOperator;
