/*
 * TextFormatterFactory.cpp
 *
 *  Created on: Dec 7, 2008
 *      Author: Lorenzo Bettini <http://www.lorenzobettini.it>, (C) 2008
 *  Copyright: See COPYING file that comes with this distribution
 */

#include "TextFormatterFactory.h"

namespace srchiliteqt {

QtColorMap TextFormatterFactory::colorMap;

TextFormatterFactory::TextFormatterFactory() :
    defaultToMonospace(true) {
}

TextFormatterFactory::~TextFormatterFactory() {
}

bool TextFormatterFactory::hasFormatter(const string &key) const {
    return textFormatterMap.find(key) != textFormatterMap.end();
}

TextFormatterPtr TextFormatterFactory::getFormatter(const string &key) const {
    TextFormatterMap::const_iterator it = textFormatterMap.find(key);
    if (it != textFormatterMap.end()) {
        return it->second;
    } else {
        return TextFormatterPtr();
    }
}

void TextFormatterFactory::addFormatter(const string &key,
        TextFormatterPtr formatter) {
    textFormatterMap[key] = formatter;
}

}
