/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_GTK

#include "../player.h"
#include "gdaemon.h"
#include "../other.h"
#include "../admin.h"

int gpid=0;

/* It searchs the somaplayer binary program. */
void
on_dplayer_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  char p[SIZE_BUFFER];
  struct stat st;
  GtkWidget *dialog;

  snprintf (p, SIZE_BUFFER, SOMAPLAYER);
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  snprintf (p, SIZE_BUFFER, "/usr/bin/somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  snprintf (p, SIZE_BUFFER, "/usr/local/bin/somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  snprintf (p, SIZE_BUFFER, "./somaplayer");
  if (!lstat (p, &st))
    {
      run_gsplayer (p);
      return;
    }

  dialog = gtk_message_dialog_new (GTK_WINDOW (windaemon),
				   GTK_DIALOG_MODAL |
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				   _("SomaPlayer not found."));

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

char *
new_socket (void)
{
  static char buf[1024];
  struct stat st;
  int d = 0;

  while (d < 1000)
    {
      snprintf (buf, sizeof (buf), "%s/sds_splayer_%.3d.sock",
		g_get_tmp_dir (), d);

      if (lstat (buf, &st))
	return buf;
      d++;
    }

  return NULL;
}

/* Run the player */
void
run_gsplayer (char *a)
{
  int pid;
  char *argv[20];
  int i = 0;
  char s[1024];
  char *sock;

  argv[i++] = a;
  argv[i++] = "-g";

  if ((sock = new_socket ()))
    {
      argv[i++] = "-a";

      snprintf (s, sizeof (s), "type=u,socket=%s", sock);
      argv[i++] = s;
    }

  argv[i++] = "-ao";
  argv[i++] = "sds";
  argv[i++] = "-ad";

  if (play->daemon->socket == SOCKET_TCP)
    argv[i++] = "tcp://localhost";
  else
    argv[i++] = "unix";

  argv[i++] = NULL;

  switch ((pid = fork ()))
    {
    case -1:
      fatal (_("Fork error."));
    case 0:
      execve (argv[0], argv, env);
      break;
    default:
      gpid++;

      break;
    }
}

/* Check the program. If someone exists, I use a waitpid. */
int
gtimeout (gpointer t)
{
  int p;

  play->go_graphic = 1;

  if (!gpid)
    return 1;

  p = waitpid (0, NULL, WNOHANG);
  if (p) gpid--;

  return 1;
}

#endif

/* EOF */
