#!/usr/bin/python
import sys
import urllib
import os
import zipfile
import glob
cachedir = "../pkg-cache"
srcdir = "../src-cache"


def gnome_bin_url(app, ver):
    short_ver = "%s.%s" % (ver.split(".")[0], ver.split(".")[1])
    return "http://ftp.gnome.org/pub/gnome/binaries/win32/%(app)s/%(short_ver)s/%(app)s_%(ver)s_win32.zip" % locals()

def gnome_src_url(app, ver):
    short_ver = "%s.%s" % (ver.split(".")[0], ver.split(".")[1])
    ver = ver.split("-")[0]
    return"http://ftp.gnome.org/pub/gnome/sources/%(app)s/%(short_ver)s/%(app)s-%(ver)s.tar.bz2" % locals()

urls = {}
for app, ver in (("glib", "2.22.3-1"),
     ("gtk+", "2.18.5-1"),
     ("pango", "1.26.1-1"),
     ("atk", "1.28.0-1")):
    urls[app] = {'bin': gnome_bin_url(app, ver),
                 'src': gnome_src_url(app, ver)}
urls['cairo'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/cairo_1.8.8-3_win32.zip",
    'src': "http://cairographics.org/releases/cairo-1.8.8.tar.gz"}
urls['zlib'] = {
    'bin': "http://www.zlib.net/zlib124-dll.zip",
    'src': "http://www.zlib.net/zlib-1.2.4.tar.gz",
}
urls['fontconfig'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/fontconfig_2.8.0-1_win32.zip",
    'src': "http://www.fontconfig.org/release/fontconfig-2.8.0.tar.gz",
}
urls['freetype'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/freetype_2.3.11-1_win32.zip",
    'src': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/freetype-2.3.9.tar.bz2",
}
urls['expat'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/expat_2.0.1-1_win32.zip",
    'src': "http://downloads.sourceforge.net/project/expat/expat/2.0.1/expat-2.0.1.tar.gz",
}
urls['gettext-runtime'] = {
  'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/gettext-runtime-0.17-1.zip",
  'src': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/gettext-0.17.tar.gz"}
urls['libpng'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/libpng_1.2.39-1_win32.zip",
    'src': "http://download.sourceforge.net/libpng/libpng-1.2.39.tar.gz"
}
urls['libtiff'] = {
    'bin': "http://ftp.gnome.org/pub/gnome/binaries/win32/dependencies/libtiff-3.8.2.zip",
    'src': "ftp://ftp.remotesensing.org/pub/libtiff/tiff-3.9.1.tar.gz"
}


def get_files(key, savedir):
    if not os.path.exists(savedir):
        os.mkdir(savedir)
    for app in urls:
        if key not in urls[app]:
            continue
        url = urls[app][key]
        fn = os.path.join(savedir, url.split("/")[-1])
        if not os.path.exists(fn):
            print "Downloading:", fn
            sys.stdout.flush()
            urllib.urlretrieve(url, fn)
        else:
            print "File already here:", fn

def unpack():
    for app in urls:
        f = os.path.join(cachedir, urls[app]['bin'].split("/")[-1])
        print "unzipping:", f
        sys.stdout.flush()
        z = zipfile.ZipFile(f)
        for n in z.namelist():
            if n.endswith("/"):
                continue
            dir = os.path.join("win32", os.path.dirname(n))
            if not os.path.exists(dir):
                os.makedirs(dir)
            outfile = open(os.path.join("win32", n), 'wb')
            outfile.write(z.read(n))
            outfile.close()

if sys.argv[1] == 'bin':
    get_files('bin', cachedir)
elif sys.argv[1] == 'src':
    get_files('src', scdir)
elif sys.argv[1] == 'unpack':
    unpack()

