/*
 * ------------------------------------------------------------------------------
 *  Compose a FS-Forth UNC90 module with development board 
 *
 * (C) 2006 Jochen Karrer
 *   Author: Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * -----------------------------------------------------------------------------
 */

#include <errno.h>
#include <stdint.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <termios.h>
#include <sys/ioctl.h>

#include <dram.h>
#include <sram.h>
#include <idecode.h>
#include <signode.h>
#include <mmu.h>
#include <fio.h>
#include <bus.h>
#include <amdflash.h>
#include <configfile.h>
#include <phy.h>
#include <debugserver.h>
#include <loader.h>
#include <boards.h>
#include <lxt971a.h>
#include <at91_usart.h>
#include <at91_tc.h>
#include <at91_twi.h>
#include <at91_emac.h>
#include <at91_aic.h>
#include <i2c_serdes.h>
#include <m24cxx.h>
#include <at91_mc.h>
#include <at91_st.h>
#include <at91_pmc.h>
#include <at91_pio.h>
#include <ds1337.h>
#include <usb_ohci.h>
#include <clock.h>
#include <at91_ebi.h>

static void
create_clock_links()
{
	/* This is wrong ! does not use the clock enables */
	Clock_Link("st.slck","pmc.slck");	
	Clock_Link("usart0.mck","pmc.pc_usart0");
	Clock_Link("usart1.mck","pmc.pc_usart1");
	Clock_Link("usart2.mck","pmc.pc_usart2");
	Clock_Link("usart3.mck","pmc.pc_usart3");
	Clock_Link("twi.clk","pmc.pc_twi");
	Clock_Link("timer0.ch0.mck","pmc.pc_tc0");
	Clock_Link("timer0.ch0.slck","pmc.slck");
	Clock_Link("timer0.ch1.mck","pmc.pc_tc1");
	Clock_Link("timer0.ch1.slck","pmc.slck");
	Clock_Link("timer0.ch2.mck","pmc.pc_tc2");
	Clock_Link("timer0.ch2.slck","pmc.slck");
	Clock_Link("timer1.ch0.mck","pmc.pc_tc3");
	Clock_Link("timer1.ch0.slck","pmc.slck");
	Clock_Link("timer1.ch1.mck","pmc.pc_tc4");
	Clock_Link("timer1.ch1.slck","pmc.slck");
	Clock_Link("timer1.ch2.mck","pmc.pc_tc5");
	Clock_Link("timer1.ch2.slck","pmc.slck");
}

static void
create_signal_links()
{
        /* Connect the interrupt controller to the CPU */
        SigName_Link("arm.irq","aic.irq");
        SigName_Link("arm.fiq","aic.fiq");

	//SigName_Link("bla","aic.irq0");
	SigName_Link("st.irq","aic.irq1");
	SigName_Link("pioa.irq","aic.irq2");
	SigName_Link("piob.irq","aic.irq3");
	SigName_Link("pioc.irq","aic.irq4");
	SigName_Link("piod.irq","aic.irq5");
	SigName_Link("usart0.irq","aic.irq6");
	SigName_Link("usart1.irq","aic.irq7");
	SigName_Link("usart2.irq","aic.irq8");
	SigName_Link("usart3.irq","aic.irq9");
	//SigName_Link("msi.irq","aic.irq10");
	//SigName_Link("udp.irq","aic.irq11");
	SigName_Link("twi.irq","aic.irq12");
	//SigName_Link("spi.irq","aic.irq13");
	//SigName_Link("ssc0.irq","aic.irq14");
	//SigName_Link("ssc1.irq","aic.irq15");
	//SigName_Link("ssc2.irq","aic.irq16");
	//SigName_Link("ssc2.irq","aic.irq16");
	SigName_Link("timer0.ch0.irq","aic.irq17");
	SigName_Link("timer0.ch1.irq","aic.irq18");
	SigName_Link("timer0.ch2.irq","aic.irq19");
	SigName_Link("timer1.ch0.irq","aic.irq20");
	SigName_Link("timer1.ch1.irq","aic.irq21");
	SigName_Link("timer1.ch2.irq","aic.irq22");
	SigName_Link("uhp.irq","aic.irq23");
	SigName_Link("emac.irq","aic.irq24");

	/* Link the TWI (I2C) Bus */	
        SigName_Link("i2cbus.sda","twi.sda");
        SigName_Link("i2cbus.scl","twi.scl");
	SigName_Link("i2cbus.cfg_eeprom.wc","GND");
}

static void
create_i2c_devices()
{
        I2C_Slave *i2c_slave;
        I2C_SerDes *i2c_serdes;
        i2c_serdes = I2C_SerDesNew("i2cbus");

        /* Configuration EEPRom with 64kBit */
        i2c_slave = M24Cxx_New("M24C64","i2cbus.cfg_eeprom");
        I2C_SerDesAddSlave(i2c_serdes,i2c_slave,0x50);
        i2c_slave = DS1337_New("i2cbus.ds1337");
        I2C_SerDesAddSlave(i2c_serdes,i2c_slave,0x68);
}

static int
board_unc90_create()
{
        ArmCoprocessor *copro;
        BusDevice *dev;
	BusDevice *mc;
        BusDevice *dram0 = NULL;
	PHY_Device *phy;

        Bus_Init(MMU_InvalidateTlb,4*1024);
        ARM9_New();
        copro = MMU_Create("mmu",en_LITTLE_ENDIAN,MMU_ARM920T);
        ARM9_RegisterCoprocessor(copro,15);

	/* 
	 * First create the memory controller. It is required by other devices 
	 */
	mc = AT91Mc_New("mc"); 
        Mem_AreaAddMapping(mc,0xffffff00,0x10,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = OhciHC_New("uhp",MainBus);
        Mem_AreaAddMapping(dev,0x00300000,0x00100000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	OhciHC_Enable(dev);

	dev=AMDFlashBank_New("flash0");
	if(dev) {
		AT91Mc_RegisterDevice(mc,dev,AT91_AREA_EXMEM0);
	}

        dram0 = dev = DRam_New("dram0");
        if(dev) {
                Mem_AreaAddMapping(dev,0x20000000,0x10000000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
        }

	dev = AT91Tc_New("timer0");
        Mem_AreaAddMapping(dev,0xfffa0000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Tc_New("timer1");
        Mem_AreaAddMapping(dev,0xfffa4000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = AT91Twi_New("twi");
        Mem_AreaAddMapping(dev,0xfffb8000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	
	dev = AT91Emac_New("emac");
	Mem_AreaAddMapping(dev,0xfffbc000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	phy=Lxt971a_New();
        AT91Emac_RegisterPhy(dev,phy,1);

	dev = AT91Usart_New("usart0");
	Mem_AreaAddMapping(dev,0xfffc0000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Usart_New("usart1");
	Mem_AreaAddMapping(dev,0xfffc4000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Usart_New("usart2");
	Mem_AreaAddMapping(dev,0xfffc8000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Usart_New("usart3");
	Mem_AreaAddMapping(dev,0xfffcc000,0x00004000,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Aic_New("aic");
	Mem_AreaAddMapping(dev,0xfffff000,0x00000200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = AT91Pio_New("pioa");
	Mem_AreaAddMapping(dev,0xfffff400,0x00000200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Pio_New("piob");
	Mem_AreaAddMapping(dev,0xfffff600,0x00000200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Pio_New("pioc");
	Mem_AreaAddMapping(dev,0xfffff800,0x00000200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Pio_New("piod");
	Mem_AreaAddMapping(dev,0xfffffa00,0x00000200,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

	dev = AT91Pmc_New("pmc");
	Mem_AreaAddMapping(dev,0xfffffc00,0x00000100,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91St_New("st");
	Mem_AreaAddMapping(dev,0xfffffd00,0x00000100,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);
	dev = AT91Ebi_New("ebi");
	Mem_AreaAddMapping(dev,0xffffff60,0x00000080,MEM_FLAG_WRITABLE | MEM_FLAG_READABLE);

        dev = SRam_New("sram0");
        if(dev) {
		AT91Mc_RegisterDevice(mc,dev,AT91_AREA_SRAM);
        }
	create_i2c_devices();
	create_signal_links();
	create_clock_links();
	return 0;
}

static void
board_unc90_run(Board *bd) {
        ARM9_Run();
}

#define DEFAULTCONFIG \
"[global]\n" \
"start_address: 0x00000000\n"\
"cpu_clock: 158515200\n"\
"\n"\
"[flash0]\n" \
"type: AM29LV128ML\n"\
"chips: 1\n"\
"\n" \
"[dram0]\n"\
"size: 32M\n"\
"\n" \
"[sram0]\n"\
"size: 16k\n"\
"\n"\

Board board_unc90 = {
        .name = "UNC90",
        .description =  "FS-Forth UNC90",
        .createBoard =  board_unc90_create,
        .runBoard =     board_unc90_run,
        .defaultconfig = DEFAULTCONFIG
};

void
_init() {
        fprintf(stderr,"Loading UNC90 Board module\n");
        Board_Register(&board_unc90);
}

