from __future__ import division
from math import cos, sin, sqrt
import random, pygame
import data
from OpenGL.GL import *
import random
import settings

import rabbyt


class SnowParticles:
    def __init__(self, x, y, direction, numparticles):
        self.x = x
        self.y = y

        self.particles = []

        dt = 400

        self.start = rabbyt.get_time()
        self.end = self.start + dt

        for i in xrange(numparticles):
            dx, dy = direction
            dx += (random.random() -1) * 30
            dy += (random.random() -1) * 30
            tex = data.snowparticle
            s = rabbyt.Sprite(tex.texture_id, tex.get_shape_pos(),
                    tex.get_shape_tex())
            s.x = rabbyt.lerp(x, x+dx, dt=dt)
            s.y = rabbyt.lerp(y, y+dy, dt=dt)
            s.rgba = (1,1,1, rabbyt.lerp(1, 0, self.start+dt/2, self.end))
            self.particles.append(s)

    def run(self, timestep):

        if rabbyt.get_time() < self.end:
            rabbyt.render_unsorted(self.particles)
            return True
        else:
            return False



class Snowball:
    @classmethod
    def throw_at_target(cls, penguin, target_penguin):
        """
        Starts the snowball with being thrown as a specified target, with
        random accuracy.
        """
        x, y = penguin.x*32, penguin.y*32

        if penguin.x <= target_penguin.x + 3 and penguin.x >= target_penguin.x - 3\
        and penguin.y <= target_penguin.y + 3 and penguin.y >= target_penguin.y - 3:
            t_x_t = target_penguin.x
            t_y_t = target_penguin.y
        else:
            t_x_t = random.randint(target_penguin.x-1,target_penguin.x+1)
            t_y_t = random.randint(target_penguin.y-1,target_penguin.y+1)

        end_tile = data.map.tiles[(t_x_t, t_y_t)]
        t_x = t_x_t*32+random.randint(0, 20)
        t_y = t_y_t*32+random.randint(0, 20) - end_tile.elevation *\
                data.map.elevation_multiplier

        start_tile = data.map.tiles[(penguin.x, penguin.y)]
        y -= start_tile.elevation*data.map.elevation_multiplier

        return cls(x,y,t_x,t_y,start_tile,end_tile,penguin)


    def __init__(self, x, y, t_x ,t_y, start_tile, end_tile, penguin=None):
        self.start_tile = start_tile
        self.end_tile = end_tile
        self.x, self.y = self.start_x, self.start_y = x, y
        self.t_x, self.t_y = t_x, t_y

        self.speed = .15
        self.y_offset = 0

        self.dist_x = self.t_x - self.x
        self.dist_y = self.t_y - self.y

        self.dist = (self.dist_x**2 + self.dist_y**2)**.5
        #self.remaining_dist = -self.dist/2
        self.total_time = self.dist/self.speed

        self.height = ((self.dist/2)/10)**2

        self.start_time = data.get_ticks()

        self.penguin = penguin

    def move(self):
        time_diff = data.get_ticks()-self.start_time
        to_move = time_diff*self.speed

        mx = (to_move*self.dist_x)/self.dist
        my = (to_move*self.dist_y)/self.dist

        self.x = self.start_x + mx
        self.y = self.start_y + my

        offset = -((to_move-self.dist/2)/10)**2 + self.height
        self.y_offset = offset/2

        if data.get_ticks() - self.start_time >= self.total_time:
            # Snowball reached dest.
            vw = data.view.w
            vh = data.view.h
            hit = 1
            if self.end_tile.resource:
                hit = 0
            else:
                for u in data.map.unit_nodes.get_objs_around_tile(
                        (self.end_tile.x, self.end_tile.y)):
                    #if u.player is not self.player:
                    if u.warmth > 0:
                        if u.state != "inbuilding":
                            v = u.detect_hit(self)
                            if v == 2: hit = 2

            if hit != 2 and int(settings.get_option("snowballdetail")) >= 2:
                if self.end_tile.type == "snow":
                    data.snowballimprents.add(self.x, self.y)
                else:
                    data.snowball_ice_imprents.add(self.x, self.y)

            if self.x > data.view.x and self.x < data.view.x+vw\
                    and self.y > data.view.y and self.y < data.view.y+vh:
                d = sqrt(self.dist_y*self.dist_y + self.dist_x*self.dist_x)
                y = self.dist_y * (30/d)
                x = self.dist_x * (30/d)
                if hit == 2:
                    x, y = -x, -y
                    particles = random.randint(13,20)
                else:
                    particles = random.randint(8,10)

                if int(settings.get_option("snowballdetail")) == 3:
                    data.particles.add(SnowParticles(self.x, self.y, (x,y), particles))

            return True
        return False
