/*
 * Smuxi - Smart MUltipleXed Irc
 *
 * Copyright (c) 2008 Mirco Bauer <meebey@meebey.net>
 *
 * Full GPL License: <http://www.gnu.org/licenses/gpl.txt>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

using System;

namespace Smuxi.Common
{
    public static class Defines
    {
        public const string GitBranch   = "release/0.8.9";
        public const string GitCommitHash = "fe845eb";

        private static readonly string f_InstallPrefix = "/usr/local";
        private static readonly string f_DistVersion = "release/0.8.9/fe845eb";
        private static readonly string f_TwitterApiKey = "60QV2qQx9cS7y1BJDbgAA|2VgD6qQKddsF5HYQ0TrRgs3tFTnCwDONBmRlTmG658";

        public static string InstallPrefix {
            get {
                return f_InstallPrefix;
            }
        }

        public static string TwitterApiKey {
            get {
                return f_TwitterApiKey;
            }
        }

        public static string GitVersion {
            get {
                if (String.IsNullOrEmpty(GitBranch) ||
                    String.IsNullOrEmpty(GitCommitHash)) {
                    return String.Empty;
                }

                return String.Format("{0}/{1}", GitBranch, GitCommitHash);
            }
        }

        public static string DistVersion {
            get {
                return f_DistVersion;
            }
        }
    }
}
