/***************************************************************************
    smb4kmounter_p  -  This is a private helper class for Smb4KMounter.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/


// application specific includes
#include "smb4kmounter_p.h"

Smb4KMounterPrivate::Smb4KMounterPrivate()
{
  timerTicks = 0;
  clearData();
}


Smb4KMounterPrivate::~Smb4KMounterPrivate()
{
}


void Smb4KMounterPrivate::clearData()
{
  m_workgroup = QString::null;
  m_host = QString::null;
  m_share = QString::null;
  m_ip = QString::null;
  m_path = QString::null;
  m_filesystem = QString::null;
  m_cifsLogin = QString::null;
}


const QString &Smb4KMounterPrivate::workgroup()
{
  return m_workgroup;
}


const QString &Smb4KMounterPrivate::host()
{
  return m_host;
}


const QString &Smb4KMounterPrivate::share()
{
  return m_share;
}


const QString &Smb4KMounterPrivate::ip()
{
  return m_ip;
}


const QString &Smb4KMounterPrivate::path()
{
  return m_path;
}


const QString &Smb4KMounterPrivate::filesystem()
{
  return m_filesystem;
}


const QString &Smb4KMounterPrivate::cifsLogin()
{
  return m_cifsLogin;
}


void Smb4KMounterPrivate::setWorkgroup( const QString &wg )
{
  m_workgroup = wg;
}


void Smb4KMounterPrivate::setHost( const QString &h )
{
  m_host = h;
}


void Smb4KMounterPrivate::setShare( const QString &s )
{
  m_share = s;
}


void Smb4KMounterPrivate::setIP( const QString &i )
{
  m_ip = i;
}


void Smb4KMounterPrivate::setPath( const QString &p )
{
  m_path = p;
}


void Smb4KMounterPrivate::setFileSystem( const QString &f )
{
  m_filesystem = f;
}


void Smb4KMounterPrivate::setCIFSLogin( const QString &l )
{
  m_cifsLogin = l;
}
