/***************************************************************************
    smb4knetworkbrowseritem  -  Smb4K's network browser list item.
                             -------------------
    begin                : Mo Jan 8 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KNETWORKBROWSERITEM_H
#define SMB4KNETWORKBROWSERITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qpixmap.h>

// KDE includes
#include <klistview.h>

// application specific includes
#include "../core/smb4knetworkitems.h"

class Smb4KNetworkBrowser;
class Smb4KNetworkBrowserItem : public KListViewItem
{
  public:
    /**
     * The constructor for toplevel (workgroup) items.
     *
     * @param parent        The parent list view.
     *
     * @param item          The Smb4KWorkgroupItem that carries all the data
     *                      needed to set up a "workgroup item".
     */
    Smb4KNetworkBrowserItem( QListView *parent, Smb4KWorkgroupItem *item );

    /**
     * The constructor for the host items.
     *
     * @param parent        The parent list view item.
     *
     * @param item          The Smb4KHostItem that carries all the data.
     */
    Smb4KNetworkBrowserItem( QListViewItem *parent, Smb4KHostItem *item );

    /**
     * The constructor for the share items.
     *
     * @param parent        The parent list view item.
     *
     * @param item          The Smb4KShareItem that carries all the data.
     */
    Smb4KNetworkBrowserItem( QListViewItem *parent, Smb4KShareItem *item );

    /**
     * The destructor.
     */
    virtual ~Smb4KNetworkBrowserItem();

    /**
     * Enumeration that determines the type of the item.
     */
    enum ItemType{ Workgroup, Host, Share };

    /**
     * This function returns the type of the item according to the ItemType
     * enumeration.
     *
     * @returns the type of the item.
     */
    Smb4KNetworkBrowserItem::ItemType type();

    /**
     * This function returns a pointer to the Smb4KWorkgroupItem object if it
     * is present or NULL if it is not.
     *
     * @returns a pointer to the workgroup item or NULL.
     */
    Smb4KWorkgroupItem *workgroupItem();

    /**
     * This function returns a pointer to the Smb4KHostItem object if it
     * is present or NULL if it is not.
     *
     * @returns a pointer to the host item or NULL.
     */
    Smb4KHostItem *hostItem();

    /**
     * This function returns a pointer to the Smb4KShareItem object if it
     * is present or NULL if it is not.
     *
     * @returns a pointer to the share item or NULL.
     */
    Smb4KShareItem *shareItem();

    /**
     * This function updates the internal Smb4KWorkgroupItem object.
     *
     * @param item          A Smb4KWorkgroupItem object
     */
    void update( Smb4KWorkgroupItem *item );

    /**
     * This function updates the internal Smb4KHostItem object and
     * changes the text that's being displayed in the browser. Use this,
     * if you have to alter the item in the browser.
     *
     * @param item          A Smb4KHostItem
     */
    void update( Smb4KHostItem *item );

    /**
     * This function updates the internal Smb4KShareItem object and
     * changes the text that's being displayed in the browser. Use this,
     * if you have to alter the item in the browser.
     *
     * @param item          A Smb4KShareItem
     */
    void update( Smb4KShareItem *item );

    /**
     * This is a convenience function. It returns TRUE if the item is a
     * printer share and FALSE otherwise.
     *
     * @returns TRUE if the item is a printer share and FALSE otherwise.
     */
    bool isPrinter();

    /**
     * Tell the item that the share it represents is mounted. The icon will be
     * changed by this function and the item text will be set to italic by
     * Smb4KNetworkBrowserItem::paintCell().
     *
     * @param mounted       TRUE if the share is mounted and FALSE otherwise
     */
    void setMounted( bool mounted = true );

    /**
     * Tells whether the respective share is shown as mounted or not. For non-share
     * items this function will always return FALSE.
     *
     * @returns TRUE if the share is mounted and FALSE otherwise.
     */
    bool isMounted();

    /**
     * Returns the icon of this item in "Desktop" size.
     *
     * @returns a pixmap
     */
    const QPixmap &desktopIcon() { return m_desktop_icon; }

  protected:
    /**
     * Reimplemented from QListViewItem.
     */
    void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

  private:
    /**
     * This function sets the icon of the item according to
     * the type and other factors.
     */
    void setIcon();

    /**
     * The type of the item.
     */
    ItemType m_type;

    /**
     * This enumeration enumerates the columns of the item.
     */
    enum Columns{ Network = 0, Type = 1, IP = 2, Comment = 3 };

    /**
     * The workgroup item
     */
    Smb4KWorkgroupItem m_workgroup;

    /**
     * The host item
     */
    Smb4KHostItem m_host;

    /**
     * The share item
     */
    Smb4KShareItem m_share;

    /**
     * Tells us that the share item is mounted
     */
    bool m_mounted;

    /**
     * The icon in "DesktopIcon" format
     */
    QPixmap m_desktop_icon;
};

#endif
