# Find PythonQt
#
# Sets PYTHONQT_FOUND, PYTHONQT_INCLUDE_DIR, PYTHONQT_LIBRARY, PYTHONQT_LIBRARIES
#

FIND_PATH(PYTHONQT_INSTALL_DIR include/PythonQt/PythonQt.h DOC "Directory where PythonQt was installed.")
FIND_PATH(PYTHONQT_INCLUDE_DIR PythonQt.h "${PYTHONQT_INSTALL_DIR}/include/PythonQt" DOC "Path to the PythonQt include directory")
FIND_LIBRARY(PYTHONQT_LIBRARY PythonQt PATHS "${PYTHONQT_INSTALL_DIR}/lib" DOC "The PythonQt library.")

# On linux, also find libutil
IF(NOT WIN32)
  FIND_LIBRARY(PYTHONQT_LIBUTIL util)
ENDIF(NOT WIN32)

MARK_AS_ADVANCED(PYTHONQT_INSTALL_DIR)
MARK_AS_ADVANCED(PYTHONQT_INCLUDE_DIR)
MARK_AS_ADVANCED(PYTHONQT_LIBRARY)

SET(PYTHONQT_FOUND 0)
IF (PYTHONQT_INCLUDE_DIR AND PYTHONQT_LIBRARY)
  SET(PYTHONQT_FOUND 1)
  SET(PYTHONQT_LIBRARIES ${PYTHONQT_LIBRARY} ${PYTHONQT_LIBUTIL})
ENDIF()
