
/* This code determines the # of frames in a GIF or M$OFT ANI animation */
/* It was written as an experiment for SLgtk imdisplay, but is unused.  */

static int nframes_gif(int fd)  /* {{{ */
{
   ssize_t nbytes;
   int i, last, nframes, leftover;
	
   leftover = nframes = 0;

   while (1) {

	if ( (nbytes = read(fd, buf+leftover, BUFSIZE-leftover)) <= 0)
	   break;

	i = 0;
	last = nbytes - 2;

	while (i < last) {
	   if (buf[i] == 33 && buf[i+1] == 249 && buf[i+2] == 4) {
		nframes++;
		i += 3;
	   }
	   else
		i++;
   	}

	if ( (leftover = nbytes - last) )
	   memcpy(buf, buf+i, leftover);
   }

   /* FIXME: remove this 1 frame business */
   /*return nframes> 0 ? nframes : 1;*/	/* even a static image has 1 frame */
   return nframes;		/* nframes = 0 implies a static image */
} /* }}} */

static int nframes_ani(int fd)  /* {{{ */
{
   ssize_t nbytes;
   int i, last, nsteps, leftover;
   unsigned char *p;

   leftover = nsteps = 0;

   while (1) {

	if ( (nbytes = read(fd, buf+leftover, BUFSIZE-leftover)) <= 0)
	   break;

	i = 0;
	last = nbytes - 3;

	while (i < last) {

	   p = buf + i;

	   if (p[0] == 'a' && p[1] == 'n' && p[2] == 'i' && p[3] == 'h')
	   {
		/* Windows .ani files contain both the # of frames which 
		   are physically stored in the file and a list of steps
		   indicating how the frames should be sequenced into an
		   animation; it is legal for a frame to appear more than
		   than once in the steps list, thus nsteps >= nframes
		   and we will return nsteps here instead of nframes */

		p += 16;
		nsteps = p[0] | (p[1] << 8) | (p[2] << 16) | (p[3] << 24);
		break;
	   }
	   else
		i++;
   	}

	if (nsteps)
		break;

	if ( (leftover = nbytes - last) )
	   memcpy(buf, buf+i, leftover);
   }

   /* FIXME: remove this 1 frame business */
   /*return nsteps > 0 ? nsteps : 1;*/	/* even a static image has 1 frame */
   return nsteps;		/* nframes = 0 implies a static image */
} /* }}} */

static int __animation_get_num_frames(char *fname)  /* {{{ */
{
   int fd, nframes = -1;

   if (fname == NULL)
	return -1;

   if ((fd = open(fname, O_RDONLY)) == -1) {
	fprintf(stderr ,"Could not open file: %s\n", fname);
	return -1;
   }

   /* Determine file type by reading first 4 bytes */
   if ( read(fd, buf, 4) == 4) {

	/* accept file type in upper or lower case */
	buf[0] = tolower(buf[0]);
	buf[1] = tolower(buf[1]);
	buf[2] = tolower(buf[2]);
	buf[3] = tolower(buf[3]);

	if (buf[0] == 'r' && buf[1] == 'i' && buf[2] == 'f' && buf[3] == 'f')
	   nframes = nframes_ani(fd);
	else if (buf[0] == 'g' && buf[1] == 'i' && buf[2] == 'f' && buf[3]=='8')
	   nframes = nframes_gif(fd);
   }

   if (nframes < 0)
	fprintf(stderr ,"Unrecognized file format: %s\n", fname);

   close(fd);

   return nframes;

} /* }}} */

static void sl_animation_get_num_frames()  /* {{{ */
{
   char *fname = NULL;

   if (usage_err(1, "int = _animation_get_num_frames(filename)") ||
					-1 == SLang_pop_slstring (&fname))
	return;

   SLang_push_int ( __animation_get_num_frames(fname) );
   SLang_free_slstring(fname);
}  /* }}} */

/*
MAKE_INTRINSIC_0("__animation_get_num_frames", sl_animation_get_num_frames, V),
*/
