static void sl_Gif_ImageFromRGBABuf(void) /* {{{ */
{
   Gif_Image* retval;
   SLang_Array_Type *arr = NULL;

   if (SLang_Num_Function_Args != 1 ||
	SLang_pop_array((SLang_Array_Type**)&arr) == -1 ||
	arr->num_dims < 1 || arr->num_dims > 3)
	USAGE("Gif_Image = Gif_ImageFromRGBABuf(3D_RGBA_image_array)");

   retval = Gif_ImageFromRGBABuf(arr->data,  arr->dims[1], arr->dims[0],
				arr->dims[2] == 2 ? 1 : arr->dims[2]);
   SLang_push_opaque(Gif_Image_Type, (void*)retval, 0);
   SLang_free_array(arr);
}  /* }}} */

static void sl_gif_reflect (void) /*{{{*/
{
   SLang_Array_Type* in = NULL;
   SLang_Array_Type* refl = NULL;
   int bpp;
   int width;
   int height;
   int which_axes;

   if (SLang_Num_Function_Args != 2 ||
	SLang_pop_int((int*)&which_axes) == -1 ||
	SLang_pop_array((SLang_Array_Type**)&in) == -1 ) {
	   SLang_verror(SLEU,(char*)"Usage: _gif_reflect(image_array, 1|2|3 [i.e. X axis | Y axis | or both])");
	   return;
	}

   bpp = in->sizeof_type;		/* at this point, bytes per pixel */
   switch(in->num_dims) {
	case 1:  width = in->dims[0]; height = 1; break;
	case 2:  width = in->dims[1]; height = in->dims[0]; break;
	case 3: if (bpp == 1 && in->dims[2] <= 4) {
		   bpp *= in->dims[2];
		   width = in->dims[1];
		   height = in->dims[0];
		   break;
		}
		/* fall through for >4D, or 3D not RGB, RGBA */
	default:
	   SLang_verror(SL_NOT_IMPLEMENTED,
	   	"Reflection of image of that type/dimensions unsupported");
	   goto done;
   }
   if (NULL == (refl = SLang_duplicate_array(in)))
	goto done;

   bpp *= 8;		/* now turn bytes per pixel into bits per */

   gif_reflect(refl->data,  bpp,  width,  height,  which_axes);
   SLang_push_array(refl, 1);

   done:
   SLang_free_array(in);
} /*}}}*/

void push_gif_rgba(Gif_RGBA *rgb) /* {{{ */
{
   int ndims, dims[3];
   SLang_Array_Type *at;

   dims[0] = rgb->height;
   dims[1] = rgb->width;
   dims[2] = rgb->nchannels;

   if (dims[2] == 1)		/* greyscale image is 2D */
	ndims = 2;
   else
	ndims = 3;		/* rgb & rgba are 3D */

   at = SLang_create_array (SLANG_UCHAR_TYPE, 0, rgb->pixels, dims, ndims);
   if (at == NULL) {
   	SLang_verror(SL_INTRINSIC_ERROR, "could not allocate gif RGBA array");
	return;
   }

   (void) SLang_push_array(at, 1);

   /* The S-Lang object now owns the pixels, so we destroy the RGBA object */
   rgb->pixels = NULL;
   Gif_DeleteRGBA(rgb);
}  /* }}} */

static SLang_Intrin_Fun_Type Manual_Funcs [] = /* {{{ */
{
   MAKE_INTRINSIC_0((char*)"Gif_ImageFromRGBABuf",sl_Gif_ImageFromRGBABuf,V),
   MAKE_INTRINSIC_0((char*)"gif_reflect",sl_gif_reflect,V),
   SLANG_END_INTRIN_FUN_TABLE
}; /* }}} */
