# Copyright 1997, 2000, 2001 Free Software Foundation, Inc. {{{

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
 
# serial 5 }}}

AC_PREREQ(2.52)

# AM_CONDITIONAL(NAME, SHELL-CONDITION) dnl {{{
# -------------------------------------
# Define a conditional.
AC_DEFUN([AM_CONDITIONAL],
[ifelse([$1], [TRUE],  [AC_FATAL([$0: invalid condition: $1])],
        [$1], [FALSE], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_SUBST([$1_TRUE])
AC_SUBST([$1_FALSE])
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi dnl }}}

AC_CONFIG_COMMANDS_PRE( dnl {{{
[if test -z "${$1_TRUE}" && test -z "${$1_FALSE}"; then
  AC_MSG_ERROR([conditional \"$1\" was never defined.
Usually this means the macro was only invoked conditionally.])
fi])])
dnl }}}

AC_DEFUN(AX_VERSION_PARSE, dnl#{{{
[
   num_fields=`echo $1 | awk -F. '{print NF}'`
   if test $num_fields -ne 3 ; then
	AC_MSG_ERROR([$1 not in <major>.<minor>.<patch> version form])
   fi
   AX_VERSION_MAJOR=`echo $1 | cut -d. -f1`
   AX_VERSION_MINOR=`echo $1 | cut -d. -f2`
   AX_VERSION_PATCH=`echo $1 | cut -d. -f3`
   major_ver=`echo $1 | awk -F. '{print  [$]1 * 10000}'`
   minor_ver=`echo $1 | awk -F. '{print  [$]2 * 100}'`
   patchlev=`echo $1 | awk -F. '{print [$]3}'`
   let AX_VERSION_INT=$major_ver+$minor_ver+$patchlev
])}}}

AC_DEFUN(JD_INIT, dnl {{{
[
#These variable are initialized by JD init function
CONFIG_DIR=`pwd`
cd $srcdir
if test "`pwd`" != "$CONFIG_DIR"
then 
  AC_MSG_ERROR("This software does not support configuring from another directory.   See the INSTALL file")
fi
AC_SUBST(CONFIG_DIR)dnl
# Note: these will differ if one is a symbolic link
if test -f /usr/bin/dirname; then
  JD_Above_Dir=`dirname $CONFIG_DIR`
else
# system is a loser
  JD_Above_Dir=`cd ..;pwd`
fi
JD_Above_Dir2=`cd ..;pwd`
])
dnl }}}

dnl# This function expand the "prefix variables.  For example, it will expand
dnl# values such as ${exec_prefix}/foo when ${exec_prefix} itself has a 
dnl# of ${prefix}.  This function produces the shell variables:
dnl# jd_prefix_libdir, jd_prefix_incdir
AC_DEFUN(JD_EXPAND_PREFIX, dnl#{{{
[
  if test "X$jd_prefix" = "X"
  then
    jd_prefix=$ac_default_prefix
    if test "X$prefix" != "XNONE"
    then
      jd_prefix="$prefix"
    fi
    jd_exec_prefix="$jd_prefix"
    if test "X$exec_prefix" != "XNONE"
    then
      jd_exec_prefix="$exec_prefix"
    fi
  
    dnl#Unfortunately, exec_prefix may have a value like ${prefix}, etc.
    dnl#Let the shell expand those.  Yuk.
    eval `sh <<EOF
      prefix=$jd_prefix
      exec_prefix=$jd_exec_prefix
      libdir=$libdir
      includedir=$includedir
      echo jd_prefix_libdir="\$libdir" jd_prefix_incdir="\$includedir"
EOF
`
  fi
])
#}}}

AC_DEFUN(JD_SET_OBJ_SRC_DIR, dnl {{{
[
#---------------------------------------------------------------------------
# Set the source directory and object directory.   The makefile assumes an
# abcolute path name.  This is because src/Makefile cds to OBJDIR and compiles
# the src file which is in SRCDIR
#---------------------------------------------------------------------------
SRCDIR=$CONFIG_DIR
if test "$1" != "."
then
  if test -z "$1"
  then
    SRCDIR=$SRCDIR/src
  else
    SRCDIR=$SRCDIR/$1
  fi
fi

OBJDIR=$SRCDIR/"$ARCH"objs
ELFDIR=$SRCDIR/elf"$ARCH"objs
AC_SUBST(SRCDIR)dnl
AC_SUBST(OBJDIR)dnl
AC_SUBST(ELFDIR)dnl
])dnl}}}

RPATH=""
AC_SUBST(RPATH)dnl

AC_DEFUN(JD_INIT_RPATH, dnl {{{
[
case "$host_os" in
  *linux*|*solaris* )
    if test "X$GCC" = Xyes
    then
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-Wl,-R,"
      else
        RPATH="-Wl,-R"
      fi
    else
      if test "X$ac_R_nospace" = "Xno"
      then
        RPATH="-R "
      else
	RPATH="-R"
      fi
    fi
  ;;
  *osf*)
    if test "X$GCC" = Xyes
    then
      RPATH="-Wl,-rpath,"
    else
      RPATH="-rpath "
    fi
  ;;
esac
])dnl}}}

AC_DEFUN(JD_SET_RPATH, dnl{{{
[
if test "X$1" != "X"
then
  if test "X$RPATH" = "X"
  then 
    JD_INIT_RPATH
    if test "X$RPATH" != "X"
    then
      RPATH="$RPATH$1"
    fi
  else
    RPATH="$RPATH:$1"
  fi
fi
])dnl}}}

IEEE_CFLAGS=""
AC_DEFUN(JD_IEEE_CFLAGS, dnl{{{
[
case "$host_cpu" in
  *alpha* )
    if test "$GCC" = yes
    then
      IEEE_CFLAGS="-mieee"
    else
      IEEE_CFLAGS="-ieee_with_no_inexact"
    fi
    ;;
  * )
    IEEE_CFLAGS=""
esac
])dnl}}}

AC_DEFUN(JD_ANSI_CC, dnl{{{
[

AC_PROG_CC
AC_PROG_CPP
AC_PROG_GCC_TRADITIONAL
AC_ISC_POSIX
AC_AIX

dnl #This stuff came from Yorick config script
dnl
dnl # HPUX needs special stuff
dnl
AC_EGREP_CPP(yes,
[#ifdef hpux
  yes
#endif
], [
AC_DEFINE(_HPUX_SOURCE)
if test "$CC" = cc; then CC="cc -Ae"; fi
])dnl
dnl
dnl #Be sure we've found compiler that understands prototypes
dnl
AC_MSG_CHECKING(C compiler that understands ANSI prototypes)
AC_TRY_COMPILE([ ],[
 extern int silly (int);], [
 AC_MSG_RESULT($CC looks ok.  Good.)], [
 AC_MSG_RESULT($CC is not a good enough compiler)
 AC_MSG_ERROR(Set env variable CC to your ANSI compiler and rerun configure.)
 ])dnl
])dnl }}}

AC_DEFUN(JD_ELF_COMPILER, dnl{{{
[

dnl #-------------------------------------------------------------------------
dnl # Check for dynamic linker
dnl #-------------------------------------------------------------------------
DYNAMIC_LINK_LIB=""
AC_CHECK_HEADER(dlfcn.h,[
  AC_DEFINE(HAVE_DLFCN_H)
  AC_CHECK_LIB(dl,dlopen,[
    DYNAMIC_LINK_LIB="-ldl"
    AC_DEFINE(HAVE_DLOPEN)
   ],[
    AC_CHECK_FUNC(dlopen,AC_DEFINE(HAVE_DLOPEN))
    if test "$ac_cv_func_dlopen" != yes
    then
      AC_MSG_WARN(cannot perform dynamic linking)
    fi
   ])])
AC_SUBST(DYNAMIC_LINK_LIB)

MODULE_MAJOR="\$(MODULE).\$(MAJOR_VERSION)"
MODULE_MAJOR_MINOR="\$(MODULE).\$(MAJOR_VERSION).\$(MINOR_VERSION).\$(MICRO_VERSION)"

dnl # ---------------------------------------------------------------------
dnl # Find path to GCC, since rest of macro requires it (added by mnoble)
dnl # ---------------------------------------------------------------------

CC_PATH=`AS_DIRNAME([$CC])`
AC_PATH_PROG([GCC_PATH],[gcc],[gcc],[$PATH:$CC_PATH:/usr/local/bin])
AC_PATH_PROG([STRIP],[strip],[:],[$PATH:/bin:/usr/bin:/usr/ccs/bin:/usr/local/bin])

SO_EXT=.so
gdktarget=x11

case "$host_os" in

  *linux* )
    DYNAMIC_LINK_FLAGS="-Wl,-export-dynamic"
    ELF_CC="$GCC_PATH"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"
    ELF_LINK="$GCC_PATH -shared -Wl,-soname#"
    ELF_LINK_CMD="\$(ELF_LINK),\$(MODULE_MAJOR)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
    ;;

  *solaris* )
    if test "$GCC" = yes ; then
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="$GCC_PATH"
      ELF_CFLAGS="\$(CFLAGS) -fPIC"
      ELF_LINK="$GCC_PATH -shared -Wl,-ztext -Wl,-h#"
      ELF_LINK_CMD="\$(ELF_LINK),\$(MODULE_MAJOR)"
      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
    else
      DYNAMIC_LINK_FLAGS=""
      ELF_CC="cc"
      ELF_CFLAGS="-K PIC"
      ELF_LINK="cc -G -h#"
      ELF_LINK_CMD="\$(ELF_LINK)\$(MODULE_MAJOR)"
      ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
      CC_SHARED="cc \$(CFLAGS) -G -K PIC"
      LIBGCC=`$GCC_PATH --print-file-name libgcc.a`
    fi
    ;;

   # osr5 or unixware7 with current or late autoconf
  *sco3.2v5* | *unixware-5* | *sco-sysv5uw7*)
     if test "$GCC" = yes
     then
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK="$GCC_PATH -shared -Wl,-h#"
       ELF_LINK_CMD="\$(ELF_LINK),\$(MODULE_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -G -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"
       # ELF_LINK="ld -G -z text -h#"
       ELF_LINK="cc -G -z text -h#"
       ELF_LINK_CMD="\$(ELF_LINK)\$(MODULE_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -G -K pic"
     fi
     ;;

  *irix6.5* )
     echo "Note: ELF compiler for host_os=$host_os may not be correct"
     echo "double-check: 'mode_t', 'pid_t' may be wrong!"
     if test "$GCC" = yes
     then
       # not tested
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="$GCC_PATH"
       ELF_CFLAGS="\$(CFLAGS) -fPIC"
       ELF_LINK="$GCC_PATH -shared -Wl,-h#"
       ELF_LINK_CMD="\$(ELF_LINK),\$(MODULE_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="$GCC_PATH \$(CFLAGS) -shared -fPIC"
     else
       DYNAMIC_LINK_FLAGS=""
       ELF_CC="cc"
       ELF_CFLAGS="-K pic"     # default anyhow
       ELF_LINK="cc -shared -o #"
       ELF_LINK_CMD="\$(ELF_LINK)\$(MODULE_MAJOR)"
       ELF_DEP_LIBS=
       CC_SHARED="cc \$(CFLAGS) -shared -K pic"
     fi
     ;;

  *darwin* )

     if test "$GCC" = yes ; then
	echo "#include <stdio.h>" > conftest.c
	echo "int main() { printf(\"%d.%d.%d\",__GNUC__,__GNUC_MINOR__,__GNUC_PATCHLEVEL__); return 0; }" >> conftest.c
	GCC_VERSION_STRING=`$GCC_PATH -o conftest conftest.c 2>&1; ./conftest`
	rm -f conftest.c conftest
	AX_VERSION_PARSE($GCC_VERSION_STRING)
	if test "$AX_VERSION_INT" -lt 34000 ; then
	   CFLAGS="$CFLAGS -no-cpp-precomp"
	fi
     fi
     DYNAMIC_LINK_FLAGS=""
     ELF_CC="cc"
     ELF_CFLAGS="\$(CFLAGS) -fno-common"
     ELF_LINK="cc -dynamiclib"
     dnl The Darwin linker didn't seem to like a compatibility version
     ELF_LINK_CMD="\$(ELF_LINK) -install_name \$(install_lib_dir)/\$(MODULE_MAJOR) -current_version \$(MAJOR_VERSION).\$(MINOR_VERSION)"
     ELF_DEP_LIBS="$LDFLAGS \$(DL_LIB)"
     CC_SHARED="cc -bundle -flat_namespace -undefined suppress \$(CFLAGS) -fno-common"
     ELFLIB="lib${PACKAGE_NAME}.dylib"
     MODULE_MAJOR="lib${PACKAGE_NAME}.\$(MAJOR_VERSION).dylib"
     MODULE_MAJOR_MINOR="lib${PACKAGE_NAME}.\$(MAJOR_VERSION).\$(MINOR_VERSION).dylib"
     STRIP=:
     ;;

  *cygwin* )

    gdktarget=win32
    SO_EXT=.dll
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS)"
    ELF_LINK="$CC -shared"
    ELF_LINK_CMD="\$(ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$CC \$(CFLAGS) -shared"
    ;;

  * )
    echo "Note: ELF compiler for host_os=$host_os may be wrong"
    ELF_CC="$CC"
    ELF_CFLAGS="\$(CFLAGS) -fPIC"
    ELF_LINK="$CC -shared"
    ELF_LINK_CMD="\$(ELF_LINK)"
    ELF_DEP_LIBS="\$(DL_LIB) -lm -lc"
    CC_SHARED="$CC \$(CFLAGS) -shared -fPIC"
esac

AC_SUBST(ELF_CC)
AC_SUBST(ELF_CFLAGS)
AC_SUBST(ELF_LINK)
AC_SUBST(ELF_LINK_CMD)
AC_SUBST(ELF_DEP_LIBS)
AC_SUBST(DYNAMIC_LINK_FLAGS)
AC_SUBST(CC_SHARED)
AC_SUBST(ELFLIB)
AC_SUBST(MODULE_MAJOR)
AC_SUBST(MODULE_MAJOR_MINOR)
AC_SUBST(STRIP)
]) dnl }}}

AC_DEFUN(AC_CC_DEBUG_INFO, dnl {{{
[
AC_ARG_ENABLE(ccdebug,
	      [  --enable-ccdebug	  include -g debug info in ALL compiled C code],
	      [ccdebug=$enableval])

if test -n "$ccdebug" ; then
    cflags_has_dash_g=`echo $CFLAGS | grep -w "\-g"`
    if test -z "$cflags_has_dash_g" ; then
	CFLAGS="-g $CFLAGS"
    fi
    ELF_CFLAGS="-g $ELF_CFLAGS"
fi
]) dnl }}}

dnl# This macro process the --with-xxx, --with-xxxinc, and --with-xxxlib
dnl# command line arguments and returns the values as shell variables
dnl# jd_xxx_include_dir and jd_xxx_library_dir.  It does not perform any
dnl# substitutions, nor check for the existence of the supplied values.
AC_DEFUN(JD_WITH_LIBRARY_PATHS, dnl#{{{
[
 JD_UPPERCASE($1,JD_ARG1)
 jd_$1_include_dir=""
 jd_$1_library_dir=""
 if test X"$jd_with_$1_library" = X
 then 
   jd_with_$1_library=""
 fi

 AC_ARG_WITH($1,
  [  --with-$1=DIR      Use DIR/lib and DIR/include for $1],
  [jd_with_$1_arg=$withval], [jd_with_$1_arg=unspecified])
  
 case "x$jd_with_$1_arg" in
   xno)
     jd_with_$1_library="no"
    ;;
   x)
    dnl# AC_MSG_ERROR(--with-$1 requires a value-- try yes or no)
    jd_with_$1_library="yes"
    ;;
   xunspecified)
    ;;
   xyes)
    jd_with_$1_library="yes"
    ;;
   *)
    jd_with_$1_library="yes"
    jd_$1_include_dir="$jd_with_$1_arg"/include
    jd_$1_library_dir="$jd_with_$1_arg"/lib
    ;;
 esac

 AC_ARG_WITH($1lib,
  [  --with-$1lib=DIR   $1 library in DIR],
  [jd_with_$1lib_arg=$withval], [jd_with_$1lib_arg=unspecified])
 case "x$jd_with_$1lib_arg" in
   xunspecified)
    ;;
   xno)
    ;;
   x)
    AC_MSG_ERROR(--with-$1lib requres a value)
    ;;
   *)
    jd_with_$1_library="yes"
    jd_$1_library_dir="$jd_with_$1lib_arg"
    ;;
 esac

 AC_ARG_WITH($1inc, 
  [  --with-$1inc=DIR   $1 include files in DIR],
  [jd_with_$1inc_arg=$withval], [jd_with_$1inc_arg=unspecified])
 case "x$jd_with_$1inc_arg" in
   x)
     AC_MSG_ERROR(--with-$1inc requres a value)
     ;;
   xunspecified)
     ;;
   xno)
     ;;
   *)
    jd_with_$1_library="yes"
    jd_$1_include_dir="$jd_with_$1inc_arg"
   ;;
 esac
])
dnl#}}}

dnl# This function checks for the existence of the specified library $1 with
dnl# header file $2.  If the library exists, then the shell variables will
dnl# be created: 
dnl#  jd_with_$1_library=yes/no, 
dnl#  jd_$1_inc_file
dnl#  jd_$1_include_dir
dnl#  jd_$1_library_dir
dnl# If $3 is present, then also look in $3/include+$3/lib
AC_DEFUN(JD_CHECK_FOR_LIBRARY, dnl#{{{
[
  AC_REQUIRE([JD_EXPAND_PREFIX])dnl
  dnl JD_UPPERCASE($1,JD_ARG1)
  JD_WITH_LIBRARY_PATHS($1)
  AC_MSG_CHECKING(for the $1 library and header files $2)
  if test X"$jd_with_$1_library" != Xno
  then
    jd_$1_inc_file=$2
    dnl# jd_with_$1_library="yes"

    if test "X$jd_$1_inc_file" = "X"
    then
       jd_$1_inc_file=$1.h
    fi

    if test X"$jd_$1_include_dir" = X
    then
      inc_and_lib_dirs="\
         $jd_prefix_incdir,$jd_prefix_libdir \
	 /usr/local/$1/include,/usr/local/$1/lib \
	 /usr/local/include/$1,/usr/local/lib \
	 /usr/local/include,/usr/local/lib \
	 /usr/include/$1,/usr/lib \
	 /usr/$1/include,/usr/$1/lib \
	 /usr/include,/usr/lib \
	 /opt/include/$1,/opt/lib \
	 /opt/$1/include,/opt/$1/lib \
	 /opt/include,/opt/lib"
	 
      if test X$3 != X
      then
        inc_and_lib_dirs="$3/include,$3/lib $inc_and_lib_dirs"
      fi
  
      case "$host_os" in
         *darwin* )
	   exts="dylib so a"
	   ;;
	 *cygwin* )
	   exts="dll.a so a"
	   ;;
	 * )
	   exts="so a"
      esac
   
      xincfile="$jd_$1_inc_file"
      xlibfile="lib$1"
      jd_with_$1_library="no"

      for include_and_lib in $inc_and_lib_dirs
      do
        # Yuk.  Is there a better way to set these variables??
        xincdir=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]1}'`
	xlibdir=`echo $include_and_lib | tr ',' ' ' | awk '{print [$]2}'`
	found=0
	if test -r $xincdir/$xincfile
	then 
	  for E in $exts
	  do
	    if test -r "$xlibdir/$xlibfile.$E"
	    then
	      jd_$1_include_dir="$xincdir"
	      jd_$1_library_dir="$xlibdir"
	      jd_with_$1_library="yes"
	      found=1
	      break
	    fi
	  done
	fi
	if test $found -eq 1
	then
	  break
	fi	
      done
    fi
  fi

  if test X"$jd_$1_include_dir" != X -a X"$jd_$1_library_dir" != X
  then
    AC_MSG_RESULT(yes: $jd_$1_library_dir and $jd_$1_include_dir)
    jd_with_$1_library="yes"
    dnl#  Avoid using /usr/lib and /usr/include because of problems with
    dnl#  gcc on some solaris systems.
    JD_ARG1[]_LIB=-L$jd_$1_library_dir
    if test "X$jd_$1_library_dir" = "X/usr/lib"
    then
      JD_ARG1[]_LIB=""
    else
      JD_SET_RPATH($jd_$1_library_dir)
    fi

    JD_ARG1[]_INC=-I$jd_$1_include_dir
    if test "X$jd_$1_include_dir" = "X/usr/include"
    then
      JD_ARG1[]_INC=""
    fi
  else
    AC_MSG_RESULT(no)
    jd_with_$1_library="no"
    JD_ARG1[]_INC=""
    JD_ARG1[]_LIB=""
  fi
  AC_SUBST(JD_ARG1[]_LIB)
  AC_SUBST(JD_ARG1[]_INC)
])
dnl#}}}

AC_DEFUN(JD_WITH_LIBRARY, dnl#{{{
[
  JD_CHECK_FOR_LIBRARY($1, $2, $3)
  if test "$jd_with_$1_library" = "no"
  then
    AC_MSG_ERROR(unable to find the $1 library and header file $jd_$1_inc_file)
  fi
])
dnl#}}}

AC_DEFUN(JD_UPPERCASE, dnl#{{{
[
changequote(<<, >>)dnl
define(<<$2>>, translit($1, [a-z], [A-Z]))dnl
changequote([, ])dnl
])
#}}}

AC_DEFUN(JD_SLANG_VERSION, dnl#{{{
[
 slang_h=$jd_slang_include_dir/slang.h
 AC_MSG_CHECKING(SLANG_VERSION in $slang_h)
slang_version=`grep "^#define  *SLANG_VERSION " $slang_h |
               awk '{ print [$]3 }'`
slang_major_version=`echo $slang_version |
 awk '{ print int([$]1/10000) }'`
slang_minor_version=`echo $slang_version $slang_major_version |
 awk '{ print int(([$]1 - [$]2*10000)/100) }'`
slang_patchlevel_version=`echo $slang_version $slang_major_version $slang_minor_version |
 awk '{ print ([$]1 - [$]2*10000 - [$]3*100) }'`

AC_MSG_RESULT($slang_major_version.$slang_minor_version.$slang_patchlevel_version)
AC_SUBST(slang_version)
AC_SUBST(slang_major_version)
AC_SUBST(slang_minor_version)
AC_SUBST(slang_patchlevel_version)
])
#}}}

AC_DEFUN(JD_SLANG_MODULE_INSTALL_DIR, dnl#{{{
[
  AC_REQUIRE([JD_SLANG_VERSION])
  if test "X$slang_major_version" = "X1"
  then
    MODULE_INSTALL_DIR="$libdir/slang/modules"
  else
    MODULE_INSTALL_DIR="$libdir/slang/v$slang_major_version/modules"
  fi
  SL_FILES_INSTALL_DIR=$datadir/slsh/local-packages
  AC_SUBST(MODULE_INSTALL_DIR)
  AC_SUBST(SL_FILES_INSTALL_DIR)
])
#}}}

AC_DEFUN(GCC_WARNINGS, dnl {{{
[
AC_ARG_ENABLE(warnings,
	      [  --enable-warnings       turn on GCC compiler warnings],
	      [gcc_warnings=$enableval])
if test -n "$GCC" ; then
  CFLAGS="$CFLAGS -fno-strength-reduce -fno-strict-aliasing"
  if test -n "$gcc_warnings" ; then

  CFLAGS="$CFLAGS -Wall -W -pedantic -Winline -Wmissing-prototypes \
 -Wnested-externs -Wpointer-arith -Wcast-align -Wshadow -Wstrict-prototypes"
    # Now trim excess whitespace
    CFLAGS=`echo $CFLAGS`
  else
    # Always ensure that at least -Wall is specified for all GCC compiles
	case " $CFLAGS " in
	   *[\	\ ]-Wall[\	\ ]*) ;;
	   *) CFLAGS="$CFLAGS -Wall" ;;
	esac
  fi
fi
])dnl}}}

AC_DEFUN(MN_CHECK_SLANG, dnl#{{{
[

test "x$prefix" = "xNONE" && prefix="$ac_default_prefix"
JD_WITH_LIBRARY(slang)

if test -z "$SLANG_INC" ; then
    SLANG_INC="-I$prefix/include"
    echo "S-Lang include directory not specified, defaulting to $SLANG_INC"
    AC_SUBST(SLANG_INC)
 fi
 if test -z "$SLANG_LIB" ; then
    SLANG_LIB="-L$prefix/lib"
    echo "S-Lang lib directory not specified, defaulting to $SLANG_LIB"
    JD_SET_RPATH($libdir)
    AC_SUBST(SLANG_LIB)
 fi

incdir=`echo $SLANG_INC | cut -c 3-`
if test -z "$incdir" ; then
   incdir=$prefix/include
fi
if ! test -f $incdir/slang.h  ; then
   AC_MSG_ERROR([could not find include/slang.h])
fi

jd_slang_include_dir=$incdir
JD_SLANG_VERSION

SLANG_VERSION_STRING=$slang_major_version.$slang_minor_version.$slang_patchlevel_version

echo "SLang version is $SLANG_VERSION_STRING"
required_slang_version_as_int=`echo $1 | tr '.' '0'`
if test -z "$slang_version" || test $slang_version -lt $required_slang_version_as_int ; then
	AC_MSG_ERROR([S-Lang $1 or greater is required for this software])
fi
SLANG_LIB_STATIC=`echo $SLANG_LIB| cut -c 3-`/libslang.a
AC_SUBST(SLANG_LIB_STATIC)
AC_SUBST(SLANG_VERSION_STRING)
JD_SLANG_MODULE_INSTALL_DIR
])
#}}}

AC_DEFUN(MN_MODULE_INIT, dnl#{{{
[

if ! test -s VERSION ; then
   AC_MSG_ERROR([could not find VERSION file])
fi

JD_UPPERCASE(AC_PACKAGE_NAME,MODULE_NAME)

MAJOR_VERSION=`cat VERSION | cut -d. -f1`
MINOR_VERSION=`cat VERSION | cut -d. -f2`
MICRO_VERSION=`cat VERSION | cut -d. -f3`

MODULE_NAME[]_VERSION_STRING=${MAJOR_VERSION}.${MINOR_VERSION}.${MICRO_VERSION}
MODULE_NAME[]_VERSION=`expr \( 10000 \* $MAJOR_VERSION \) + \( 100 \* $MINOR_VERSION \) + $MICRO_VERSION`

dnl MINOR_VERSION=${MINOR_VERSION}.${MICRO_VERSION}

if test -n "$DEVEL_BUILD" ; then
   DEVEL_BUILD=true
fi

if test -f REVISION ; then 
   REVISION=`cat REVISION | grep -v \#`
else
   REVISION=
fi
MODULE_NAME[]_REVISION=$REVISION

SO_EXT=.so

GIFSICLE_SRC="gifread.c giffunc.c gifwrite.c"

AC_SUBST(GIFSICLE_SRC)
AC_SUBST(SO_EXT)
AC_SUBST(MAJOR_VERSION)
AC_SUBST(MINOR_VERSION)
AC_SUBST(MICRO_VERSION)
AC_SUBST(MODULE_NAME[]__VERSION)
AC_SUBST(MODULE_NAME[]_VERSION_STRING)
AC_SUBST(MODULE_NAME[]_REVISION)
AC_SUBST(DEVEL_BUILD)
AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION,$MODULE_NAME[]_VERSION)
AC_DEFINE_UNQUOTED(MODULE_NAME[]_VERSION_STRING,"$MODULE_NAME[]_VERSION_STRING")
])
#}}}
