static variable sw_float_parent;
static variable window = NULL;
static variable sw_parent = NULL;
static variable sw_destroyed_handler = 0;

static define
scrolled_windows_delete_cb (widget, event, scrollwin)
{
  gtk_widget_reparent (scrollwin, sw_parent);
  g_signal_handler_disconnect (sw_parent, sw_destroyed_handler);
  sw_float_parent = NULL;
  sw_parent = NULL;
  sw_destroyed_handler = 0;
  return FALSE;
}

static define 
scrolled_windows_destroy_cb (widget, scrollwin)
{
  if (sw_float_parent != NULL) {
     gtk_widget_destroy (sw_float_parent);
     sw_float_parent = NULL;
     sw_parent = NULL;
     sw_destroyed_handler = 0;
  }
}

static define scrolled_windows_reparent_toggle (widget, scrollwin)
{
  if (sw_parent == NULL) {
      sw_parent = gtk_widget_get_parent (scrollwin);
      sw_float_parent = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_default_size (sw_float_parent, 200, 200);
      
      gtk_widget_reparent (scrollwin, sw_float_parent);
      gtk_widget_show (sw_float_parent);

      sw_destroyed_handler = g_signal_connect (sw_parent, "destroy",
			     &scrolled_windows_destroy_cb, scrollwin);
      () = g_signal_connect (sw_float_parent, "delete_event",
			   &scrolled_windows_delete_cb, scrollwin);
  }
  else {
      gtk_widget_reparent (scrollwin, sw_parent);
      gtk_widget_destroy (sw_float_parent);
      g_signal_handler_disconnect (sw_parent, sw_destroyed_handler);
      sw_float_parent = NULL;
      sw_parent = NULL;
      sw_destroyed_handler = 0;
  }
}

define create_scrollwin (test)
{
   if (window == NULL) {

	window = gtk_dialog_new ();
	() = g_signal_connect(window,"destroy",&gtk_widget_destroyed,&window);
	gtk_window_set_title (window, "dialog");
	gtk_container_set_border_width (window, 0);
	gtk_window_set_default_size(window, 300, 300);

	variable scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width ( scrolled_window, 10);
	gtk_scrolled_window_set_policy (scrolled_window,
				      GTK_POLICY_AUTOMATIC,
				      GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start ( gtk_dialog_get_vbox(window), 
			  scrolled_window, TRUE, TRUE, 0);

	variable table = gtk_table_new (20, 20, FALSE);
	gtk_table_set_row_spacings ( (table), 10);
	gtk_table_set_col_spacings ( (table), 10);
	gtk_scrolled_window_add_with_viewport (scrolled_window, table);
	gtk_container_set_focus_hadjustment ( table,
		gtk_scrolled_window_get_hadjustment (scrolled_window));
	gtk_container_set_focus_vadjustment ( table,
		gtk_scrolled_window_get_vadjustment (scrolled_window));

	variable buffer, button, i, j;
	for (i = 0; i < 20; i++)
	    for (j = 0; j < 20; j++)
	    {
		buffer = sprintf("button (%d,%d)\n", i, j);
		button = gtk_toggle_button_new_with_label (buffer);
		gtk_table_attach_defaults ( table, button, i, i+1, j, j+1);
		gtk_widget_show (button);
	    }

	button = gtk_button_new_with_label ("Reparent In/Out");
	() = g_signal_connect (button, "clicked",
			  &scrolled_windows_reparent_toggle,scrolled_window);
	gtk_box_pack_start ( gtk_dialog_get_action_area(window), 
						button, TRUE, TRUE, 0);

	button = gtk_button_new_with_label ("Close");
	() = g_signal_connect_swapped (button, "clicked",
				 &gtk_widget_destroy, window);
	gtk_box_pack_start ( gtk_dialog_get_action_area(window),
					button, TRUE, TRUE, 0);
        gtk_widget_grab_focus(button);
	test.lower = button;
   }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
