
static define create_list( )
{
   variable scrwin = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (scrwin, GTK_POLICY_AUTOMATIC, 
						GTK_POLICY_AUTOMATIC);
   
   variable model = gtk_list_store_newv (1, [G_TYPE_STRING] );
   variable tree_view = gtk_tree_view_new ();
   gtk_scrolled_window_add_with_viewport (scrwin, tree_view);
   gtk_tree_view_set_model (tree_view, model);
   gtk_widget_show (tree_view);
   
   % Add some messages to the window 
   variable i, iter = gtk_tree_iter_new();
   for (i = 0; i < 10; i++) {
	variable msg = sprintf("Message #%d", i);
	gtk_list_store_append (model, iter);

	if (i mod 2 == 0)
	   gtk_list_store_set(model, iter, 0, msg);		% just for fun
	else
	   gtk_list_store_set_value(model, iter, 0, msg);
   }

   vmessage("Next two function call messages should return 1 (SUCCESS)");
   vmessage("gtk_tree_model_get_iter_first (model, iter) = %S",
				gtk_tree_model_get_iter_first (model, iter));

#ifexists gtk_list_store_iter_is_valid
   vmessage("gtk_list_store_iter_is_valid(model, iter) = %S",
   				gtk_list_store_iter_is_valid(model, iter));
#endif
   
   variable cell = gtk_cell_renderer_text_new ();

   variable column = gtk_tree_view_column_new_with_attributes("Messages",
	 						cell, "text", 0);

   () = gtk_tree_view_append_column (tree_view, column);

   return scrwin;
}
   
static define  insert_text( buffer )
{
   variable iter = gtk_text_buffer_get_iter_at_offset (buffer, 0);
   gtk_text_buffer_insert (buffer, iter,
    "From: pathfinder@nasa.gov\n"+
    "To: mom@nasa.gov\n"+
    "Subject: Made it!\n\n"+
    "We just got in this morning. The weather has been\n"+
    "great - clear but cold, and there are lots of fun sights.\n"+
    "Sojourner says hi. See you soon.\n"+
    " -Path\n", -1);
}
   
static define create_text( )
{

   variable view = gtk_text_view_new ();
   variable buffer = gtk_text_view_get_buffer (view);
   variable scrwin = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (scrwin, GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);
   gtk_container_add ( scrwin, view);
   insert_text (buffer);
   gtk_widget_show_all (scrwin);

   return scrwin;
}
   
public define create_liststore(test)
{
    variable window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (window, "ListStore");
    gtk_container_set_border_width ( window, 10);
    gtk_widget_set_size_request (window, 450, 400);

    variable vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add ( window, vbox);

    variable vpaned = gtk_vpaned_new ();
    gtk_container_add ( vbox, vpaned);
    gtk_widget_show (vpaned);
   
    variable list = create_list ();
    gtk_paned_add1 (vpaned, list);
    gtk_widget_show (list);
   
    variable text = create_text ();
    gtk_paned_add2 (vpaned, text);

    test.lower = generic_close_button(vbox,window);
    gtk_widget_show_all (window);
}
