
require("tess");

static define realize(toplevel)
{
   % Define local instances, which will go out of scope upon function
   % exit and expose leaks for objects not properly cleaned up.

   variable drawable = gtk_widget_get_window(toplevel);
   variable pixmap = gdk_pixmap_new(NULL,100,100,8);
   variable ttips = gtk_tooltips_new();
   variable adj = gtk_adjustment_new(0.0, 0.0, 101.0, 0.1, 1.0, 1.0);
   variable treev = gtk_tree_view_column_new();
   variable itemf = gtk_item_factory_new(gtk_menu_bar_get_type(),"<test>",NULL);
   variable cellr = gtk_cell_renderer_pixbuf_new();

   drawable = gtk_widget_get_window(toplevel);

   variable gc = gdk_gc_new(drawable);
   variable button = gtk_button_new_with_label("foo");
   variable iconsrc = gtk_icon_source_new();
   variable iconset = gtk_icon_set_new();
   variable iconfac = gtk_icon_factory_new();
   variable wingroup = gtk_window_group_new();
   variable treepath = gtk_tree_path_new();
   variable pspec   = g_param_spec_internal(G_TYPE_PARAM_INT,
	 	"GParamSpecTest","GParamSpecTest_nick",
		"GParamSpecTest_blurb",G_PARAM_READABLE);

   % The remaining examples show how to avoid leaks with certain objects,
   % mainly by using them properly.  The author does not consider these
   % leaks as issues to be addressed within SLgtk proper, since similar
   % C code would also leak under the same conditions.

   % An "unused" GtkTextBuffer will leak
   variable textbuf = gtk_text_buffer_new(NULL);
   variable iter = gtk_text_buffer_get_iter_at_offset(textbuf,0);

   % An unused GtkTextTag will leak.  Note that using gtk_text_tag_new(),
   % followed by gtk_text_buffer_get_tag_table() and gtk_tag_table_add()
   % IS NOT the preferred way to add a GtkTextTag to a GtkTextBuffer.
   % [ See textview example for usage of gtk_text_buffer_create_tag() ]
   variable texttag = gtk_text_tag_new("dummy_text_tag");
   variable tagtable = gtk_text_buffer_get_tag_table(textbuf);
   gtk_text_tag_table_add(tagtable,texttag);
   gtk_text_buffer_apply_tag(textbuf,texttag,iter,iter);

   % An "unused" GtkTextChildAnchor will leak
   variable anchor  = gtk_text_child_anchor_new();
   gtk_text_buffer_insert_child_anchor(textbuf,iter,anchor);

   variable accelgroup = gtk_accel_group_new();	
   % GtkAccelGroups unattached to a window will leak
   gtk_window_add_accel_group(toplevel,accelgroup);

   variable liststore = gtk_list_store_newv(1,[G_TYPE_STRING]);
   variable treeview = gtk_tree_view_new();
   % GtkListStore models unattached to a treeview will leak
   gtk_tree_view_set_model(treeview,liststore);
}

static define look_for_leaks()
{
   variable window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

   gtk_window_set_title(window, "Leak Checker");
   gtk_window_set_default_size(window, 450, 350);

   variable vbox = gtk_vbox_new(FALSE,0);
   gtk_container_add(window,vbox);
   () = g_signal_connect(window,"realize",&realize);

   variable button = gtk_button_new_with_label("     Quit    ");
   () = g_signal_connect_swapped(button, "clicked",
					&gtk_widget_destroy,window);
   gtk_box_pack_end(vbox,button,FALSE,FALSE,20);

   gtk_widget_show_all (window);
   gtk_main();
}

Component = "LeakChecker";
() = printf("\nLeakChecker should be run in conjunction with a\n"+
	    "memory profiler, such as purify or valgrind\n\n");

invoke_with_quit(0, &look_for_leaks);
