static variable  window = NULL;

define create_bbox (horizontal, title, spacing, child_w, child_h, layout)
{
   variable bbox;
   variable frame = gtk_frame_new (title);
   if (horizontal)
	bbox = gtk_hbutton_box_new ();
   else
	bbox = gtk_vbutton_box_new ();

   gtk_container_set_border_width ( (bbox), 5);
   gtk_container_add ( frame, bbox);

   gtk_button_box_set_layout (bbox, layout);
   gtk_box_set_spacing (bbox, spacing);
   gtk_button_box_set_child_size (bbox, child_w, child_h);
  
   variable button = gtk_button_new_with_label ("OK");
   gtk_container_add ( bbox, button);
  
   button = gtk_button_new_with_label ("Cancel");
   gtk_container_add ( bbox, button);
  
   button = gtk_button_new_with_label ("Help");
   gtk_container_add ( bbox, button);

   return frame;
}

public define create_buttonbox (test)
{
   if (window == NULL) {

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (window, "Button Boxes");
    
	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);
	gtk_container_set_border_width (window, 10);

	variable main_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (window,main_vbox);
    
	variable frame = gtk_frame_new ("Horizontal Button Boxes");
	gtk_box_pack_start ( main_vbox, frame , TRUE, TRUE, 10);
    
	variable vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width ( vbox, 10);
	gtk_container_add ( frame, vbox);

	gtk_box_pack_start ( vbox, 
	   create_bbox (TRUE, "Spread", 40, 85, 20, GTK_BUTTONBOX_SPREAD),
			TRUE, TRUE, 0);

	gtk_box_pack_start ( vbox, 
	   create_bbox (TRUE, "Edge", 40, 85, 20, GTK_BUTTONBOX_EDGE),
			TRUE, TRUE, 5);

	gtk_box_pack_start ( vbox, 
	   create_bbox (TRUE, "Start", 40, 85, 20, GTK_BUTTONBOX_START),
			TRUE, TRUE, 5);

	gtk_box_pack_start ( vbox, 
	   create_bbox (TRUE, "End", 40, 85, 20, GTK_BUTTONBOX_END),
			TRUE, TRUE, 5);

	frame = gtk_frame_new ("Vertical Button Boxes");
	gtk_box_pack_start ( main_vbox, frame , TRUE, TRUE, 10);
    
	variable hbox = gtk_hbox_new (FALSE, 0);
	gtk_container_set_border_width ( hbox, 10);
	gtk_container_add ( frame , hbox);

	gtk_box_pack_start ( hbox, 
	   create_bbox (FALSE, "Spread", 30, 85, 20, GTK_BUTTONBOX_SPREAD),
			TRUE, TRUE, 0);

	gtk_box_pack_start ( hbox, 
	   create_bbox (FALSE, "Edge", 30, 85, 20, GTK_BUTTONBOX_EDGE),
			TRUE, TRUE, 5);

	gtk_box_pack_start ( hbox, 
	   create_bbox (FALSE, "Start", 30, 85, 20, GTK_BUTTONBOX_START),
			TRUE, TRUE, 5);

	gtk_box_pack_start ( hbox, 
	   create_bbox (FALSE, "End", 30, 85, 20, GTK_BUTTONBOX_END),
			TRUE, TRUE, 5);

	test.lower = generic_close_button(main_vbox,window);
  }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
