/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGREPORT_H
#define SKGREPORT_H
/** @file
 * A report class for document
*
* @author Stephane MANKOWSKI
*/
#include "skgerror.h"
#include "skgbasemodeler_export.h"

#include <QObject>
#include <QVariant>

class SKGDocument;
/**
 * A report class for document
 */
class SKGBASEMODELER_EXPORT SKGReport : public QObject
{
    Q_OBJECT
    /**
     * The current month
     */
    Q_PROPERTY(QString month READ getMonth)

    /**
     * The previous month
     */
    Q_PROPERTY(QString previous_month READ getPreviousMonth)

public:
    /**
     * Default Constructor
     */
    explicit SKGReport(SKGDocument* iDocument);

    /**
     * Default Destructor
     */
    virtual ~SKGReport();

    /**
     * Set the current month
     * @param iMonth the month
     */
    virtual void setMonth(const QString& iMonth);

    /**
     * Get the current month
     * @return the current month
     */
    virtual QString getMonth();

    /**
     * Get the previous month
     * @return the previous month
     */
    virtual QString getPreviousMonth();

    /**
     * Get report
     * @param iReport the report
     * @param iFile the tremplate file name
     * @param oHtml the html report
     * @return an object managing the error
     *   @see SKGError
     */
    static SKGError getReportFormTemplate(SKGReport* iReport, const QString& iFile, QString& oHtml);

protected:
    /**
     * Enrich the grantlee mapping
     * @param iMapping the mapping
     */
    virtual void addItemsInMapping(QVariantHash& iMapping);

    SKGDocument* m_document;
    QHash<QString, QVariant> m_cache;

private:
    Q_DISABLE_COPY(SKGReport);
};

#endif // SKGREPORT_H
