/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNIQUEAPPLICATION_H
#define SKGUNIQUEAPPLICATION_H
/** @file
* This file defines the main of an application.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgbasegui_export.h"

#include <kuniqueapplication.h>

#include <QTimer>

class SKGDocument;
class KSplashScreen;
class SKGMainPanel;

/**
 * The main unique application
 */
class SKGBASEGUI_EXPORT SKGUniqueApplication : public KUniqueApplication
{
    Q_OBJECT
public:
    /**
     * Constructor
     * @param iDoc document
     */
    explicit SKGUniqueApplication(SKGDocument* iDoc);

    /**
     * Destructor
     */
    virtual ~SKGUniqueApplication();

    /**
     * Create a new instance
     * @return error code
     */
    int newInstance();

public:
    /**
    * Splash screen
    */
    KSplashScreen* m_splash;
    /**
     * Main document
     */
    SKGDocument* m_doc;
    /**
     * Main widget
     */
    SKGMainPanel *m_widget;

private Q_SLOTS:
    void closeSpashScreen();

private:
    QTimer m_timer;
};
#endif // SKGUNIQUEAPPLICATION_H
