/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#ifndef ACCOUNTSKROOGOID_H
#define ACCOUNTSKROOGOID_H
/** @file
* This file is Plasma Applet for Account Skroogoid
*
* @author Siddharth SHARMA
*/
#include <Plasma/Applet>
#include <Plasma/Label>
#include <skgservices.h>
#include <skgdocumentbank.h>
#include <qgraphicslinearlayout.h>
#include <qsignalmapper.h>


class QSizeF;
/**
* Class AccountSkroogoid
*/
class AccountSkroogoid : public Plasma::Applet
{
    Q_OBJECT

public:

    /**
     * Default Constructor
     */
    AccountSkroogoid(QObject *parent, const QVariantList &args);


    /**
    * Default Destructor
    */
    ~AccountSkroogoid();


    /**
     * Reimplemented from Plasma::Applet
     */
    virtual void init();

private Q_SLOTS:


    /**
     * Opens a new tab with the given account
     * @param accountName The name of the account
     */
    void openAccountTab(QString accountName);

    /**
     * Fetch data from the specified source
     */
    void dataUpdated(const QString sourceName, const Plasma::DataEngine::Data &engineData);


private:

    /**
     * Add a line to the list
     * @param label The label for the line
     * @param value The numerical value for the line
     * @param isTotalLine Is this line a Total line ?
     * @param bold Should the line label be bold ?
     * @return the line layout
     */
    QGraphicsLinearLayout* addAccountLine(QString label, double value);

    /**
     * Add a total line
     * @param label The label for the line
     * @param value The numerical value for the line
     * @param labelFont The QFont for the label
     * @return the line layout
     */
    QGraphicsLinearLayout* addTotalLine(QString label, double value, QFont* labelFont = 0);


    /**
     * Creates a label for an account's balance
     * @param value the numerical value to display
     * @return the label
     */
    Plasma::Label* createValueLabel(double value);


    /**
     * The current Skrooge document
     */
    SKGDocumentBank* doc;

    /**
     * The primary unit defined for the document
     */
    SKGServices::SKGUnitInfo primary;

    /**
     * The structure holding the data to display
     */
    QHash<QString, QStringList> listData;

    /**
     * QGraphicsLinearLayout layout for adding items
     */
    QGraphicsLinearLayout* widgetLayout;

    /**
     * The signal mapper, used to open the correct account tab
     */
    QSignalMapper* signalMapper;


};

/**
  * For exporting skroogoid as a registered Plasma Applet
  */
K_EXPORT_PLASMA_APPLET(accountskroogoid, AccountSkroogoid)

#endif
