/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A collection of widgets (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgwidgetcollectiondesignerplugin.h"
#include "skgcomboboxdesignerplugin.h"
#include "skgcolorbuttondesignerplugin.h"
#include "skglineeditdesignerplugin.h"
#include "skgtableviewdesignerplugin.h"
#include "skgtreeviewdesignerplugin.h"
#include "skgdateeditdesignerplugin.h"
#include "skgcalculatoreditdesignerplugin.h"
#include "skggraphicsviewdesignerplugin.h"
#include "skgtablewithgraphdesignerplugin.h"
#include "skgtabwidgetdesignerplugin.h"
#include "skgtablewidgetdesignerplugin.h"
#include "skgzoomselectordesignerplugin.h"

#include <QtPlugin>

SKGWidgetCollectionDesignerPlugin::SKGWidgetCollectionDesignerPlugin(QObject *parent)
        : QObject(parent)
{
    widgets.append(new SKGCalculatorEditDesignerPlugin(this));
    widgets.append(new SKGComboBoxDesignerPlugin(this));
    widgets.append(new SKGColorButtonDesignerPlugin(this));
    widgets.append(new SKGLineEditDesignerPlugin(this));
    widgets.append(new SKGDateEditDesignerPlugin(this));
    widgets.append(new SKGGraphicsViewDesignerPlugin(this));
    widgets.append(new SKGTableViewDesignerPlugin(this));
    widgets.append(new SKGTreeViewDesignerPlugin(this));
    widgets.append(new SKGTableWithGraphDesignerPlugin(this));
    widgets.append(new SKGTabWidgetDesignerPlugin(this));
    widgets.append(new SKGTableWidgetDesignerPlugin(this));
    widgets.append(new SKGZoomSelectorDesignerPlugin(this));
}

QList<QDesignerCustomWidgetInterface*> SKGWidgetCollectionDesignerPlugin::customWidgets() const
{
    return widgets;
}

Q_EXPORT_PLUGIN2(skgbaseui, SKGWidgetCollectionDesignerPlugin)

