/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A line edit with more features (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skglineeditdesignerplugin.h"
#include "skglineedit.h"

#include "kicon.h"

#include <QtPlugin>

SKGLineEditDesignerPlugin::SKGLineEditDesignerPlugin(QObject *parent)
        : QObject(parent)
{
    initialized = false;
}

void SKGLineEditDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
    if (initialized) return;

    initialized = true;
}

bool SKGLineEditDesignerPlugin::isInitialized() const
{
    return initialized;
}

QWidget *SKGLineEditDesignerPlugin::createWidget(QWidget *parent)
{
    return new SKGLineEdit(parent);
}

QString SKGLineEditDesignerPlugin::name() const
{
    return "SKGLineEdit";
}

QString SKGLineEditDesignerPlugin::group() const
{
    return "SKG Widgets";
}

QIcon SKGLineEditDesignerPlugin::icon() const
{
    return KIcon("skg_open");
}

QString SKGLineEditDesignerPlugin::toolTip() const
{
    return "A line edit with more features";
}

QString SKGLineEditDesignerPlugin::whatsThis() const
{
    return "A line edit with more features";
}

bool SKGLineEditDesignerPlugin::isContainer() const
{
    return false;
}

QString SKGLineEditDesignerPlugin::domXml() const
{
    return "<widget class=\"SKGLineEdit\" name=\"SKGLineEdit\">\n"
           " <property name=\"geometry\">\n"
           "  <rect>\n"
           "   <x>0</x>\n"
           "   <y>0</y>\n"
           "   <width>100</width>\n"
           "   <height>10</height>\n"
           "  </rect>\n"
           " </property>\n"
           "</widget>\n";
}

QString SKGLineEditDesignerPlugin::includeFile() const
{
    return "skglineedit.h";
}

