/* Public domain. */

#include <unistd.h>
#include <errno.h>
#include "bytestr.h"
#include "stralloc.h"
#include "djbunix.h"

int sagetcwd (stralloc *sa)
{
  unsigned int n = 128 ;
  unsigned char wasnull = !sa->s ;

  for (;;)
  {
    if (!stralloc_readyplus(sa, n)) goto err ;
    if (getcwd(sa->s + sa->len, n)) break ;
    if (errno != ERANGE) goto err ;
    n += 128 ;
  }
  sa->len += str_len(sa->s + sa->len) ;
  return 0 ;

err:
  if (wasnull) stralloc_free(sa) ;
  return -1 ;
}
