# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: internationalisation

=end
module SiSU_Translate
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  include SiSU_Param
  class Source
    def initialize(md,doc_lang,trans_str='')
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
      @lang_class=case @doc_lang
      when /American/i;                  English.new(md,doc_lang,trans_str)    # tag depreciated, see iso 639-2
      when /English/i;                   English.new(md,doc_lang,trans_str)
      when /French/i;                    French.new(md,doc_lang,trans_str)
      when /German/i;                    German.new(md,doc_lang,trans_str)
      when /Italian/i;                   Italian.new(md,doc_lang,trans_str)
      when /Spanish/i;                   Spanish.new(md,doc_lang,trans_str)
      when /Brazilian(?: Portuguese)?/i; Portuguese.new(md,doc_lang,trans_str) # tag depreciated, see iso 639-2
      when /Portuguese/i;                Portuguese.new(md,doc_lang,trans_str)
      when /Swedish/i;                   Swedish.new(md,doc_lang,trans_str)
      when /Danish/i;                    Danish.new(md,doc_lang,trans_str)
      when /Finnish/i;                   Finnish.new(md,doc_lang,trans_str)
      when /Norwegian/i;                 Norwegian.new(md,doc_lang,trans_str)
      when /Icelandic/i;                 Icelandic.new(md,doc_lang,trans_str)
      when /Dutch/i;                     Dutch.new(md,doc_lang,trans_str)
      when /Estonian/i;                  Estonian.new(md,doc_lang,trans_str)
      when /Hungarian/i;                 Hungarian.new(md,doc_lang,trans_str)
      when /Polish/i;                    Polish.new(md,doc_lang,trans_str)
      when /Romanian/i;                  Romanian.new(md,doc_lang,trans_str)
      when /Russian/i;                   Russian.new(md,doc_lang,trans_str)
      when /Greek/i;                     Greek.new(md,doc_lang,trans_str)
      when /Ukranian/i;                  Ukranian.new(md,doc_lang,trans_str)
      when /Turkish/i;                   Turkish.new(md,doc_lang,trans_str)
      when /Slovenian/i;                 Slovenian.new(md,doc_lang,trans_str)
      when /Croatian/i;                  Croatian.new(md,doc_lang,trans_str)
      when /Slovak(?:ian)?/i;            Slovak.new(md,doc_lang,trans_str)
      when /Czech/i;                     Czech.new(md,doc_lang,trans_str)
      when /Bulgarian/i;                 Bulgarian.new(md,doc_lang,trans_str)
      else                               English.new(md,doc_lang,trans_str)
      end
    end
    def filename
      @lang_class.filename
    end
    def description
      @lang_class.description
    end
    def metadata
      @lang_class.metadata
    end
    def filetype_description
      @lang_class.filetype_description
    end
    def file_size
      @lang_class.file_size
    end
    def sourcefile
      @lang_class.sourcefile
    end
    def sourcefile_digest
      @lang_class.sourcefile_digest
    end
    def full_title #dc
      @lang_class.full_title
    end
    def title
      @lang_class.title
    end
    def subtitle
      @lang_class.subtitle
    end
    def author
      @lang_class.author
    end
    def contributor
      @lang_class.contributor
    end
    def translator
      @lang_class.translator
    end
    def illustrator
      @lang_class.illustrator
    end
    def publisher
      @lang_class.publisher
    end
    def prepared_by
      @lang_class.prepared_by
    end
    def digitized_by
      @lang_class.digitized_by
    end
    def subject
      @lang_class.subject
    end
    def description #dc (watch)
      @lang_class.description
    end
    def abstract
      @lang_class.abstract
    end
    def type
      @lang_class.type
    end
    def rights
      @lang_class.rights
    end
    def digitized_by
      @lang_class.digitized_by
    end
    def date
      @lang_class.date
    end
    def date_created
      @lang_class.date_created
    end
    def date_available
      @lang_class.date_available
    end
    def date_valid
      @lang_class.date_valid
    end
    def date_modified
      @lang_class.date_modified
    end
    def date_issued
      @lang_class.date_issued
    end
    def language
      @lang_class.language
    end
    def language_original
      @lang_class.language_original
    end
    def format
      @lang_class.format
    end
    def identifier
      @lang_class.identifier
    end
    def source
      @lang_class.source
    end
    def relation
      @lang_class.relation
    end
    def coverage
      @lang_class.coverage
    end
    def keywords
      @lang_class.keywords
    end
    def comments
      @lang_class.comments
    end
    def cls_loc
      @lang_class.cls_loc
    end
    def cls_dewey
      @lang_class.cls_dewey
    end
    def cls_gutenberg
      @lang_class.cls_gutenberg
    end
    def cls_isbn
      @lang_class.cls_isbn
    end
    def prefix_a
      @lang_class.prefix_a
    end
    def prefix_b
      @lang_class.prefix_b
    end
    def topic_register
      @lang_class.topic_register
    end
    def fns
      @lang_class.fns
    end
    def word_count
      @lang_class.word_count
    end
    def dgst
      @lang_class.dgst
    end
    def sc_number
      @lang_class.sc_number
    end
    def sc_date
      @lang_class.sc_date
    end
    def last_generated
      @lang_class.last_generated
    end
    def sisu_version
      @lang_class.sisu_version
    end
    def ruby_version
      @lang_class.ruby_version
    end
    def suggested_links
      @lang_class.suggested_links
    end
    def language_version_list
      @lang_class.language_version_list
    end
    def language
      @lang_class.language
    end
    def manifest_description
      @lang_class.manifest_description
    end
    def manifest_description_output
      @lang_class.manifest_description_output
    end
    def manifest_description_metadata
      @lang_class.manifest_description_metadata
    end
    def language_list_translated
      @lang_class.language_list
    end
    def language_list
      lang=case @trans_str
      when /American/i;                  'American English'                    # tag depreciated, see iso 639-2
      when /English/i;                   'English'
      when /French/i;                    'français'
      when /German/i;                    'Deutsch'
      when /Italian/i;                   'Italiano'
      when /Spanish/i;                   'español'
      when /Brazilian(?: Portuguese)?/i; 'Brazilian Português'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Português'
      when /Swedish/i;                   'svenska'
      when /Danish/i;                    'dansk'
      when /Finnish/i;                   'suomi'
      when /Norwegian/i;                 'norsk'
      when /Icelandic/i;                 'Icelandic'
      when /Dutch/i;                     'Nederlands'
      when /Estonian/i;                  'Estonian'
      when /Hungarian/i;                 'Hungarian'
      when /Polish/i;                    'polski'
      when /Romanian/i;                  'română'
      when /Russian/i;                   'Русский (Russkij)'
      when /Greek/i;                     'Ελληνικά (Ellinika)'
      when /Ukranian/i;                  'українська (ukrajins\'ka)'
      when /Turkish/i;                   'Türkçe'
      when /Slovenian/i;                 'Slovenian'
      when /Croatian/i;                  'Croatian'
      when /Slovak(?:ian)?/i;            'slovensky'            #slovensky ?
      when /Czech/i;                     'česky'
      when /Bulgarian/i;                 'Български (Bəlgarski)'
      when /Japanese/i;                  '日本語 (Nihongo)'
      when /Korean/i;                    '한국어 (Hangul)'
      #when /Catalan/i;                   'català'
      else                               'English'
      end
      #check on 中文  and عربي
    end
  end
  class English
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'filename'
    end
    def description
      'description'
    end
    def filetype_description
      'filetype description'
    end
    def metadata
      'metadata'
    end
    def file_size
      'file size'
    end
    def full_title #dc
      'Title'
    end
    def title
      'Title'
    end
    def subtitle
      'Subtitle'
    end
    def author
      'Author'
    end
    def author #dc
      'Creator'
    end
    def contributor #dc
      'Contributor'
    end
    def translator
      'Translator'
    end
    def illustrator
      'Illustrator'
    end
    def publisher #dc
      'Publisher'
    end
    def prepared_by
      'Prepared by'
    end
    def digitized_by
      'Digitized by'
    end
    def subject #dc
      'Subject'
    end
    def description #dc (watch)
      'Description'
    end
    def abstract #dc
      'Abstract'
    end
    def type #dc
      'Type'
    end
    def rights #dc
      'Rights'
    end
    def date #dc
      'Date'
    end
    def date_created #dc
      'Date created'
    end
    def date_issued #dc
      'Date issued'
    end
    def date_available #dc
      'Date available'
    end
    def date_modified #dc
      'Date modified'
    end
    def date_valid #dc
      'Date valid'
    end
    def language #dc
      'Language'
    end
    def language_original
      'Original Language'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Identifier'
    end
    def source #dc
      'Source'
    end
    def relation #dc
      'Relation'
    end
    def coverage #dc
      'Coverage'
    end
    def keywords
      'Keywords'
    end
    def comments
      'Comments'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Sourcefile'
    end
    def word_count
      'Word Count approximate'
    end
    def sourcefile_digest
      'Sourcefile Digest'
    end
    def digest_md5
      'Sourcefile Digest (md5)'
    end
    def digest_sha256
      'Sourcefile Digest (sha256)'
    end
    def sc_number
      'Document (RCS/CVS) number'
    end
    def sc_date
      'Document (RCS/CVS) number'
    end
    def last_generated
      'Document (metaverse) last generated'
    end
    def sisu_version
      'Generated by'
    end
    def ruby_version
      'Ruby version'
    end
    def suggested_links
      'metadata suggested links'
    end
    def language_version_list
      'Document Language Versions, manifests'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Available document filetypes'
    end
    def manifest_description_metadata
      'Document Metadata'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'American English'                    # tag depreciated, see iso 639-2
      when /English/i;                   'English'
      when /French/i;                    'French'
      when /German/i;                    'German'
      when /Italian/i;                   'Italian'
      when /Spanish/i;                   'Spanish'
      when /Brazilian(?: Portuguese)?/i; 'Brazilian Portuguese'                # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portuguese'
      when /Swedish/i;                   'Swedish'
      when /Danish/i;                    'Danish'
      when /Finnish/i;                   'Finnish'
      when /Norwegian/i;                 'Norwegian'
      when /Icelandic/i;                 'Icelandic'
      when /Dutch/i;                     'Dutch'
      when /Estonian/i;                  'Estonian'
      when /Hungarian/i;                 'Hungarian'
      when /Polish/i;                    'Polish'
      when /Romanian/i;                  'Romanian'
      when /Russian/i;                   'Russian'
      when /Greek/i;                     'Greek'
      when /Ukranian/i;                  'Ukranian'
      when /Turkish/i;                   'Turkish'
      when /Slovenian/i;                 'Slovenian'
      when /Croatian/i;                  'Croatian'
      when /Slovak(?:ian)?/i;            'Slovakian'
      when /Czech/i;                     'Czech'
      when /Bulgarian/i;                 'Bulgarian'
      else @trans_str
      end
    end
  end
  class French
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nom de fichier'
    end
    def description
      'description'
    end
    def filetype_description
      description
    end
    def metadata
      'metadonnées'
    end
    def file_size
      'taille'
    end
    def full_title #dc
      'Titre'
    end
    def title
      'Titre'
    end
    def subtitle
      'Sous titre'
    end
    def author
      'Auteur'
    end
    def author #dc
      'Auteur'
    end
    def contributor #dc
      'Contributeur'
    end
    def translator
      'Traducteur'
    end
    def illustrator
      'Illustrateur'
    end
    def publisher #dc
      'Éditeur'
    end
    def prepared_by
      'Préparé par'
    end
    def digitized_by
      'Numérisé par'
    end
    def subject #dc
      'Sujet'
    end
    def description #dc (watch)
      'Description'
    end
    def abstract #dc
      'Résumé'
    end
    def type #dc
      'Type'
    end
    def rights #dc
      'Droits relatifs à la ressource'
    end
    def date #dc
      'Date'
    end
    def date_created #dc
      'Date de création'
    end
    def date_issued #dc
      'Date de publication'
    end
    def date_available #dc
      'Date de mise à disposition'
    end
    def date_modified #dc
      'Date de modification'
    end
    def date_valid #dc
      'Date de validité'
    end
    def language #dc
      'Langue'
    end
    def language_original
      'Langue originale'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Identifiant'
    end
    def source #dc
      'Source'
    end
    def relation #dc
      'Lien'
    end
    def coverage #dc
      'Portée du document'
    end
    def keywords
      'Mots clef'
    end
    def comments
      'Commentaires'
    end
    def cls_loc
      'Classification de la bibliothèque du congres'
    end
    def cls_dewey
      'Classification Dewey'
    end
    def cls_gutenberg
      'Classification du project Gutenberg'
    end
    def cls_isbn
      'Classification ISBN'
    end
    def prefix_a
      'Préfixe (a)'
    end
    def prefix_b
      'Préfixe (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Fichier source'
    end
    def word_count
      'Nombre approximatif de mots'
    end
    def sourcefile_digest
      'Condensé du fichier source'
    end
    def digest_md5
      'Condensé du fichier source (md5)'
    end
    def digest_sha256
      'Condensé du fichier source (sha256)'
    end
    def sc_number
      'Numéro (RCS/CVS) du document'
    end
    def sc_date
      'Numéro (RCS/CVS) du document'
    end
    def last_generated
      'Dernière production du document (metaverse)'
    end
    def sisu_version
      'Généré par'
    end
    def ruby_version
      'Version de Ruby'
    end
    def suggested_links
      'Liens suggérés'
    end
    def language_version_list
      'Versions des langues du document, manifestes'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Manifeste SiSU du document généré'
    end
    def manifest_description_metadata
      'Manifeste SiSU des métadonnées du document'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Anglais americain'                   # tag depreciated, see iso 639-2
      when /English/i;                   'Anglais'
      when /French/i;                    'Français'
      when /German/i;                    'Allemand'
      when /Italian/i;                   'Italien'
      when /Spanish/i;                   'Espagnol'
      when /Brazilian(?: Portuguese)?/i; 'Portugais brésilien'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugais'
      when /Swedish/i;                   'Suédois'
      when /Danish/i;                    'Danois'
      when /Finnish/i;                   'Finnois'
      when /Norwegian/i;                 'Norvégien'
      when /Icelandic/i;                 'Islandais'
      when /Dutch/i;                     'Néerlandais'
      when /Estonian/i;                  'Estonien'
      when /Hungarian/i;                 'Hongrois'
      when /Polish/i;                    'Polonais'
      when /Romanian/i;                  'Roumain'
      when /Russian/i;                   'Russe'
      when /Greek/i;                     'Grec'
      when /Ukranian/i;                  'Ukrainien'
      when /Turkish/i;                   'Turc'
      when /Slovenian/i;                 'Slovène'
      when /Croatian/i;                  'Croate'
      when /Slovak(?:ian)?/i;            'Slovaque'
      when /Czech/i;                     'Tcheque'
      when /Bulgarian/i;                 'Bulgare'
      else @trans_str
      end
    end
  end
  class German
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'Dateiname'
    end
    def description
      'Beschreibung'
    end
    def filetype_description
      description
    end
    def metadata
      'Metadata'
    end
    def file_size
      'Dateigrösse'
    end
    def full_title #dc
      'Titel'
    end
    def title
      'Titel'
    end
    def subtitle
      'Untertitel'
    end
    def author
      'Autor'
    end
    def contributor #dc
      'Mitautor'
    end
    def translator
      'Übersetzung'
    end
    def illustrator
      'Illustrator'
    end
    def publisher
      'Herausgeber'
    end
    def prepared_by
      'gesetzt von'
    end
    def digitized_by
      'digitalisiert von'
    end
    def subject
      'Titel'
    end
    def description #dc (watch)
      'Beschreibung'
    end
    def abstract #dc
      'Abstract'
    end
    def type
      'Typ'
    end
    def rights
      'Rechte'
    end
    def date
      'Datum'
    end
    def date_created
      'Erstellung'
    end
    def date_issued
      'Herausgabe'
    end
    def date_available
      'Veröffentlichung'
    end
    def date_modified
      'Modifikation'
    end
    def date_valid
      'Gültigkeit'
    end
    def language
      'Sprache'
    end
    def language_original
      'Ursprungssprache'
    end
    def format #dc
      'Format'
    end
    def identifier #dc
      'Bezeichnung'
    end
    def source #dc
      'Quelle'
    end
    def relation #dc
      'Beziehung'
    end
    def coverage #dc
      'Eingrenzung'
    end
    def keywords
      'Schlüsselwörter'
    end
    def comments
      'Kommentare'
    end
    def cls_loc
      'Klassifikation nach Library of Congress'
    end
    def cls_dewey
      'Klassifikation nach Dewey'
    end
    def cls_gutenberg
      'Klassifikation nach Projekt Gutenberg'
    end
    def cls_isbn
      'Klassifikation nach ISBN'
    end
    def prefix_a
      'Präfix (a)'
    end
    def prefix_b
      'Präfix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Quelldatei'
    end
    def word_count
      'Anzahl Wörter'
    end
    def sourcefile_digest
      'Quelldatei Digest'
    end
    def digest_md5
      'Prüfsumme der Quelldatei (MD5)'
    end
    def digest_sha256
      'Prüfsumme der Quelldatei (SHA256)'
    end
    def sc_number
      'Dokumentversion (RCS/CVS)'
    end
    def sc_date
      'Dokumentdatum (RCS/CVS)'
    end
    def last_generated
      'Letzte Erstellung (metaverse)'
    end
    def sisu_version
      'erstellt bei'
    end
    def ruby_version
      'Ruby Version'
    end
    def suggested_links
      'empfohlene Links'
    end
    def language_version_list
      'verfügbare Sprachen'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'SiSU Zusammenfassung des Dokumentes'
    end
    def manifest_description_metadata
      'SiSU Zusammenfassung der Metadaten'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Amerikanisch-Englisch'               # tag depreciated, see iso 639-2
      when /English/i;                   'Englisch'
      when /French/i;                    'Französisch'
      when /German/i;                    'Deutsch'
      when /Italian/i;                   'Italienisch'
      when /Spanish/i;                   'Spanisch'
      when /Brazilian(?: Portuguese)?/i; 'Brasilianisch-Portugiesisch'         # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugiesisch'
      when /Swedish/i;                   'Schwedisch'
      when /Danish/i;                    'Dänisch'
      when /Finnish/i;                   'Finnisch'
      when /Norwegian/i;                 'Norwegisch'
      when /Icelandic/i;                 'Isländisch'
      when /Dutch/i;                     'Niederländisch'
      when /Estonian/i;                  'Estnisch'
      when /Hungarian/i;                 'Ungarisch'
      when /Polish/i;                    'Polnisch'
      when /Romanian/i;                  'Rumänisch'
      when /Russian/i;                   'Russisch'
      when /Greek/i;                     'Griechisch'
      when /Ukranian/i;                  'Ukrainisch'
      when /Turkish/i;                   'Türkisch'
      when /Slovenian/i;                 'Slovenisch'
      when /Croatian/i;                  'Kroatisch'
      when /Slovak(?:ian)?/i;            'Slovakisch'
      when /Czech/i;                     'Tschechisch'
      when /Bulgarian/i;                 'Bulgarisch'
      else @trans_str
      end
    end
  end
  class Spanish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'nombre del fichero'
    end
    def description
      'descripción'
    end
    def filetype_description
      description
    end
   def metadata
     'metadatos'
   end
   def file_size
     'tamaño del fichero'
   end
   def full_title #dc
     'Título'
   end
   def title
     'Título'
   end
   def subtitle
     'Subtítulo'
   end
   def author #dc
     'Creador'
   end
   def contributor #dc
     'Contribuidor'
   end
   def translator
     'Traductor'
   end
   def illustrator
     'Ilustrador'
   end
   def publisher #dc
     'Editor'
   end
   def prepared_by
     'Preparado por'
   end
   def digitized_by
     'Digitalizado por'
   end
   def subject #dc
     'Asunto'
   end
   def description #dc (watch)
     'Descripción'
   end
   def abstract #dc
     'Resumen'
   end
   def type #dc
     'Tipo'
   end
   def rights #dc
     'Derechos'
   end
   def date #dc
     'Fecha'
   end
   def date_created #dc
     'Fecha de creación'
   end
   def date_issued #dc
     'Fecha de publicación'
   end
   def date_available #dc
     'Fecha de disponibilidad'
   end
   def date_modified #dc
     'Fecha de modificación'
   end
   def date_valid #dc
     'Fecha de valided'
   end
   def language #dc
     'Idioma'
   end
   def language_original
     'Lenguaje original'
   end
   def format #dc
     'Formato'
   end
   def identifier #dc
     'Identificador'
   end
   def source #dc
     'Fuente'
   end
   def relation #dc
     'Relación'
   end
   def coverage #dc
     'Cobertura'
   end
   def keywords
     'Palabras claves'
   end
   def comments
     'Comentarios'
   end
   def cls_loc
     'Clasificación Biblioteca del Congreso'
   end
   def cls_dewey
     'Clasificación Dewey'
   end
   def cls_gutenberg
     'Clasificación Proyecto Gutenberg'
   end
   def cls_isbn
     'Clasificación ISBN'
   end
   def prefix_a
     'Prefijo (a)'
   end
   def prefix_b
     'Prefijo (b)'
   end
    def topic_register
      'Topics Registered'
    end
   def sourcefile
     'Fichero fuente'
   end
   def word_count
     'Número de palabras apróximado'
   end
   def sourcefile_digest
     'Resumen del fichero fuente'
   end
   def digest_md5
     'Resumen del fichero fuente (md5)'
   end
   def digest_sha256
     'Resumen del fichero fuente (sha256)'
   end
   def sc_number
     'Versión (RCS/CVS) del documento'
   end
   def sc_date
     'Versión (RCS/CVS) del documento'
   end
   def last_generated
     'Última generación (metaverse) del documento'
   end
   def sisu_version
     'Generado por'
   end
   def ruby_version
     'Versión de Ruby'
   end
   def suggested_links
     'enlaces sugeridos de metadatos'
   end
   def language_version_list
     'Document Language Versions, manifests'
   end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
   def manifest_description_output
     'Manifiesto SiSU de salida generada'
   end
   def manifest_description_metadata
     'Manifiesto SiSU de metadatos de documento'
   end
   def language_list_translated
     lang=case @trans_str
     when /American/i;                  'Inglés Americano'                     # tag depreciated, see iso 639-2
     when /English/i;                   'Inglés'
     when /French/i;                    'Francés'
     when /German/i;                    'Alemán'
     when /Italian/i;                   'Italiano'
     when /Spanish/i;                   'Español'
     when /Brazilian(?: Portuguese)?/i; 'Portugués de Brasil'                  # tag depreciated, see iso 639-2
     when /Portuguese/i;                'Portugués'
     when /Swedish/i;                   'Sueco'
     when /Danish/i;                    'Danés'
     when /Finnish/i;                   'Finés'
     when /Norwegian/i;                 'Noruego'
     when /Icelandic/i;                 'Islandés'
     when /Dutch/i;                     'Holandés'
     when /Estonian/i;                  'Estonio'
     when /Hungarian/i;                 'Húngaro'
     when /Polish/i;                    'Polaco'
     when /Romanian/i;                  'Rumano'
     when /Russian/i;                   'Ruso'
     when /Greek/i;                     'Griego'
     when /Ukranian/i;                  'Ucraniano'
     when /Turkish/i;                   'Turco'
     when /Slovenian/i;                 'Eslovaco'
     when /Croatian/i;                  'Croata'
     when /Slovak(?:ian)?/i;            'Eslovaco'
     when /Czech/i;                     'Checo'
     when /Bulgarian/i;                 'Búlgaro'
     else @trans_str
     end
   end
  end
  class Italian
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
      'nome del file'
    end
    def description
      'descrizione'
    end
    def filetype_description
      description
    end
    def metadata
      'metadati'
    end
    def file_size
      'dimensione'
    end
    def full_title #dc
      'Titolo'
    end
    def title
      'Titolo'
    end
    def subtitle
      'Sottotitolo'
    end
    def author #dc
      'Autore'
    end
    def contributor #dc
      'Contributore'
    end
    def translator
      'Traduttore'
    end
    def illustrator
      'Illustratore'
    end
    def publisher #dc
      'Casa editrice'
    end
    def prepared_by
      'Preparato da'
    end
    def digitized_by
      'Convertito in digitale da'
    end
    def subject #dc
      'Oggetto'
    end
    def description #dc (watch)
      'Descrizione'
    end
    def abstract #dc
      'Abstract'
    end
    def type #dc
      'Tipo'
    end
    def rights #dc
      'Diritti del lettore'
    end
    def date #dc
      'Data'
    end
    def date_created #dc
      'Data di creazione'
    end
    def date_issued #dc
      'Data di pubblicazione'
    end
    def date_available #dc
      'Data di effettiva disponibilità'
    end
    def date_modified #dc
      'Data di ultima modifica'
    end
    def date_valid #dc
      'Data di inizo validità'
    end
    def language #dc
      'Lingua'
    end
    def language_original
      'Lingua originale'
    end
    def format #dc
      'Formato'
    end
    def identifier #dc
      'Indentificatore'
    end
    def source #dc
      'Fonte'
    end
    def relation #dc
      'Collegamento'
    end
    def coverage #dc
      'Ambito'
    end
    def keywords
      'Parole chiave'
    end
    def comments
      'Commenti'
    end
    def cls_loc
      'Classificazione della Library of Congress'
    end
    def cls_dewey
      'Classificazione Dewey'
    end
    def cls_gutenberg
      'Classificazione del Progetto Gutenberg'
    end
    def cls_isbn
      'Numero ISBN'
    end
    def prefix_a
      'Premessa (a)'
    end
    def prefix_b
      'Premessa (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Sorgente'
    end
    def word_count
      'Numero approssimativo di parole'
    end
    def sourcefile_digest
      'Checksum file sorgente'
    end
    def digest_md5
      'Checksum file sorgente (md5)'
    end
    def digest_sha256
      'Checksum file sorgente (sha256)'
    end
    def sc_number
      'Numero di revisione (RCS/CVS)'
    end
    def sc_date
      'Numero di revisione (RCS/CVS)'
    end
    def last_generated
      'Data di ultima generazione (dal metaverse)'
    end
    def sisu_version
      'Generato da'
    end
    def ruby_version
      'Ruby versione'
    end
    def suggested_links
      'Link suggeriti'
    end
    def language_version_list
      'Traduzioni disponibili'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Inventario SiSU dell\'output generato'
    end
    def manifest_description_metadata
      'Inventario SiSU dei metadati'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Inglese USA'                         # tag depreciated, see iso 639-2
      when /English/i;                   'Inglese'
      when /French/i;                    'Francese'
      when /German/i;                    'Tedesco'
      when /Italian/i;                   'Italiano'
      when /Spanish/i;                   'Spagnolo'
      when /Brazilian(?: Portuguese)?/i; 'Portoguese (Brasile)'                # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portoguese'
      when /Swedish/i;                   'Svedese'
      when /Danish/i;                    'Danese'
      when /Finnish/i;                   'Finlandese'
      when /Norwegian/i;                 'Norvegese'
      when /Icelandic/i;                 'Islandese'
      when /Dutch/i;                     'Olandese'
      when /Estonian/i;                  'Estone'
      when /Hungarian/i;                 'Ungherese'
      when /Polish/i;                    'Polacco'
      when /Romanian/i;                  'Romeno'
      when /Russian/i;                   'Russo'
      when /Greek/i;                     'Greco'
      when /Ukranian/i;                  'Ucraino'
      when /Turkish/i;                   'Turco'
      when /Slovenian/i;                 'Sloveno'
      when /Croatian/i;                  'Croato'
      when /Slovak(?:ian)?/i;            'Slovacco'
      when /Czech/i;                     'Ceco'
      when /Bulgarian/i;                 'Bulgaro'
      else @trans_str
      end
    end
  end
  class Finnish
    def initialize(md,doc_lang,trans_str)
      @md,@doc_lang,@trans_str=md,doc_lang,trans_str
    end
    def filename
     'tiedostonimi'
    end
    def description
      'kuvaus'
    end
    def filetype_description
      description
    end
    def metadata
      'metadata'
    end
    def file_size
      'tiedoston koko'
    end
    def full_title #dc
      'otsikko'
    end
    def title
      'Otsikko'
    end
    def subtitle
      'Alaotsikko'
    end
    def author #dc
      'tekijä'
    end
    def contributor #dc
      'osallistuja'
    end
    def translator
      'Kääntäjä'
    end
    def illustrator
      'Kuvittaja'
    end
    def publisher #dc
      'julkaisija'
    end
    def prepared_by
      'Valmistaja'
    end
    def digitized_by
      'Digitalisoinut'
    end
    def subject #dc
      'aihe'
    end
    def description #dc (watch)
      'kuvaus'
    end
    def abstract #dc
      'tiivistelmä'
    end
    def type #dc
      'tyyppi'
    end
    def rights #dc
      'oikeudet'
    end
    def date #dc
      'päiväys'
    end
    def date_created #dc
      'luontipäivä'
    end
    def date_issued #dc
      'julkaisupäivä'
    end
    def date_available #dc
      'saantipäivä'
    end
    def date_modified #dc
      'muokkauspäivä'
    end
    def date_valid #dc
      'kelpoisuuspäivä'
    end
    def language #dc
      'kieli'
    end
    def language_original
      'Alkuperäiskieli'
    end
    def format #dc
      'muoto'
    end
    def identifier #dc
      'tunnus'
    end
    def source #dc
      'lähde'
    end
    def relation #dc
      'suhde'
    end
    def coverage #dc
      'kattavuus'
    end
    def keywords
      'Avainsanat'
    end
    def comments
      'Kommentit'
    end
    def cls_loc
      'Classify Library of Congress'
    end
    def cls_dewey
      'Classify Dewey'
    end
    def cls_gutenberg
      'Classify Project Gutenberg'
    end
    def cls_isbn
      'Classify ISBN'
    end
    def prefix_a
      'Prefix (a)'
    end
    def prefix_b
      'Prefix (b)'
    end
    def topic_register
      'Topics Registered'
    end
    def sourcefile
      'Lähdetiedosto'
    end
    def word_count
      'Arvioitu sanamäärä'
    end
    def sourcefile_digest
      'Lähdetiedoston tiiviste'
    end
    def digest_md5
      'Lähdetiedoston tiiviste (md5)'
    end
    def digest_sha256
      'Lähdetiedoston tiiviste (sha256)'
    end
    def sc_number
      'Dokumentin RCS/CVS-numero'
    end
    def sc_date
      'Dokumentin RCS/CVS-päiväys'
    end
    def last_generated
      'Viimeksi tuotettu dokumentti (metaverse)'
    end
    def sisu_version
      'Generoinut'
    end
    def ruby_version
      'Ruby-versio'
    end
    def suggested_links
      'metadatan ehdottamat linkit'
    end
    def language_version_list
      'Dokumentin kieliversiot, manifestit'
    end
    def manifest_description
      'SiSU manifest of document filetypes and metadata'
    end
    def manifest_description_output
      'Tuotetun tuloksen SISU-manifesti'
    end
    def manifest_description_metadata
      'Dokumenttimetadatan SISU-manifesti'
    end
    def language_list_translated
      lang=case @trans_str
      when /American/i;                  'Amerikanenglanti'                    # tag depreciated, see iso 639-2
      when /English/i;                   'Englanti'
      when /French/i;                    'Ranska'
      when /German/i;                    'Saksa'
      when /Italian/i;                   'Italia'
      when /Spanish/i;                   'Espanja'
      when /Brazilian(?: Portuguese)?/i; 'Brasilian portugali'                 # tag depreciated, see iso 639-2
      when /Portuguese/i;                'Portugali'
      when /Swedish/i;                   'Ruotsi'
      when /Danish/i;                    'Tanska'
      when /Finnish/i;                   'Suomi'
      when /Norwegian/i;                 'Norja'
      when /Icelandic/i;                 'Islanti'
      when /Dutch/i;                     'Hollanti'
      when /Estonian/i;                  'Viro'
      when /Hungarian/i;                 'Unkari'
      when /Polish/i;                    'Puola'
      when /Romanian/i;                  'Romania'
      when /Russian/i;                   'Venäjä'
      when /Greek/i;                     'Kreikka'
      when /Ukranian/i;                  'Ukraina'
      when /Turkish/i;                   'Turkki'
      when /Slovenian/i;                 'Slovenia'
      when /Croatian/i;                  'Kroatia'
      when /Slovak(?:ian)?/i;            'Slovakki'
      when /Czech/i;                     'Tsekki'
      when /Bulgarian/i;                 'Bulgaria'
      else @trans_str
      end
    end
  end
  class Porguguese            < English
  end
  class Swedish               < English
  end
  class Danish                < English
  end
  class Norwegian             < English
  end
  class Icelandic             < English
  end
  class Dutch                 < English
  end
  class Estonian              < English
  end
  class Hungarian             < English
  end
  class Polish                < English
  end
  class Romanian              < English
  end
  class Russian               < English
  end
  class Greek                 < English
  end
  class Ukranian              < English
  end
  class Turkish               < English
  end
  class Croatian              < English
  end
  class Slovakian             < English
  end
  class Czech                 < English
  end
  class Bulgarian             < English
  end
end
__END__
