# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: summary of generated outputs and metadata

=end
module SiSU_Manifest
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/i18n"
  require "#{SiSU_lib}/particulars"
  include SiSU_Particulars
  require "#{SiSU_lib}/html_minitoc"
  #require "#{SiSU_lib}/html_format"
  require "#{SiSU_lib}/html"
  include SiSU_HTML_Format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
      @data=SiSU_HTML::Source::Html_environment.new(@particulars).tuned_file_instructions
      l=SiSU_Env::Standardise_language.new.file_to_language(@opt.fns)
      @doc_language=l[:l]
    end
    def read
      begin
        @env=SiSU_Env::Info_env.new(@opt.fns)
        @md=SiSU_Param::Parameters.new(@opt).get
        SiSU_Env::Info_skin.new(@md).select
        xbrowser=@env.program.web_browser
        browser=@env.program.console_web_browser
        webserv_url=@env.path.url.output_tell
        url_html="#{webserv_url}/#{@md.fnb}/#{@md.fn[:manifest]}"
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'Manifest',"#{xbrowser} #{url_html}")
        tell.green_hi_blue unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"#{browser} #{url_html}")
        tell.grey_tab if @opt.cmd =~/v/i
        Output_Info.new(@md,@data).check_output
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    private
    class Output_Info <Source
      def initialize(md,data)
        @manifest={ :txt=>[],:html=>[] }
        @md,@fns,@data=md,md.fns,data
        @env=SiSU_Env::Info_env.new(@md.fns)
        @fnb=@md.fnb
        @base_url,@base_url_src,@base_url_pod="#{@env.url.root}/#@fnb","#{@env.url.src_txt}","#{@env.url.src_pod}"
        @base_path,@base_path_src,@base_path_pod="#{@env.path.output}/#@fnb","#{@env.path.output_src}","#{@env.path.output_pod}"
        @@dg ||=SiSU_Env::Info_env.new.digest.type
        @dg=@@dg
        l=SiSU_Env::Standardise_language.new.file_to_language(@md.fns)
        @language=l[:l]
        @translate=SiSU_Translate::Source.new(@md,@language)
        @url_brace=SiSU_Viz::Skin.new.url_decoration
      end
      def output
        SiSU_Env::SiSU_file.new(@md).mkdir
        manifest=SiSU_Env::SiSU_file.new(@md,@md.fn[:manifest]).mkfile
        @manifest[:html].each do |x|
          manifest << x
        end
      end
      def summarize(id,file,img='● ')
        size=(File.size("#{@base_path}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="#{file}">#{img}#{id}</a></p></th><td><p class="small"><a href="#{file}">#{file}</a></p><p class="tiny">#{@url_brace.xml_open}<a href="#@base_url/#{file}">#@base_url/#{file}</a>#{@url_brace.xml_close}</p></td><td class="right"><p class="right">#{kb}</p></td></tr>\n}
      end
      def summarize_source(id,file)
        sys=SiSU_Env::System_call.new
        dgst =if @dg =~/^sha(?:2|256)$/; sys.sha256("#{@base_path_src}/#{file}")
        else                             sys.md5("#{@base_path_src}/#{file}")
        end
        tell=SiSU_Screen::Ansi.new(@md.cmd,"#{dgst[1]} #{file}")
        tell.warn if @md.cmd =~/[vVM]/
        size=(File.size("#{@base_path_src}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="../src/#{file}">#{id}</a></p></th><td class="right"><p class="tiny"><a href="../src/#{file}">#{file}</a> &nbsp;&nbsp;#{dgst[1]}<br />#{@url_brace.xml_open}<a href="#@base_url_src/#{file}">#@base_url_src/#{file}</a>#{@url_brace.xml_close}</p></td><td class="right"><p class="right">#{kb}</p>
        </td></tr>\n} if kb and kb =~/\d+/
      end
      def summarize_pod(id,file)
        sys=SiSU_Env::System_call.new
        dgst =if @dg =~/^sha(?:2|256)$/; sys.sha256("#{@base_path_pod}/#{file}")
        else                             sys.md5("#{@base_path_pod}/#{file}")
        end
        tell=SiSU_Screen::Ansi.new(@md.cmd,"#{dgst[1]} #{file}")
        tell.warn if @md.cmd =~/[vVM]/
        size=(File.size("#{@base_path_pod}/#{file}")/1024.00).to_s
        kb=/([0-9]+\.[0-9]{0,1})/m.match(size)[1]
        @manifest[:txt] << "#{file} #{id} #{kb}\n"
        @manifest[:html] << %{<tr><th class="left"><p class="norm"><a href="../pod/#{file}">#{id}</a></p></th><td class="right"><p class="tiny"><a href="../pod/#{file}">#{file}</a> &nbsp;&nbsp;#{dgst[1]}<br />#{@url_brace.xml_open}<a href="#@base_url_pod/#{file}">#@base_url_pod/#{file}</a>#{@url_brace.xml_close}</p></td><td class="right"><p class="right">#{kb}</p>
        </td></tr>\n} if kb and kb =~/\d+/
      end
      def languages(id,file)
        flv=@env.published_manifests?(@base_path)
        @manifest[:html] << %{<tr><th class="left"><div id="horizontal_links"><ul id="horizontal">\n}
        flv.each do |l|
          lang=SiSU_Translate::Source.new(@md,@language,l[:l]).language_list
          @manifest[:txt] << "#{l[:m]} #{lang}\n"
          @manifest[:html] << %{<li class="norm"><a href="#{l[:m]}">#{lang}</a>&nbsp;&nbsp;&nbsp;</li>}
        end
        @manifest[:html] << %{</ul></div></th></tr>\n}
      end
      def published_languages(id,file)
        flv=@env.published_manifests?(@base_path)
        flv.each do |l|
          lang=SiSU_Translate::Source.new(@md,@language,l[:l]).language_list
          @manifest[:txt] << "#{l[:m]} #{lang}\n"
          @manifest[:html] << %{<tr><th class="left"><p class="bold"><a href="#{l[:m]}">#{lang}</a></p></th><td><p class="norm">#{lang}</p><p class="tiny">#{@url_brace.xml_open}<a href="#@base_url/#{l[:m]}">#@base_url/#{l[:m]}</a>#{@url_brace.xml_close}</p></td><td class="right"><p class="right">&nbsp;</p></td></tr>\n}
        end
      end
      def metadata(id,info)
        @manifest[:html] << %{<tr><th class="left"><p class="bold_left">#{id}:</p></th><td><p class="left">#{info}</p></td></tr>\n}
      end
      def links(url,lnk,target)
        static=if url =~/^\.\//; url.gsub(/^\.(\.)?/,@base_url)
        elsif url =~/^\.\.\//;   url.gsub(/^\.(\.)?/,@env.url.root)
        else                     url
        end
        @manifest[:html] << %{<tr><th class="right" width=5%><p class="norm">●</p></th><td class="left"><p class="norm"><a href="#{url}">#{lnk}</a></p><p class="tiny">&nbsp;&nbsp;#{@url_brace.xml_open}<a href="#{static}">#{static}</a>#{@url_brace.xml_close}</p></td></tr>\n}
      end
      def output_tests
        if FileTest.file?("#@base_path/#{@md.fn[:toc]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_toc.png" alt="TOC linked" /> '
          id,file='HTML, table of contents (for segmented text)',@md.fn[:toc]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:doc]}")==true
          img='<img border="0" height="15" width="15" src="../_sisu/image_sys/b_doc.png" alt="Full Text" /> '
          id,file='HTML, full length document',@md.fn[:doc]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:book_index]}")==true
          id,file='HTML, index',@md.fn[:book_index]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:concordance]}")==true
          id,file='HTML, concordance file',@md.fn[:concordance]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p_letter]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_pdf.png" alt="PDF portrait" /> '
          id,file="PDF, U.S. letter size, portrait/vertical document (recommended for printing)",@md.fn[:pdf_p_letter]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l_letter]}")==true
          img='<img border="0" height="15" width="18" src="../_sisu/image_sys/b_pdf.png" alt="PDF landscape" /> '
          id,file="PDF, U.S. letter size, landscape/horizontal document (recommended for screen viewing)",@md.fn[:pdf_l_letter]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p_a4]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_pdf.png" alt="PDF portrait" /> '
          id,file="PDF, A4 size, portrait/vertical document (recommended for printing)",@md.fn[:pdf_p_a4]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l_a4]}")==true
          img='<img border="0" height="15" width="18" src="../_sisu/image_sys/b_pdf.png" alt="PDF landscape" /> '
          id,file="PDF, A4 size, landscape/horizontal document (recommended for screen viewing)",@md.fn[:pdf_l_a4]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p_a5]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_pdf.png" alt="PDF portrait" /> '
          id,file="PDF, A5 (book) size, portrait/vertical document (recommended for printing)",@md.fn[:pdf_p_a5]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l_a5]}")==true
          img='<img border="0" height="15" width="18" src="../_sisu/image_sys/b_pdf.png" alt="PDF landscape" /> '
          id,file="PDF, A5 (book) size, landscape/horizontal document (recommended for screen viewing)",@md.fn[:pdf_l_a5]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p_b5]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_pdf.png" alt="PDF portrait" /> '
          id,file="PDF, B5 (book) size, portrait/vertical document (recommended for printing)",@md.fn[:pdf_p_b5]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l_b5]}")==true
          img='<img border="0" height="15" width="18" src="../_sisu/image_sys/b_pdf.png" alt="PDF landscape" /> '
          id,file="PDF, B5 (book) size, landscape/horizontal document (recommended for screen viewing)",@md.fn[:pdf_l_b5]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_p_legal]}")==true
          img='<img border="0" height="18" width="15" src="../_sisu/image_sys/b_pdf.png" alt="PDF portrait" /> '
          id,file="PDF, U.S. legal size, portrait/vertical document (recommended for printing)",@md.fn[:pdf_p_legal]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:pdf_l_legal]}")==true
          img='<img border="0" height="15" width="18" src="../_sisu/image_sys/b_pdf.png" alt="PDF landscape" /> '
          id,file="PDF, U.S. legal size, landscape/horizontal document (recommended for screen viewing)",@md.fn[:pdf_l_legal]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:odf]}")==true
          img='<img border="0" height="18" width="18" src="../_sisu/image_sys/b_odf.png" alt="ODF/ODT" /> '
          id,file='ODF:ODT (Open Document Format)',@md.fn[:odf]
          summarize(id,file,img)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:xhtml]}")==true
          id,file='XHTML',@md.fn[:xhtml]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:sax]}")==true
          id,file='XML SAX',@md.fn[:sax]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:dom]}")==true
          id,file='XML DOM',@md.fn[:dom]
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:plain]}")==true
        if    @md.cmd =~/a/; id,file='Plaintext (Unix (UTF-8) with footnotes)',@md.fn[:plain]
        elsif @md.cmd =~/e/; id,file='Plaintext (Unix (UTF-8) with endnotes)',@md.fn[:plain]
        elsif @md.cmd =~/A/; id,file='Plaintext (dos (UTF-8) with footnotes)',@md.fn[:plain]
        elsif @md.cmd =~/E/; id,file='Plaintext (dos (UTF-8) with endnotes)',@md.fn[:plain]
        else                id,file='Plaintext (UTF-8)',@md.fn[:plain]
        end
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fns}.tex")==true
          id,file='LaTeX (portrait)',"#{@md.fns}.tex"
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fns}.tex")==true
          id,file='LaTeX (landscape)',"#{@md.fns}.landscape.tex"
          summarize(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fn[:digest]}")==true
          id,file="Digest/DCC - Document Content Certificate (#@dg)",@md.fn[:digest]
          summarize(id,file)
        end
      end
      def published_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@md.fns
          languages(id,file)
        end
      end
      def language_versions
        if FileTest.file?("#@base_path/sisu_manifest.html")==true
          id,file='Markup (SiSU source)',@md.fns
          published_languages(id,file)
        end
      end
      def source_tests
        if @md.fns =~/\.ssm\.sst$/                                                  #% decide whether to extract and include requested/required documents
          req=@md.fns
          if FileTest.file?("#@base_path_src/#{req}")==true
            id,file='Markup Composite File (SiSU source)',req
            summarize_source(id,file)
          end
        else
          if FileTest.file?("#@base_path_src/#{@md.fns}")==true
            id,file='Markup (SiSU source)',@md.fns
            summarize_source(id,file)
          end
        end
        if FileTest.file?("#@base_path_pod/#{@md.fn[:sisupod]}")==true
          id,file='SiSU doc (zip)',@md.fn[:sisupod]
          summarize_pod(id,file)
        end
        if FileTest.file?("#@base_path/#{@md.fnb}")==true \
        and @md.fnb =~/\.kdi$/
          id,file='Kdissert (.kdi source)',@md.fnb
          summarize_pod(id,file)
        end
      end
      def metadata_tests
        if @md.full_title #dc
          id,info=@translate.full_title,@md.full_title
          metadata(id,info)
        end
        if @md.title
          id,info=@translate.title,@md.title
          metadata(id,info)
        end
        if @md.subtitle
          id,info=@translate.subtitle,@md.subtitle
          metadata(id,info)
        end
        if @md.author #dc
          id,info=@translate.author,@md.author
          metadata(id,info)
        end
        if @md.contributor #dc
          id,info=@translate.contributor,@md.contributor
          metadata(id,info)
        end
        if @md.translator
          id,info=@translate.translator,@md.translator
          metadata(id,info)
        end
        if @md.illustrator
          id,info=@translate.illustrator,@md.illustrator
          metadata(id,info)
        end
        if @md.publisher #dc
          id,info=@translate.publisher,@md.publisher
          metadata(id,info)
        end
        if @md.prepared_by
          id,info=@translate.prepared_by,@md.prepared_by
          metadata(id,info)
        end
        if @md.digitized_by
          id,info=@translate.digitized_by,@md.digitized_by
          metadata(id,info)
        end
        if @md.subject #dc
          id,info=@translate.subject,@md.subject
          metadata(id,info)
        end
        if @md.description #dc
          id,info=@translate.description,@md.description
          metadata(id,info)
        end
        if @md.abstract
          id,info=@translate.abstract,@md.abstract
          metadata(id,info)
        end
        if @md.type #dc
          id,info=@translate.type,@md.type
          metadata(id,info)
        end
        if @md.rights #dc
          id,info=@translate.rights,@md.rights
          metadata(id,info)
        end
        if @md.date #dc
          id,info=@translate.date,@md.date
          metadata(id,info)
        end
        if @md.date_created #dc
          id,info=@translate.date_created,@md.date_created
          metadata(id,info)
        end
        if @md.date_issued #dc
          id,info=@translate.date_issued,@md.date_issued
          metadata(id,info)
        end
        if @md.date_available #dc
          id,info=@translate.date_available,@md.date_available
          metadata(id,info)
        end
        if @md.date_modified #dc
          id,info=@translate.date_modified,@md.date_modified
          metadata(id,info)
        end
        if @md.date_valid #dc
          id,info=@translate.date_valid,@md.date_valid
          metadata(id,info)
        end
        if @md.language \
        and @md.language[:name] #dc
          id,info=@translate.language,@md.language[:name]
          metadata(id,info)
        end
        if @md.language_original \
        and @md.language_original[:name]
          id,info=@translate.language_original,@md.language_original[:name]
          metadata(id,info)
        end
        if @md.format #dc
          id,info=@transate.format,@md.format
          metadata(id,info)
        end
        if @md.identifier #dc
          id,info=@translate.identifier,@md.identifier
          metadata(id,info)
        end
        if @md.source #dc
          id,info=@translate.source,@md.source
          metadata(id,info)
        end
        if @md.relation #dc
          id,info=@translate.relation,@md.relation
          metadata(id,info)
        end
        if @md.coverage #dc
          id,info=@translate.coverage,@md.coverage
          metadata(id,info)
        end
        if @md.keywords
          id,info=@translate.keywords,@md.keywords
          metadata(id,info)
        end
        if @md.comments
          id,info=@translate.comments,@md.comments
          metadata(id,info)
        end
        if @md.cls_loc
          id,info=@translate.cls_loc,@md.cls_loc
          metadata(id,info)
        end
        if @md.cls_dewey
          id,info=@translate.cls_dewey,@md.cls_dewey
          metadata(id,info)
        end
        if @md.cls_pg
          id,info=@translate.cls_gutenberg,@md.cls_pg
          metadata(id,info)
        end
        if @md.cls_isbn
          id,info=@translate.cls_isbn,@md.cls_isbn
          metadata(id,info)
        end
        if @md.prefix_a
          id,info=@translate.prefix_a,@md.prefix_a
          metadata(id,info)
        end
        if @md.prefix_b
          id,info=@translate.prefix_b,@md.prefix_b
          metadata(id,info)
        end
        if @md.topic_register_array.length > 1
          @manifest[:html] << %{<tr><th class="left"><p class="bold_left">#{@translate.topic_register}:</p></th><td>\n}
          @md.topic_register_array.each do |t|
            t.each_with_index do |st,i|
              if st.class == Array
                st.each do |v|
                  @manifest[:html] << %{<p class="it#{i}">#{v}</p>\n}
                end
              else @manifest[:html] << %{<p class="it#{i}">#{st}</p>\n}
              end
            end
          end
          @manifest[:html] << %{</td></tr>\n}
        end
        if @md.fns
          id,info=@translate.sourcefile,@md.fns
          metadata(id,info)
        end
        if @md.en[:mismatch] > 0
          id,info='WARNING document error in endnote markup, number mismatch',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
          metadata(id,info)
        end
        if @md.wc_words
          id,info=@translate.word_count,@md.wc_words
          metadata(id,info)
        end
        if @md.dgst
          id,info="#{@translate.sourcefile_digest} (#@dg)",@md.dgst[1]
          metadata(id,info)
        end
        if @md.sc_number
          id,info=@translate.sc_number,@md.sc_number
          metadata(id,info)
        end
        if @md.sc_date
          id,info=@translate.sc_date,"#{@md.sc_date} at #{@md.sc_time}"
          metadata(id,info)
        end
        if @md.generated
          id,info=@translate.last_generated,@md.generated
          metadata(id,info)
        end
        if @md.sisu_version
          id,info=@translate.sisu_version,"#{@md.sisu_version[:project]} #{@md.sisu_version[:version]} #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"
          metadata(id,info)
        end
        if @md.ruby_version
          id,info=@translate.ruby_version,@md.ruby_version
          metadata(id,info)
        end
      end
      def links_tests
        if defined? @md.lnk \
        and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//; 'external'
              else                              '_top'
              end
              url,lnk=l[:url],l[:say]
              unless url.nil? \
              or url.empty?
                links(url,lnk,target)
              end
            end
          end
        end
      end
      def check_output
        begin
          minitoc=SiSU_HTML_minitoc::Toc_mini.new(@md,@data).songsheet.join("\n")
          id,file='',''
          vz=SiSU_Env::Get_init.instance.skin
          banner_table=if vz.banner_home_button_only !~ /http:\/\/www\.jus\.uio\.no\/sisu/ \
          and vz.banner_home_button_only !~  /sisu\.home\.png/
<<WOK
<table summary="band" width="100%" border="0" cellpadding="3" cellspacing="0">
<tr><td align="left" bgcolor="#ffffff">#{vz.banner_band}</td><td width="60%"><p class="tiny">#{@url_brace.xml_open}<a href="#@base_url/#{file}">#@base_url/#{file}</a>#{@url_brace.xml_close}</p></td><td width="20%">#{@env.widget_static.search_form}</td><td><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#{vz.url_path_image_sys}/sisu.png" alt="SiSU --&gt;" /></a></td></tr>
</table>
WOK
          else
<<WOK
<table summary="band" border="0" cellpadding="3" cellspacing="0">
<tr><td align="left" bgcolor="#ffffff"><a href="http://www.jus.uio.no/sisu/" target="_top"><img border="0" src="#{vz.url_path_image_sys}/sisu.png" alt="SiSU --&gt;" /></a></td><td><p class="tiny">#{@url_brace.xml_open}<a href="#@base_url/#{file}">#@base_url/#{file}</a>#{@url_brace.xml_close}</p></td><td>#{@env.widget_static.search_form}</td></tr>
</table>
WOK
          end
          @manifest[:html] <<<<WOK
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>
SiSU manifest: #{@md.full_title}
</title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<meta name="sourcefile" content="#{@md.fns}" />
<link rel="generator" href="http://www.jus.uio.no/sisu" />
<link rel="shortcut icon" href="../_sisu/image_sys/rb7.ico" />
<link rel="stylesheet" href="../#{@env.path.style}/html.css" type="text/css" />
</head>
<body bgcolor="#ffffff" text="#000000" link="#003090" lang="en" xml:lang="en">
#{banner_table}
<div class="toc">
#{minitoc.to_s}
</div>
<div class="content">
<h1 class="small">#{@translate.manifest_description}</h1>
<h2 class="small">#{@md.full_title}</h2>
<p class="bold">#{@md.author}</p>
<p class="small">
&nbsp;&nbsp;<a href="#output">Document, Available Filetypes</a>
</p>
<p class="small">
&nbsp;&nbsp;<a href="#metadata">Document Metadata</a>
</p>
<p class="tiny">
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="#links">(metadata suggested links (if any)</a>
</p>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          published_versions
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="output">#{@translate.manifest_description_output}</a></h2>
<table summary="available output/filetypes" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filetype_description}</p></th><th class="left"><p class="bold">#{@translate.filename}</p></th><th class="right"><p class="right"><b>#{@translate.file_size}</b></p><p class="tiny_right">(kB)</p></th></tr>

WOK
          output_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          source_tests
          @manifest[:html] << '</table>'
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="metadata">#{@translate.manifest_description_metadata}</a></h2>
<table summary="document metadata" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.metadata}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th></tr>
WOK
          metadata_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<p class="bold"><a name="links">#{@translate.suggested_links}:</a></p>
<table summary="suggested links" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
WOK
          links_tests
          @manifest[:html] <<<<WOK
</table>
WOK
          @manifest[:html] <<<<WOK
<h2 class="small"><a name="languages">#{@translate.language_version_list}</a></h2>
<table summary="language versions" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
<tr> <th class="left"><p class="bold">#{@translate.filename}</p></th><th class="left"><p class="bold">#{@translate.description}</p></th><th class="right"><p class="right">&nbsp;</p></th></tr>

WOK
          language_versions
          @manifest[:html] <<<<WOK
</table>
</div>
<div class="main_column">
#{vz.credits_sisu}
</div>
</body>
</html>
WOK
          output
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
  end
end
__END__
