# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end

module SiSU_character_check
  class Check
    def initialize(data)
      @data=data
      @comment='%'
      @endnote_array=[]
    end
    def character_check_and_oldstyle_endnote_array
      require 'iconv'
      data=@data
      #reset
      @tuned_file,@endnote_array=[],[]
      endnote_no=1
      data.each do |para|
        para.strip!
        para.gsub!(/^([12])~\?\s+/,'\1~ ')                                    #conditional header for incorporated document 2004w12
        para.gsub!(/^[{~}]\s*$/,'')
        para.gsub!(/^#{@comment}.*/,'')                                       #remove comment and divider #%
        para.gsub!(/<~#>|~#\s*/,"#{Mx[:fa_o]}~##{Mx[:fa_c]}")
        para.gsub!(/-#\s*/,"#{Mx[:fa_o]}-##{Mx[:fa_c]}#{Mx[:fa_o]}~##{Mx[:fa_c]}")
        #para.gsub!(/(#\{{3} arch-tag:|0\{{3}~cvs)\s+/, "0{{~rcs ") #KEEP ... ENABLE WIDER USE OF REVISION CONTROL
        para.gsub!(/(#{Mx[:en_a_o]})\s*\s+/,'\1 '); para.gsub!(/(~\{\s*)\s+/,'\1 ')
        para.gsub!(/ \/\//,"#{Mx[:br_line]}")                                           #added 2004w29
        para.gsub!(/<br>/,"#{Mx[:br_line]}")                                            #needed by xml, xhtml etc.
        para.gsub!(/\t/,' ')
        para.gsub!(/\342\200\231/u,"'") #if para =~/’/  #Avoid #&lsquo; &rsquo; #&ldquo; &rdquo;
        para.gsub!(/�/u,' ') #watch, replace with char code
        para.gsub!(/·/u,'*')
        para.gsub!(/\\copy(?:right)?\b/,'&#169;')
        para.gsub!(/\\trademark\b|\\tm\b/,'&#174;')
        #non_utf8(para)
        para=para + "\n"
        unless para =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
          case para
          when /\^~/ # endnotes
                                                                                 #% Note must do this first (earlier loop) and then enter gathered data into ~^\d+
            sub_para=para.dup
            @endnote_array << sub_para.gsub!(/\n/,'').gsub!(/\^~\s+(.+)\s*/,%{#{Mx[:en_a_o]}#{endnote_no} \\1 #{Mx[:en_a_c]}}).strip
             endnote_no+=1
            para=nil if para =~/\^~ .+/ #removes 'binary' endnote now in endnote array for later insertion
          end
        end
        @tuned_file << para unless para.nil?
      end
      @tuned_file=@tuned_file.flatten
      [@tuned_file,@endnote_array]
    end
  end
end
__END__
