=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Kdissert
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require "#{SiSU_lib}/defaults"
  class Skin
    ##% path
    #def path_root
    #  './sisu/'  # the only parameter that cannot be changed here
    #end
    #def path_rel
    #  '../'
    #end
    #% url
    def url_home
      'http://www.jus.uio.no/sisu'
    end
    def url_site                                                                     # used in pdf header
      url_home
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'www.jus.uio.no/sisu'
      url_home
    end
    def url_hp
      'http://freehackers.org/~tnagy/kdissert'
    end
    def url_home_url
      '../index.html'
    end
    #% color
    def color_band1
      '"#ffffff"'
    end
    #% txt
    def txt_hp
      'Kdissert, Document Mapping'
    end
    def txt_home                                                                     # this should be the name of the site eg. Lex Mercatoria or if you prefer to see a url the url in text form copy & ...
      #"www.jus.uio.no/sisu/"
      'SiSU (document prepared using Kdissert)'
    end
    #% icon
    def icon_home_button
      'kdissert.png'
    end
    def icon_home_banner
      icon_home_button
    end
    #% banner
    def banner_home_button
      %{<table border="0" summary="home button" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#000070"><a href="#{url_hp}/">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#000070"><a href="#{url_hp}/" target="_top">#{png_home}</a>#{table_close}</td><td width="60%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{table_close}</center></td><td width="20%">&nbsp;#{table_close}}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor="#ffffff"><a href="#{url_hp}/" target="_top">#{png_home}</a>#{table_close}}
    end
    def banner_home_guide
    end
  end
  class TeX
    def header_center
      "\\chead{\\href{#{@vz.url_site}/}{www.jus.uio.no/sisu/}}"
    end
    def home_url
      "\\href{#{@vz.url_site}/}{www.fsf.org}"
    end
    def home
      "\\href{#{@vz.url_site}/}{Free Software Foundation}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
end
