=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: Syntax for markup, input markup syntaxes, determined here

=end
module Syntax
  class Words
    def initialize(line,md,mkp)
      @line,@md,@mkp=line,md,mkp
    end
  end
  class Markup
    def initialize(md='',data='')
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @data_new=[]
      url_and_stub=SiSU_Env::Info_env.new.url
      @output_url="#{url_and_stub.remote}"
      @http_m='\{.+?\}(?:https?|file)://\S+|(?:https?|file):\S+|\.\.\/\S+|\S+?\.png\b|[*]~\S+|^0~.+|<:(?:code|group|alt|verse)(?:-end)?>|<:br>'
      @manmkp_ital='[i/]\\{.+?\\}[i/]'
      tail_m_ital=%q{(?:\s|[.,;:?!'")]|~\^|~\\\{\s|$)}
      tail_m_bold=%q{(?:(?:<\/i>)?(?:\s|[.,;:?!'")]|~\^|~\\\{\s|$))?}
      bold_line=%q{^!_\s.+?(?:<br>|\n|$)}
      @line_scan_ital=if defined? @md.make_italic[:str] \
      and defined? @vz.markup_make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|(?:#{@md.make_italic[:str]}|#{@vz.markup_make_italic[:str]})#{tail_m_ital}|\S+|\n/
      elsif defined? @md.make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|#{@md.make_italic[:str]}#{tail_m_ital}|\S+|\n/
      elsif defined? @vz.markup_make_italic[:str]
        /#@http_m|#{bold_line}|#@manmkp_ital#{tail_m_ital}|#{@vz.markup_make_italic[:str]}#{tail_m_ital}|\S+|\n/
      end
      @manmkp_bold='^!_\s.+?(?:\n|$)|[*!b]\\{.+?\\}[*!b]|[*!][a-zA-Z0-9\-_]+[*!]'
      @line_scan_bold=if (defined? @md.make_bold[:str] \
      and @md.make_bold[:str]) \
      and (defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str])
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@md.make_bold[:str]}|#{@vz.markup_make_bold[:str]})#{tail_m_bold}|\S+|\n/
      elsif defined? @md.make_bold[:str] \
      and @md.make_bold[:str]
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@md.make_bold[:str]})#{tail_m_bold}|\S+|\n/
      elsif defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str]
        /#@http_m|#{bold_line}|(?:#@manmkp_bold|#{@vz.markup_make_bold[:str]})#{tail_m_bold}|\S+|\n/
      end
    end
    def songsheet
      @data.each do |line|
        line=pre(line)
        line=wordlist_italics(line)
        line=wordlist_bold(line)
        line=bodymarkup(line)
        @data_new << line
      end
      @data_new
    end
    def pre(line)
      line=line.dup
      if line =~/\{(?:t|table)(?:~h)?\s*c?[\d; ]*\}/; line.gsub!(/(\n)/,';;\1') #markup for alternative tables
      end
      line
    end
    def wordlist_italics(line)
      line=line.dup
      if (defined? @md.make_italic[:str] \
      and @md.make_italic[:str]) \
      or (defined? @vz.markup_make_italic[:str] \
      and @vz.markup_make_italic[:str])
        line= if line !~/^(?:0~|%{1,4}\s|<:code)/  #!~/^(?:[0-6]~|!_|%+\s)/
          word=line.scan(@line_scan_ital)
          word.flatten!
          word.compact! #reinstated
          line_array=[]
          word.each do |w|
            unless /#@manmkp_ital|#@http_m/.match(w)
              if defined? @md.make_italic[:regx] \
              and @md.make_italic[:regx]
                w.gsub!(@md.make_italic[:regx],'<i>\1</i>')
              elsif defined? @vz.markup_make_italic \
              and @vz.markup_make_italic
                w.gsub!(@vz.markup_make_italic,'<i>\1</i>')
              end
            end
            line_array << w
          end
          line_array.join(' ')
        else line
        end
      end
      line
    end
    def embolden(given)
      given.gsub!(/(?:^!_|^[7-9]~)\s+(.+?)(<br>)/,'<b>\1</b>\2')
      given.gsub!(/(?:^!_|^[7-9]~)\s+(.+?)\s+((?:[*]~\S+\s*)+)/,'<b>\1</b> \2')
      given.gsub!(/(?:^!_|^[7-9]~)\s+(.+?)\s*([~-]#)$/,'<b>\1</b> \2')
      given.gsub!(/(?:^!_\s+|^[7-9]~\s+)(.*)?\s*$/,'<b>\1</b>')
    end
    def wordlist_bold(line)
      line=line.dup
      if (defined? @md.make_bold[:str] \
      and @md.make_bold[:str]) \
      or (defined? @vz.markup_make_bold[:str] \
      and @vz.markup_make_bold[:str])
        line=if line !~/^(?:[0-9]~|%+\s|<:code)/
          line_array=[]
          word=line.scan(@line_scan_bold)
          word.flatten!
          word.compact!
          word.each do |w|
            unless /#@manmkp_bold|#@http_m/.match(w)
              if defined? @md.make_bold[:regx] \
              and @md.make_bold[:regx]   #document header: 0~bold [bold word list]
                w.gsub!(@md.make_bold[:regx],'<b>\1</b>')
              elsif defined? @vz.markup_make_bold \
              and @vz.markup_make_bold               #defaults and skin adjusted bold word list
                w.gsub!(@vz.markup_make_bold,'<b>\1</b>')
              end
            else
              if w =~ /(?:^!_|^[7-9]~)\s+/; embolden(w) #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
              end
            end
            line_array << w
          end
          line_array.join(' ')
        else line
        end
      else
        if line !~/^(?:[0-9]~|%+\s)/ \
        and line =~ /(?:^!_|^[7-9]~)\s+/
          embolden(line)
        end
      end
      line
    end
    def bodymarkup(line)
      # << http://www.jus.uio.no/sisu/sisu_markup_table/markup >>
      # See: data/sisu/sample/document_samples_sisu_markup/
      # !{emphasis}!        e{emphasis}e       <strong>emphasis</strong>
      # *{bold text}*       b{bold}b           <b>bold text</b>
      # _{underline}_       u{underline}u      <u>underline</u>
      # /{italics}/         i{italics}i        <i>italics</i>
      # "{citation}"        c{citation}c       <cite>citation</cite> #blockquote?
      # ^{superscript}^                        <sup>superscript</sup>
      # ,{subscript},                          <sub>subscript</sub>
      # +{inserted text}+                      <ins>inserted text</ins>
      # -{deleted text}-                       <del>deleted text</del>
      # {url address}:url
      # {image.png}imageurl
      # {image.png}png
      # ~{endnote}~         <!e endnote !>
      # !_                                    #bold/emphasise paragraph
      # _"                                    #blockquote paragraph
      # _1                  <:i1>            #indent paragraph 1 step
      # _2                  <:i2>            #indent paragraph 2 steps
      # _3                  <:i3>            #indent paragraph 3 steps
      # _4                  <:i4>            #indent paragraph 4 steps
      # _*                                    #bullet (list) ●
      # _1*                                   #bullet (list) indented
      # _1*                                   #bullet (list) indented
      # #                                     #numbered (list) level 1
      # _#                                    #numbered (list) level 2
      line=line.dup
      if line !~/^0~|<:codeline>|<:code-end>/
        #special characters: ~ { } < > - _ / also used : ^ ! #
        line_array=[]
        line.gsub!(/^%{1,4} .+/mi,'') #remove comments
        word=line.scan(/\S+|\n/) unless line =~/^(?:0~\S|%+\s)/
        if word
          word.each do |w| # _ - / # | : ! ^ ~
            unless w =~/^[0-9]~|~\{|\}~|~\[|\]~|^\^~|~\^|\*~\S+|~#|\{t?~|\{table/
              w.gsub!(/\\~/,'&#126;')                                              #escaped special character
              w.gsub!(/~/,'&#126;')
            end
            w.gsub!(/^\<$/,'&lt;')                                                 #escaped special character
            w.gsub!(/^\>$/,'&gt;')                                                 #escaped special character
            line_array << w
          end
          line=line_array.join(' ')
          line=line.strip
        end
        line.gsub!(/^(1~\??) @title\s+(?:(by\s+)?(?:@creator|@author))\s*$/,"\\1 #{@md.title} - #{@md.subtitle},<br />\\2#{@md.dc_creator}")
        line.gsub!(/^(1~\??) @title\s*$/,"\\1 #{@md.title} - #{@md.subtitle}")                    #
        line.gsub!(/^([23]~\??) (?:(by\s+)?(?:@creator|@author))\s*$/,"\\1 \\2#{@md.dc_creator}")                    #
        line.gsub!(/<((?:https?|file):\/\/\S+?)>/,'< \1 >')                             #catch problem markup
        line.gsub!(/\}\.\.\/(\S+)/,"\}#@output_url/\\1")                             #means you are not supporting relative links (only relevant in html), converted to static here
        line.gsub!(/<:=(\S+?)>/,'{ c_\1.png 14x14 }http://www.jus.uio.no/sisu')                                                    #adjustment 2005w30
        line.gsub!(/<!(\S+)!>/,'<:\1>')                                        #escaped special character
        line.gsub!(/\\~/,'&#126;')                                             #escaped special character
        line.gsub!(/\\\{/,'&#123;')                                            #escaped special character
        line.gsub!(/\\\}/,'&#125;')                                            #escaped special character
        line.gsub!(/\\\<</,'&lt;&lt;')                                         #escaped special character
        line.gsub!(/\\\>>/,'&gt;&gt;')                                         #escaped special character
        line.gsub!(/\\\</,'&lt;')                                              #escaped special character
        line.gsub!(/\\\>/,'&gt;')                                              #escaped special character
        line.gsub!(/\\\_/,'&#095;')                                            #escaped special character
        line.gsub!(/\\\-/,'&#045;')                                            #escaped special character
        line.gsub!(/\\\+/,'&#043;')                                            #escaped special character
        line.gsub!(/\\\//,'&#047;')                                            #escaped special character
        line.gsub!(/\\\#/,'&#035;')                                            #escaped special character
        line.gsub!(/\\\&/,'&#038;')                                    #&amp;  #escaped special character
        line.gsub!(/\\\|/,'&#124;')                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\:/,'&#058;')                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\!/,'&#033;')                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\^/,'&#094;')                                            #not really a sisu special character but made available as possibility
        line.gsub!(/\\\,/,'&#044;')                                            #not really a sisu special character but made available as possibility
        #ADD -->
        line.gsub!(/\\\\/,'&#092;')                                            #escaped special character
        line.gsub!(/\\\*/,'&#042;')                                            #escaped special character
        line.gsub!(/\\\!/,'&#033;')                                            #escaped special character
        line.gsub!(/(?:^| )\*~([a-z0-9._-]+)/i,' <:name#\1>')                  #html name marker <a name="\\1"></a>
        line.gsub!(/^([56]~)(\S+)(.+)/,'\1\2 \3 <:name#\2>')                   #html name marker <a name="\\1"></a>, however at present takes you to correct position within sub-toc, will nneed to clean from sub-toc leaving in main body only
        line.gsub!(/(^| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+?)([;,.]?(?=\s[^~]|$))/,'\1{ \2 }\3\4 ~{ \3 }~ ') #text url endnote url shortcut {~^ [text] }http://url is { [text] }http://url ~{ http://url }~ [plus adjustment for commas] #means for this class, non-object, un-numbered ~# will not work # shortcut should not be used in conjunction with rebgular matches #reversed order, and addition of no-tilde..
        line.gsub!(/(^| )\{~\^ (.+?)\s*\}((?:https?|file|ftp):\S+)\s+~\{(.+?)\}~/,'\1{ \2 }\3 ~{ \3 \4 }~') # watch
        line.gsub!(/<:?br>/,'<br />')                                              #xml requires
      # depreciated -->
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)e\{(.+?)\}e/,'\1<b>\2</b>')     #emphasis
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)b\{(.+?)\}b/,'\1<b>\2</b>')     #bold
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)u\{(.+?)\}u/,'\1<u>\2</u>')     #underscore
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)c\{(.+?)\}c/,'\1<cite>\2</cite>') #cite /blockquote?
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)i\{(.+?)\}i/,'\1<i>\2</i>')     #italics
      # depreciated ^
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)!\{(.+?)\}!/,'\1<em>\2</em>')   #emphasis
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)\*\{(.+?)\}\*/,'\1<b>\2</b>')   #bold
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[\{]|\>)_\{(.+?)\}_/,'\1<u>\2</u>')     #underscore
        line.gsub!(/(^|\s+|['"]|&nbsp;|[\(\[]|\(|\>)\/\{(.+?)\}\//,'\1<i>\2</i>')  #italics
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)\"\{(.+?)\}\"/,'\1<cite>\2</cite>')   #cite /blockquote?
        line.gsub!(/(^|[^\\])\^\{(.+?)\}\^/,'\1<sup>\2</sup>')                     #superscript
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>|\S)9\{(.+?)\}9/,'\1<sup>\2</sup>')    #superscript
        line.gsub!(/(^|[^\\]),\{(.+?)\},/,'\1<sub>\2</sub>')                       #subscript
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)6\{(.+?)\}6/,'\1<sub>\2</sub>')       #subscript
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)\+\{(.+?)\}\+/,'\1<ins>\2</ins>')     #inserted text
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)v\{(.+?)\}v/,'\1<ins>\2</ins>')       #inserted text
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)-\{(.+?)\}-/,'\1<del>\2</del>')       #strikethrough - deleted text
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)x\{(.+?)\}x/,'\1<del>\2</del>')       #deleted text
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)\*(\S+?)\*/,'\1<b>\2</b>')            #bold single word, watch
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)\!(\S+?)\!/,'\1<b>\2</b>')            #bold single word, watch
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)\/([\(\)a-zA-Z0-9']+?)\/([^a-zA-Z0-9]|[ ,.;:'"~$]|$)/,'\1<i>\2</i>\3')     #italics single word, watch
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>)_(\S+?)_([.,!'")]?(?:\s|$))/,'\1<u>\2</u>\3')  #underscore single word, watch (made more complicated by url decoration escape tag (_url))
        line.gsub!(/(^|\s+)-([^{]\S+?)-( |$)/,'\1<del>\2</del>\3')                 #underscore single word, watch
        line.gsub!(/(^|\s+|['"]|&nbsp;|\(|\>|\d+)\^(\S+?)\^/,'\1<sup>\2</sup>')    #superscript single word, watch digit added
        line.gsub!(/<[:e]\s+(.+?)!?>/,'~{ \1 }~')                                  # not tested
        line.gsub!(/^\s*_([1-9])(\*+)\s*/,'<:i\1> _* ')                             #bullets, shortcut
        line.gsub!(/^\s*_([1-9])\s+/,'<:i\1> ')                                     #indent
        line.gsub!(/(?:<br>|<br \/>)\s*_[12]\s+/,'<br> ')                          #indent used in endnotes, not implemented, replace when ready with: line.gsub!(/(?:<br>|<br \/>)\s*_([12])\s+/,'<br><:i\1> ')
        line.gsub!(/<:?br>/,'<br />')                                              #adjustment 2004w41, from # line.gsub!(/<br>/,'<br />')
        ##added
        #line.gsub!(/(?:^!_\s+|^[7-9]~\s+|<:b>)(.*)?([~-]#)$/i,'<b>\1</b> \2')    #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/(?:^!_\s+|^[7-9]~\s+|<:b>)(.*)?\s*$/i,'<b>\1</b>')            #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/(?:(?:^| )!_ |^[7-9]~ |<:b>)(.*)\n/mi,'<b>\1</b> ')           #bold paragraph/emphasize #may wish to remove think about 7{ 8{ conversion not satisfactory, as information is lost!
        #line.gsub!(/^_" (.*)\n/i,'<blockquote>\1</blockquote> ')                 #blockquotes #introduce KEEP
        line.gsub!(/<:hi>/,'<span style="background-color: rgb(255,240,196)">')    # bright yellow rgb(255,255,0) pale yellow rgb(255,255,200)
        line.gsub!(/<:\/hi>/,'</span>')
        line.gsub!(/(<:verse>.+)/m,"\\1\n")
        line.gsub!(/[ ]+($)/,'\1')
        if line =~/(<:(?:verse|group)>)/; line.gsub!(/(<:(?:verse|group)>)/i,"\\1\n") #cosmetic
        else line.gsub!(/(<br \/>)/i,"\\1\n")
        end
      elsif line =~/^<:code(?:-end)?>|<:codeline>/ # /^<:code>/ #should be enough # underscore used as escape for angle brackets
        line.gsub!(/([<>])/,'_\1')
        line.gsub!(/_<:(\S+?)_>/,'<:\1>') #convert <:\S+> back, clumsy
        line.gsub!(/_<(br(?: \/)?)_>/,'<\1>') #convert <br> <br /> back, clumsy
        line.gsub!(/(^|\s)&lt;(br(?: \/)?)&gt;([\s,.]|$)/,'\1<\2>\3') #convert <br> <br /> back, clumsy
        line.gsub!(/<:codeline>/,"\n&nbsp;&nbsp;") #temporary fix, prefer: #line.gsub!(/<:codeline>/,"\n")
      else # 0~
      end
      line
    end
    def tech                                                                       #script markup planned to be more strict for technical documents
      # !{emphasis}!        e{emphasis}e       <strong>emphasis</strong>
      # *{bold text}*       b{bold}b           <b>bold text</b>
      # _{underline}_       u{underline}u      <u>underline</u>
      # /{italics}/         i{italics}i        <i>italics</i>
      # "{citation}"        c{citation}c       <cite>citation</cite>
      # ^{superscript}^                        <sup>superscript</sup>
      # ,{subscript},                          <sub>subscript</sub>
      # +{inserted text}+                      <ins>inserted text</ins>
      # -{deleted text}-                       <del>deleted text</del>
      # {url address}:url
      # {image.png}imageurl
      # {image.png}png
      # ~{endnote}~         <!e endnote !>
      # +1                  <!i1!>
      # +2                  <!i2!>
      puts 'tech'
      @data.each do |line|
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)e\{(.+?)\}e/,'\1<b>\2</b>')          #emphasis
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)b\{(.+?)\}b/,'\1<b>\2</b>')          #bold
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)u\{(.+?)\}u/,'\1<u>\2</u>')          #underscore
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)c\{(.+?)\}c/,'\1<cite>\2</cite>')    #cite
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)i\{(.+?)\}i/,'\1<i>\2</i>')          #italics
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)!\{(.+?)\}!/,'\1<em>\2</em>')        #emphasis
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)\*\{(.+?)\}\*/,'\1<b>\2</b>')        #bold
        line.gsub!(/(^|\s+|['"]|[\(\[]|\>)_\{(.+?)\}_/,'\1<u>\2</u>')          #underscore
        line.gsub!(/(^|\s+|['"]|[\(\[]|\(|\>)\/\{(.+?)\}\//,'\1<i>\2</i>')     #italics
        line.gsub!(/(^|\s+|['"]|\(|\>)\"\{(.+?)\}\"/,'\1<cite>\2</cite>')
        line.gsub!(/(^|\s+|['"]|\(|\>|\S)\^\{(.+?)\}\^/,'\1<sup>\2</sup>')
        line.gsub!(/(^|\s+|['"]|\(|\>|\S)9\{(.+?)\}9/,'\1<sup>\2</sup>')
        line.gsub!(/(^|\s+|['"]|\(|\>),\{(.+?)\},/,'\1<sub>\2</sub>')
        line.gsub!(/(^|\s+|['"]|\(|\>)6\{(.+?)\}6/,'\1<sub>\2</sub>')
        line.gsub!(/(^|\s+|['"]|\(|\>)\+\{(.+?)\}\+/,'\1<ins>\2</ins>')
        line.gsub!(/(^|\s+|['"]|\(|\>)v\{(.+?)\}v/,'\1<ins>\2</ins>')
        line.gsub!(/(^|\s+|['"]|\(|\>)-\{(.+?)\}-/,'\1<del>\2</del>')
        line.gsub!(/(^|\s+|['"]|\(|\>)x\{(.+?)\}x/,'\1<del>\2</del>')
        line.gsub!(/(^|\s+|['"]|\(|\>)\*(\S+?)\*/,'\1<b>\2</b>')               #bold single word, watch
        line.gsub!(/(^|\s+|['"]|\(|\>)\!(\S+?)\!/,'\1<b>\2</b>')               #bold single word, watch
        line.gsub!(/(^|\s+|['"]|\(|\>)\/([\(\)a-zA-Z0-9']+?)\/([ ,.;:'"~$]|[^a-zA-Z0-9])/,'\1<i>\2</i>\3')     #italics single word, watch
        line.gsub!(/(^|\s+|['"]|\(|\>)_(\S+?)_/,'\1<u>\2</u>')                 #underscore single word, watch
        line.gsub!(/(^|\s+|['"]|\(|\>|\d+)\^(\S+?)\^/,'\1<sup>\2</sup>')       #superscript single word, watch digit added
        line.gsub!(/^\s*_([1-9])(\*+)\s*/,'<:i\1> _* ') # bullets, shortcut
        line.gsub!(/^\s*_([1-9])\s+/,'<:i\1> ')
        line.gsub!(/<:?br>/,'<br />')
      end
      @data
    end
  end
end
__END__
NOTE:
downstream code blocks are not currently/yet honoured, e.g. stuff within angle brackets are removed
