=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html scroll generation, processing

=end
module SiSU_HTML_scroll
  require "#{SiSU_lib}/shared_html"
  require "#{SiSU_lib}/html"
  require "#{SiSU_lib}/html_promo"
  class Scroll
    @@dp=nil
    def initialize(data='',md='')
      @data,@md=data,md
      @vz=SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def songsheet
      begin
        scr=Scroll.new(@data,@md).markup
        scr[:tails]=Scroll.new('',@md).tails
        scr
      rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
  protected
    def markup
      data=@data
      @rcdc=false
      @scr={ :body=>[],:metadata=>[],:owner_details=>[] }
      data.each do |para|
        if para =~/^\d~endnotes\s+Endnotes/
          para.gsub!(/Endnotes.+/,'')
        end
        if para =~/^\d~meta\s+Document Information/
          para.gsub!(/(Document Information(?: \(metadata\))?)/,'\1<a name="docinfo"></a>')
        end
        if para =~/^\d~metadata\s+Metadata/
          para.gsub!(/(Metadata)/,'\1<a name="metadata"></a>')
        end
        if @rcdc==false \
        and (para =~/^\d~metadata/ or para =~/^1~meta\s+Document Information/)
          @rcdc=true
        end
        if para !~/(^0~|<ENDNOTES>|<EOF>)/
          unless para =~/^<:code>/; para.gsub!(/~[{\[].+?[}\]]~\s+/m,' ')
          end
          if para =~/.+?<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/
            paranum=para[/.+?<~(\d+);(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/,1]
            @p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,paranum)
          end
          @sto=SiSU_HTML::Source::Split_text_object.new(@md,para).lev_segname_para_ocn
          m=/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/
          if para =~m
            format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,@sto.text) if @sto.format =~/i[1-9]|_[1-9]?\*|<:i[1-9]>\s*_\*|null/
            case @sto.format
            when /^1~\S*/; para=@sto.scroll_lev_para_ocn.heading_body1
            when /^2~\S*/; para=@sto.scroll_lev_para_ocn.heading_body2
            when /^3~\S*/; para=@sto.scroll_lev_para_ocn.heading_body3
            when /^4~\S+/; para=@sto.scroll_lev_para_ocn.heading_body4 # work on see Split_text_object4
            when /^5~\S*/; para=@sto.scroll_lev_para_ocn.heading_body5
            when /^6~\S*/; para=@sto.scroll_lev_para_ocn.heading_body6
            when /^_\*$/;  para=@sto.scroll_lev_para_ocn.bullet
            when /^_([1-9])\*$/ #indent with bullet
              format_txt_obj.gsub_body
              para=@sto.scroll_lev_para_ocn.format('li',"i#{$1}")
            when /^i([1-9])$/ #indent
              format_txt_obj.gsub_body
              para=@sto.scroll_lev_para_ocn.format('p',"i#{$1}")
            when /^center$/;               para=@sto.scroll_lev_para_ocn.center
            when /^(?:b|bold)$/;           para=@sto.scroll_lev_para_ocn.bold
            when /^(?:verse|group|alt)$/;  para=@sto.scroll_lev_para_ocn.para
            when /^code$/;                 para=@sto.scroll_lev_para_ocn.code
            when /null/ # see whether u can improve
              if para !~/#{@vz.margin_txt_0}|#{@vz.margin_txt_1}|#{@vz.margin_txt_2}/
                format_txt_obj.gsub_body
                para=@sto.scroll_lev_para_ocn.para
                if para =~/<!Th?.+/ # tables come as single block
                  table=SiSU_HTML_shared::Table.new(para)
                  para=table.table_split
                end
              end
            end
          elsif para =~/^[1-9]~\S*/ \
          and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/
            format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,para)
            para=format_txt_obj.bold_header
          elsif para =~/Endnotes?/ \
          and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/
            format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="notes">Note</a>')
            para=format_txt_obj.bold_para
          elsif para =~/Owner Details/ \
          and para !~/<~\d+;(?:[oh]|[0-6]:)\d+;\w\d+><#@dp:#@dp>$/
            format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,'<br /><a name="owner.details">Owner Details</a>')
            @scr[:owner_details]=format_txt_obj.bold_para
            para=''
          elsif para =~/(.*)<~0;(?:\w|[0-6]:)\d+;\w\d+><#@dp:#@dp>(.*)/ #watch
            one,two=$1,$2
            format_seg=SiSU_HTML_Format_type::Format_seg.new(@md,one,two)
            para=format_seg.no_paranum
          end
          if para =~/<a name="n\d+">/ \
          and para =~/^(?:\^~\d+\s|<!e[:_]\d+!>)/ # hmmm re-adjusted 200507, for alt endnote which should again be matched ^~ ... not in response to problem though
            para=''
          end
          if para =~/<:center>/ #rules changed now a <p class="center" problems may arise 2005w11 !
            one,two=/(.*)<:center>(.*)/.match(para).captures
            format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,one,two)
          end
          para.gsub!(/<!.+!>/,' ')
          para.gsub!(/^<:\S?>/,'')
          para.gsub!(/<:\S?>/,' ')
          para.strip!
          unless @rcdc; @scr[:body] << para unless para =~/\A\s*\Z/
          else          @scr[:metadata] << para
          end
        end
      end
      @scr
    end
    def tails
      scr_tail=[]
      format_head_scroll=SiSU_HTML_Format_type::Head_toc.new(@md)
      ads=SiSU_HTML_promo::Ad.new(@md)
      scr_tail << format_head_scroll.scroll_tail << ads.div.close << ads.display << format_head_scroll.html_close
      scr_tail
    end
  end
end
__END__
