/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene.event;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.lucene.DocumentBuilder;
import org.hibernate.lucene.Indexed;
import org.hibernate.lucene.store.DirectoryProvider;
import org.hibernate.lucene.store.DirectoryProviderFactory;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
Initializable {
    private Map<Class, DocumentBuilder<Object>> documentBuilders = new HashMap<Class, DocumentBuilder<Object>>();
    private Map<DirectoryProvider, Lock> indexLock = new HashMap<DirectoryProvider, Lock>();
    private boolean initialized;
    private static final Log log = LogFactory.getLog(LuceneEventListener.class);

    public void initialize(Configuration cfg) {
        Analyzer analyzer;
        Class analyzerClass;
        if (this.initialized) {
            return;
        }
        String analyzerClassName = cfg.getProperty("hibernate.lucene.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = Class.forName(analyzerClassName);
            }
            catch (Exception e) {
                throw new HibernateException("Lucene analyzer class '" + analyzerClassName + "' defined in property '" + "hibernate.lucene.analyzer" + "' could not be found.", (Throwable)e);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new HibernateException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClassName);
        }
        catch (Exception e) {
            throw new HibernateException("Failed to instantiate lucene analyzer with type " + analyzerClassName);
        }
        Iterator iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        while (iter.hasNext()) {
            PersistentClass clazz = (PersistentClass)iter.next();
            Class mappedClass = clazz.getMappedClass();
            if (mappedClass == null || !mappedClass.isAnnotationPresent(Indexed.class)) continue;
            DirectoryProvider<?> provider = factory.createDirectoryProvider(mappedClass, cfg);
            DocumentBuilder documentBuilder = new DocumentBuilder(mappedClass, analyzer, provider);
            if (!this.indexLock.containsKey(provider)) {
                this.indexLock.put(provider, new ReentrantLock());
            }
            this.documentBuilders.put(mappedClass, documentBuilder);
        }
        this.initialized = true;
    }

    public void onPostDelete(PostDeleteEvent event) {
        DocumentBuilder<Object> builder = this.documentBuilders.get(event.getEntity().getClass());
        if (builder != null) {
            this.remove(builder, event.getId());
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder<Object> builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            this.add(entity, builder, event.getId());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder<Object> builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            Serializable id = event.getId();
            this.remove(builder, id);
            this.add(entity, builder, id);
        }
    }

    private void remove(DocumentBuilder<?> builder, Serializable id) {
        Term term = builder.getTerm(id);
        log.debug((Object)("removing: " + term));
        DirectoryProvider directoryProvider = builder.getDirectoryProvider();
        Lock lock = this.indexLock.get(directoryProvider);
        lock.lock();
        try {
            IndexReader reader = IndexReader.open(directoryProvider.getDirectory());
            reader.deleteDocuments(term);
            reader.close();
        }
        catch (IOException ioe) {
            throw new HibernateException((Throwable)ioe);
        }
        finally {
            lock.unlock();
        }
    }

    private void add(Object entity, DocumentBuilder<Object> builder, Serializable id) {
        Document doc = builder.getDocument(entity, id);
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding: " + doc));
        }
        DirectoryProvider directoryProvider = builder.getDirectoryProvider();
        Lock lock = this.indexLock.get(directoryProvider);
        lock.lock();
        try {
            IndexWriter writer = new IndexWriter(directoryProvider.getDirectory(), builder.getAnalyzer(), false);
            writer.addDocument(doc);
            writer.close();
        }
        catch (IOException ioe) {
            throw new HibernateException((Throwable)ioe);
        }
        finally {
            lock.unlock();
        }
    }
}

