/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.ClassInfo;
import com.google.doclava.FieldInfo;
import com.google.doclava.MemberInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.SeeTagInfo;
import com.google.doclava.TagInfo;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Proofread {
    static Writer out = null;
    static final Pattern WHITESPACE = Pattern.compile("\\r?\\n");
    static final String INDENT = "        ";
    static final String NEWLINE = "\n        ";

    public static void initProofread(String filename) {
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write("javadoc proofread file: " + filename + "\n");
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                out = null;
            }
            System.err.println("error opening file: " + filename);
        }
    }

    public static void finishProofread(String filename) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void write(String s) {
        if (out == null) {
            return;
        }
        try {
            out.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeIndented(String s) {
        s = s.trim();
        Matcher m = WHITESPACE.matcher(s);
        s = m.replaceAll(NEWLINE);
        Proofread.write(INDENT);
        Proofread.write(s);
        Proofread.write("\n");
    }

    public static void writeFileHeader(String filename) {
        Proofread.write("\n\n=== ");
        Proofread.write(filename);
        Proofread.write(" ===\n");
    }

    public static void writeTagList(TagInfo[] tags) {
        if (out == null) {
            return;
        }
        for (TagInfo t : tags) {
            String k = t.kind();
            if ("Text".equals(t.name())) {
                Proofread.writeIndented(t.text());
                continue;
            }
            if ("@more".equals(k)) {
                Proofread.writeIndented("");
                continue;
            }
            if ("@see".equals(k)) {
                SeeTagInfo see = (SeeTagInfo)t;
                String label = see.label();
                if (label == null) {
                    label = "";
                }
                Proofread.writeIndented("{" + see.name() + " ... " + label + "}");
                continue;
            }
            if ("@code".equals(k)) {
                Proofread.writeIndented(t.text());
                continue;
            }
            if ("@samplecode".equals(k)) {
                Proofread.writeIndented(t.text());
                continue;
            }
            Proofread.writeIndented("{" + (t.name() != null ? t.name() : "") + "/" + t.text() + "}");
        }
    }

    public static void writePackages(String filename, TagInfo[] tags) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(tags);
    }

    public static void writePackage(String filename, TagInfo[] tags) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(tags);
    }

    public static void writeClass(String filename, ClassInfo cl) {
        if (out == null) {
            return;
        }
        Proofread.writeFileHeader(filename);
        Proofread.writeTagList(cl.inlineTags());
        for (FieldInfo fieldInfo : cl.enumConstants()) {
            Proofread.write("ENUM: " + fieldInfo.name() + "\n");
            Proofread.writeTagList(fieldInfo.inlineTags());
        }
        for (FieldInfo fieldInfo : cl.selfFields()) {
            Proofread.write("FIELD: " + fieldInfo.name() + "\n");
            Proofread.writeTagList(fieldInfo.inlineTags());
        }
        for (MemberInfo memberInfo : cl.constructors()) {
            Proofread.write("CONSTRUCTOR: " + memberInfo.name() + "\n");
            Proofread.writeTagList(((MethodInfo)memberInfo).inlineTags().tags());
        }
        for (MemberInfo memberInfo : cl.selfMethods()) {
            Proofread.write("METHOD: " + memberInfo.name() + "\n");
            Proofread.writeTagList(((MethodInfo)memberInfo).inlineTags().tags());
        }
    }
}

