/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AttrTagInfo;
import com.google.doclava.AttributeInfo;
import com.google.doclava.ConstructorInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Converter;
import com.google.doclava.DocInfo;
import com.google.doclava.Doclava;
import com.google.doclava.Errors;
import com.google.doclava.FederatedSite;
import com.google.doclava.FieldInfo;
import com.google.doclava.KeywordEntry;
import com.google.doclava.MemberInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.Scoped;
import com.google.doclava.SinceTagger;
import com.google.doclava.Sorter;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TypeInfo;
import com.sun.javadoc.ClassDoc;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends DocInfo
implements ContainerInfo,
Comparable,
Scoped {
    public static final Comparator<ClassInfo> comparator = new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo a, ClassInfo b) {
            return a.name().compareTo(b.name());
        }
    };
    public static final Comparator<ClassInfo> qualifiedComparator = new Comparator<ClassInfo>(){

        @Override
        public int compare(ClassInfo a, ClassInfo b) {
            return a.qualifiedName().compareTo(b.qualifiedName());
        }
    };
    private ClassDoc mClass;
    private boolean mIsPublic;
    private boolean mIsProtected;
    private boolean mIsPackagePrivate;
    private boolean mIsPrivate;
    private boolean mIsStatic;
    private boolean mIsInterface;
    private boolean mIsAbstract;
    private boolean mIsOrdinaryClass;
    private boolean mIsException;
    private boolean mIsError;
    private boolean mIsEnum;
    private boolean mIsAnnotation;
    private boolean mIsFinal;
    private boolean mIsIncluded;
    private String mName;
    private String mQualifiedName;
    private String mQualifiedTypeName;
    private boolean mIsPrimitive;
    private TypeInfo mTypeInfo;
    private String[] mNameParts;
    private List<ClassInfo> mRealInterfaces = new ArrayList<ClassInfo>();
    private ClassInfo[] mInterfaces;
    private TypeInfo[] mRealInterfaceTypes;
    private ClassInfo[] mInnerClasses;
    private MethodInfo[] mAllConstructors;
    private MethodInfo[] mAllSelfMethods;
    private MethodInfo[] mAnnotationElements;
    private FieldInfo[] mAllSelfFields;
    private FieldInfo[] mEnumConstants;
    private PackageInfo mContainingPackage;
    private ClassInfo mContainingClass;
    private ClassInfo mRealSuperclass;
    private TypeInfo mRealSuperclassType;
    private ClassInfo mSuperclass;
    private AnnotationInstanceInfo[] mAnnotations;
    private boolean mSuperclassInit;
    private boolean mDeprecatedKnown;
    private MethodInfo[] mConstructors;
    private ClassInfo[] mRealInnerClasses;
    private MethodInfo[] mSelfMethods;
    private FieldInfo[] mSelfFields;
    private AttributeInfo[] mSelfAttributes;
    private MethodInfo[] mMethods;
    private FieldInfo[] mFields;
    private TypeInfo[] mTypeParameters;
    private MethodInfo[] mHiddenMethods;
    private int mHidden = -1;
    private int mCheckLevel = -1;
    private String mReasonIncluded;
    private MethodInfo[] mNonWrittenConstructors;
    private boolean mIsDeprecated;
    private HashMap<String, MethodInfo> mApiCheckMethods = new HashMap();
    private HashMap<String, FieldInfo> mApiCheckFields = new HashMap();
    private HashMap<String, ConstructorInfo> mApiCheckConstructors = new HashMap();

    public ClassInfo(String qualifiedName) {
        super("", SourcePositionInfo.UNKNOWN);
        this.mQualifiedName = qualifiedName;
        int pos = qualifiedName.lastIndexOf(46);
        this.mName = pos != -1 ? qualifiedName.substring(pos + 1) : qualifiedName;
    }

    public ClassInfo(ClassDoc cl, String rawCommentText, SourcePositionInfo position, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isStatic, boolean isInterface, boolean isAbstract, boolean isOrdinaryClass, boolean isException, boolean isError, boolean isEnum, boolean isAnnotation, boolean isFinal, boolean isIncluded, String name, String qualifiedName, String qualifiedTypeName, boolean isPrimitive) {
        super(rawCommentText, position);
        this.mClass = cl;
        this.mIsPublic = isPublic;
        this.mIsProtected = isProtected;
        this.mIsPackagePrivate = isPackagePrivate;
        this.mIsPrivate = isPrivate;
        this.mIsStatic = isStatic;
        this.mIsInterface = isInterface;
        this.mIsAbstract = isAbstract;
        this.mIsOrdinaryClass = isOrdinaryClass;
        this.mIsException = isException;
        this.mIsError = isError;
        this.mIsEnum = isEnum;
        this.mIsAnnotation = isAnnotation;
        this.mIsFinal = isFinal;
        this.mIsIncluded = isIncluded;
        this.mName = name;
        this.mQualifiedName = qualifiedName;
        this.mQualifiedTypeName = qualifiedTypeName;
        this.mIsPrimitive = isPrimitive;
        this.mNameParts = name.split("\\.");
    }

    public void init(TypeInfo typeInfo, ClassInfo[] interfaces, TypeInfo[] interfaceTypes, ClassInfo[] innerClasses, MethodInfo[] constructors, MethodInfo[] methods, MethodInfo[] annotationElements, FieldInfo[] fields, FieldInfo[] enumConstants, PackageInfo containingPackage, ClassInfo containingClass, ClassInfo superclass, TypeInfo superclassType, AnnotationInstanceInfo[] annotations) {
        this.mTypeInfo = typeInfo;
        this.mRealInterfaces = new ArrayList<ClassInfo>();
        for (ClassInfo cl : interfaces) {
            this.mRealInterfaces.add(cl);
        }
        this.mRealInterfaceTypes = interfaceTypes;
        this.mInnerClasses = innerClasses;
        this.mAllConstructors = constructors;
        this.mAllSelfMethods = methods;
        this.mAnnotationElements = annotationElements;
        this.mAllSelfFields = fields;
        this.mEnumConstants = enumConstants;
        this.mContainingPackage = containingPackage;
        this.mContainingClass = containingClass;
        this.mRealSuperclass = superclass;
        this.mRealSuperclassType = superclassType;
        this.mAnnotations = annotations;
        this.mSuperclassInit = false;
        this.mConstructors = null;
        this.mMethods = null;
        this.mSelfMethods = null;
        this.mFields = null;
        this.mSelfFields = null;
        this.mSelfAttributes = null;
        this.mDeprecatedKnown = false;
        Arrays.sort(this.mEnumConstants, FieldInfo.comparator);
        Arrays.sort(this.mInnerClasses, comparator);
    }

    public void init2() {
        this.selfAttributes();
    }

    public void init3(TypeInfo[] types, ClassInfo[] realInnerClasses) {
        this.mTypeParameters = types;
        this.mRealInnerClasses = realInnerClasses;
    }

    public ClassInfo[] getRealInnerClasses() {
        return this.mRealInnerClasses;
    }

    public TypeInfo[] getTypeParameters() {
        return this.mTypeParameters;
    }

    @Override
    public boolean checkLevel() {
        int val = this.mCheckLevel;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = Doclava.checkLevel(this.mIsPublic, this.mIsProtected, this.mIsPackagePrivate, this.mIsPrivate, this.isHidden());
        this.mCheckLevel = v ? 1 : 0;
        return v;
    }

    public int compareTo(Object that) {
        if (that instanceof ClassInfo) {
            return this.mQualifiedName.compareTo(((ClassInfo)that).mQualifiedName);
        }
        return this.hashCode() - that.hashCode();
    }

    @Override
    public ContainerInfo parent() {
        return this;
    }

    @Override
    public boolean isPublic() {
        return this.mIsPublic;
    }

    @Override
    public boolean isProtected() {
        return this.mIsProtected;
    }

    @Override
    public boolean isPackagePrivate() {
        return this.mIsPackagePrivate;
    }

    @Override
    public boolean isPrivate() {
        return this.mIsPrivate;
    }

    public boolean isStatic() {
        return this.mIsStatic;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public PackageInfo containingPackage() {
        return this.mContainingPackage;
    }

    public ClassInfo containingClass() {
        return this.mContainingClass;
    }

    public boolean isOrdinaryClass() {
        return this.mIsOrdinaryClass;
    }

    public boolean isException() {
        return this.mIsException;
    }

    public boolean isError() {
        return this.mIsError;
    }

    public boolean isEnum() {
        return this.mIsEnum;
    }

    public boolean isAnnotation() {
        return this.mIsAnnotation;
    }

    public boolean isFinal() {
        return this.mIsFinal;
    }

    @Override
    public boolean isDefinedLocally() {
        return this.mIsIncluded;
    }

    public HashSet<String> typeVariables() {
        HashSet<String> result = TypeInfo.typeVariables(this.mTypeInfo.typeArguments());
        for (ClassInfo cl = this.containingClass(); cl != null; cl = cl.containingClass()) {
            TypeInfo[] types = cl.asTypeInfo().typeArguments();
            if (types == null) continue;
            TypeInfo.typeVariables(types, result);
        }
        return result;
    }

    private static void gatherHiddenInterfaces(ClassInfo cl, HashSet<ClassInfo> interfaces) {
        for (ClassInfo iface : cl.mRealInterfaces) {
            if (iface.checkLevel()) {
                interfaces.add(iface);
                continue;
            }
            ClassInfo.gatherHiddenInterfaces(iface, interfaces);
        }
    }

    public ClassInfo[] getInterfaces() {
        if (this.mInterfaces == null) {
            if (this.checkLevel()) {
                HashSet<ClassInfo> interfaces = new HashSet<ClassInfo>();
                ClassInfo superclass = this.mRealSuperclass;
                while (superclass != null && !superclass.checkLevel()) {
                    ClassInfo.gatherHiddenInterfaces(superclass, interfaces);
                    superclass = superclass.mRealSuperclass;
                }
                ClassInfo.gatherHiddenInterfaces(this, interfaces);
                this.mInterfaces = interfaces.toArray(new ClassInfo[interfaces.size()]);
            } else {
                this.mInterfaces = new ClassInfo[this.mRealInterfaces.size()];
                this.mRealInterfaces.toArray(this.mInterfaces);
            }
            Arrays.sort(this.mInterfaces, qualifiedComparator);
        }
        return this.mInterfaces;
    }

    public ClassInfo[] realInterfaces() {
        return this.mRealInterfaces.toArray(new ClassInfo[this.mRealInterfaces.size()]);
    }

    TypeInfo[] realInterfaceTypes() {
        return this.mRealInterfaceTypes;
    }

    public String name() {
        return this.mName;
    }

    public String[] nameParts() {
        return this.mNameParts;
    }

    public String leafName() {
        return this.mNameParts[this.mNameParts.length - 1];
    }

    @Override
    public String qualifiedName() {
        return this.mQualifiedName;
    }

    public String qualifiedTypeName() {
        return this.mQualifiedTypeName;
    }

    public boolean isPrimitive() {
        return this.mIsPrimitive;
    }

    public MethodInfo[] allConstructors() {
        return this.mAllConstructors;
    }

    public MethodInfo[] constructors() {
        if (this.mConstructors == null) {
            MethodInfo[] methods = this.mAllConstructors;
            ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
            for (int i = 0; i < methods.length; ++i) {
                MethodInfo m = methods[i];
                if (m.isHidden()) continue;
                ctors.add(m);
            }
            this.mConstructors = ctors.toArray(new MethodInfo[ctors.size()]);
            Arrays.sort(this.mConstructors, MethodInfo.comparator);
        }
        return this.mConstructors;
    }

    public ClassInfo[] innerClasses() {
        return this.mInnerClasses;
    }

    public TagInfo[] inlineTags() {
        return this.comment().tags();
    }

    public TagInfo[] firstSentenceTags() {
        return this.comment().briefTags();
    }

    public boolean isDeprecated() {
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().isDeprecated();
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Class " + this.qualifiedName() + ": @Deprecated annotation and @deprecated comment do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    public TagInfo[] deprecatedTags() {
        return this.comment().deprecatedTags();
    }

    public MethodInfo[] methods() {
        if (this.mMethods == null) {
            MethodInfo[] methods;
            ClassInfo[] ifaces;
            TreeMap<String, MethodInfo> all = new TreeMap<String, MethodInfo>();
            for (ClassInfo iface : ifaces = this.getInterfaces()) {
                MethodInfo[] inhereted;
                if (iface == null) continue;
                for (MethodInfo method : inhereted = iface.methods()) {
                    String key = method.getHashableName();
                    all.put(key, method);
                }
            }
            ClassInfo superclass = this.superclass();
            if (superclass != null) {
                MethodInfo[] inhereted;
                for (MethodInfo method : inhereted = superclass.methods()) {
                    String key = method.getHashableName();
                    all.put(key, method);
                }
            }
            for (MethodInfo method : methods = this.selfMethods()) {
                String key = method.getHashableName();
                all.put(key, method);
            }
            this.mMethods = all.values().toArray(new MethodInfo[all.size()]);
            Arrays.sort(this.mMethods, MethodInfo.comparator);
        }
        return this.mMethods;
    }

    public MethodInfo[] annotationElements() {
        return this.mAnnotationElements;
    }

    public AnnotationInstanceInfo[] annotations() {
        return this.mAnnotations;
    }

    private static void addFields(ClassInfo cl, TreeMap<String, FieldInfo> all) {
        for (FieldInfo f : cl.fields()) {
            all.put(f.name(), f);
        }
    }

    public FieldInfo[] fields() {
        if (this.mFields == null) {
            TreeMap<String, FieldInfo> all = new TreeMap<String, FieldInfo>();
            ClassInfo[] interfaces = this.getInterfaces();
            int N = interfaces.length;
            for (int i = 0; i < N; ++i) {
                ClassInfo.addFields(interfaces[i], all);
            }
            ClassInfo superclass = this.superclass();
            if (superclass != null) {
                ClassInfo.addFields(superclass, all);
            }
            for (FieldInfo f : this.selfFields()) {
                if (f.isHidden()) continue;
                String key = f.name();
                all.put(key, f);
            }
            this.mFields = all.values().toArray(new FieldInfo[0]);
        }
        return this.mFields;
    }

    public void gatherFields(ClassInfo owner, ClassInfo cl, HashMap<String, FieldInfo> fields) {
        FieldInfo[] flds;
        for (FieldInfo f : flds = cl.selfFields()) {
            if (!f.checkLevel()) continue;
            fields.put(f.name(), f.cloneForClass(owner));
        }
    }

    public FieldInfo[] selfFields() {
        if (this.mSelfFields == null) {
            HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
            if (this.mRealSuperclass != null && !this.mRealSuperclass.checkLevel()) {
                this.gatherFields(this, this.mRealSuperclass, fields);
            }
            for (ClassInfo iface : this.mRealInterfaces) {
                if (iface.checkLevel()) continue;
                this.gatherFields(this, iface, fields);
            }
            FieldInfo[] selfFields = this.mAllSelfFields;
            for (int i = 0; i < selfFields.length; ++i) {
                FieldInfo f = selfFields[i];
                if (f.isHidden()) continue;
                fields.put(f.name(), f);
            }
            this.mSelfFields = fields.values().toArray(new FieldInfo[fields.size()]);
            Arrays.sort(this.mSelfFields, FieldInfo.comparator);
        }
        return this.mSelfFields;
    }

    public FieldInfo[] allSelfFields() {
        return this.mAllSelfFields;
    }

    private void gatherMethods(ClassInfo owner, ClassInfo cl, HashMap<String, MethodInfo> methods) {
        MethodInfo[] meth;
        for (MethodInfo m : meth = cl.selfMethods()) {
            if (!m.checkLevel()) continue;
            methods.put(m.name() + m.signature(), m.cloneForClass(owner));
        }
    }

    public MethodInfo[] selfMethods() {
        if (this.mSelfMethods == null) {
            HashMap<String, MethodInfo> methods = new HashMap<String, MethodInfo>();
            if (this.mRealSuperclass != null && !this.mRealSuperclass.checkLevel()) {
                this.gatherMethods(this, this.mRealSuperclass, methods);
            }
            for (ClassInfo iface : this.mRealInterfaces) {
                if (iface.checkLevel()) continue;
                this.gatherMethods(this, iface, methods);
            }
            if (this.mAllSelfMethods != null) {
                for (MethodInfo m : this.mAllSelfMethods) {
                    if (!m.checkLevel()) continue;
                    methods.put(m.name() + m.signature(), m);
                }
            }
            this.mSelfMethods = methods.values().toArray(new MethodInfo[methods.size()]);
            Arrays.sort(this.mSelfMethods, MethodInfo.comparator);
        }
        return this.mSelfMethods;
    }

    public MethodInfo[] allSelfMethods() {
        return this.mAllSelfMethods;
    }

    public void addMethod(MethodInfo method) {
        this.mApiCheckMethods.put(method.getHashableName(), method);
        if (this.mAllSelfMethods == null) {
            this.mAllSelfMethods = new MethodInfo[]{method};
            return;
        }
        MethodInfo[] methods = new MethodInfo[this.mAllSelfMethods.length + 1];
        int i = 0;
        for (MethodInfo m : this.mAllSelfMethods) {
            methods[i++] = m;
        }
        methods[i] = method;
        this.mAllSelfMethods = methods;
    }

    public void setContainingPackage(PackageInfo pkg) {
        this.mContainingPackage = pkg;
    }

    public AttributeInfo[] selfAttributes() {
        if (this.mSelfAttributes == null) {
            AttributeInfo attr;
            FieldInfo field;
            TreeMap<FieldInfo, AttributeInfo> attrs = new TreeMap<FieldInfo, AttributeInfo>();
            for (AttrTagInfo attrTagInfo : this.comment().attrTags()) {
                FieldInfo field2 = attrTagInfo.reference();
                if (field2 == null) continue;
                AttributeInfo attr2 = (AttributeInfo)attrs.get(field2);
                if (attr2 == null) {
                    attr2 = new AttributeInfo(this, field2);
                    attrs.put(field2, attr2);
                }
                attrTagInfo.setAttribute(attr2);
            }
            for (MethodInfo methodInfo : this.selfMethods()) {
                for (AttrTagInfo tag : methodInfo.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(methodInfo);
                }
            }
            for (MethodInfo methodInfo : this.constructors()) {
                for (AttrTagInfo tag : methodInfo.comment().attrTags()) {
                    field = tag.reference();
                    if (field == null) continue;
                    attr = (AttributeInfo)attrs.get(field);
                    if (attr == null) {
                        attr = new AttributeInfo(this, field);
                        attrs.put(field, attr);
                    }
                    tag.setAttribute(attr);
                    attr.methods.add(methodInfo);
                }
            }
            this.mSelfAttributes = attrs.values().toArray(new AttributeInfo[attrs.size()]);
            Arrays.sort(this.mSelfAttributes, AttributeInfo.comparator);
        }
        return this.mSelfAttributes;
    }

    public FieldInfo[] enumConstants() {
        return this.mEnumConstants;
    }

    public ClassInfo superclass() {
        if (!this.mSuperclassInit) {
            if (this.checkLevel()) {
                ClassInfo superclass = this.mRealSuperclass;
                while (superclass != null && !superclass.checkLevel()) {
                    superclass = superclass.mRealSuperclass;
                }
                this.mSuperclass = superclass;
            } else {
                this.mSuperclass = this.mRealSuperclass;
            }
        }
        return this.mSuperclass;
    }

    public ClassInfo realSuperclass() {
        return this.mRealSuperclass;
    }

    public TypeInfo superclassType() {
        return this.mRealSuperclassType;
    }

    public TypeInfo asTypeInfo() {
        return this.mTypeInfo;
    }

    TypeInfo[] interfaceTypes() {
        ClassInfo[] infos = this.getInterfaces();
        int len = infos.length;
        TypeInfo[] types = new TypeInfo[len];
        for (int i = 0; i < len; ++i) {
            types[i] = infos[i].asTypeInfo();
        }
        return types;
    }

    @Override
    public String relativePath() {
        String s = this.containingPackage().name();
        s = s.replace('.', '/');
        s = s + '/';
        s = s + this.name();
        s = s + ".html";
        return s;
    }

    public String relativePath(String suffix) {
        String s = this.containingPackage().name();
        s = s.replace('.', '/');
        s = s + '/';
        s = s + this.name() + suffix;
        s = s + ".html";
        return s;
    }

    public boolean isDerivedFrom(ClassInfo cl) {
        ClassInfo dad = this.superclass();
        if (dad != null) {
            if (dad.equals(cl)) {
                return true;
            }
            if (dad.isDerivedFrom(cl)) {
                return true;
            }
        }
        for (ClassInfo iface : this.getInterfaces()) {
            if (iface.equals(cl)) {
                return true;
            }
            if (!iface.isDerivedFrom(cl)) continue;
            return true;
        }
        return false;
    }

    public void makeKeywordEntries(List<KeywordEntry> keywords) {
        if (!this.checkLevel()) {
            return;
        }
        String htmlPage = this.htmlPage();
        String qualifiedName = this.qualifiedName();
        keywords.add(new KeywordEntry(this.name(), htmlPage, "class in " + this.containingPackage().name()));
        FieldInfo[] fields = this.selfFields();
        MethodInfo[] ctors = this.constructors();
        MethodInfo[] methods = this.selfMethods();
        for (FieldInfo fieldInfo : this.enumConstants()) {
            if (!fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "enum constant in " + qualifiedName));
        }
        for (FieldInfo fieldInfo : fields) {
            if (!fieldInfo.isConstant() || !fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "constant in " + qualifiedName));
        }
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.isConstant() || !fieldInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(fieldInfo.name(), htmlPage + "#" + fieldInfo.anchor(), "field in " + qualifiedName));
        }
        for (MemberInfo memberInfo : ctors) {
            if (!memberInfo.isPublic() || !memberInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
        }
        if (Doclava.checkLevel(3)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isProtected() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        if (Doclava.checkLevel(7)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isPackagePrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        if (Doclava.checkLevel(15)) {
            for (MemberInfo memberInfo : ctors) {
                if (!memberInfo.isPrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "constructor in " + qualifiedName));
            }
        }
        for (MemberInfo memberInfo : methods) {
            if (!memberInfo.isPublic() || !memberInfo.checkLevel()) continue;
            keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
        }
        if (Doclava.checkLevel(3)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isProtected() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
        if (Doclava.checkLevel(7)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isPackagePrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
        if (Doclava.checkLevel(15)) {
            for (MemberInfo memberInfo : methods) {
                if (!memberInfo.isPrivate() || !memberInfo.checkLevel()) continue;
                keywords.add(new KeywordEntry(memberInfo.name() + ((MethodInfo)memberInfo).prettySignature(), htmlPage + "#" + memberInfo.anchor(), "method in " + qualifiedName));
            }
        }
    }

    public static void makeLinkListHDF(Data data, String base, ClassInfo[] classes) {
        int N = classes.length;
        for (int i = 0; i < N; ++i) {
            ClassInfo cl = classes[i];
            if (!cl.checkLevel()) continue;
            cl.asTypeInfo().makeHDF(data, base + "." + i);
        }
    }

    public void makeShortDescrHDF(Data data, String base) {
        this.mTypeInfo.makeHDF(data, base + ".type");
        data.setValue(base + ".kind", this.kind());
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
        this.setFederatedReferences(data, base);
    }

    public void makeHDF(Data data) {
        int i;
        ClassInfo supr;
        String kind;
        String name = this.name();
        String qualified = this.qualifiedName();
        AttributeInfo[] selfAttributes = this.selfAttributes();
        MethodInfo[] methods = this.selfMethods();
        FieldInfo[] fields = this.selfFields();
        FieldInfo[] enumConstants = this.enumConstants();
        MethodInfo[] ctors = this.constructors();
        ClassInfo[] inners = this.innerClasses();
        this.mTypeInfo.makeHDF(data, "class.type");
        this.mTypeInfo.makeQualifiedHDF(data, "class.qualifiedType");
        data.setValue("class.name", name);
        data.setValue("class.qualified", qualified);
        if (this.isProtected()) {
            data.setValue("class.scope", "protected");
        } else if (this.isPublic()) {
            data.setValue("class.scope", "public");
        }
        if (this.isStatic()) {
            data.setValue("class.static", "static");
        }
        if (this.isFinal()) {
            data.setValue("class.final", "final");
        }
        if (this.isAbstract() && !this.isInterface()) {
            data.setValue("class.abstract", "abstract");
        }
        if ((kind = this.kind()) != null) {
            data.setValue("class.kind", kind);
        }
        data.setValue("class.since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue("class.since.name", this.getSince());
        this.setFederatedReferences(data, "class");
        this.containingPackage().makeClassLinkListHDF(data, "class.package");
        Vector<ClassInfo> superClasses = new Vector<ClassInfo>();
        superClasses.add(this);
        for (supr = this.superclass(); supr != null; supr = supr.superclass()) {
            superClasses.add(supr);
        }
        int n = superClasses.size();
        for (i = 0; i < n; ++i) {
            supr = (ClassInfo)superClasses.elementAt(n - i - 1);
            supr.asTypeInfo().makeQualifiedHDF(data, "class.inheritance." + i + ".class");
            supr.asTypeInfo().makeHDF(data, "class.inheritance." + i + ".short_class");
            int j = 0;
            for (TypeInfo t : supr.interfaceTypes()) {
                t.makeHDF(data, "class.inheritance." + i + ".interfaces." + j);
                ++j;
            }
        }
        TagInfo.makeHDF(data, "class.descr", this.inlineTags());
        TagInfo.makeHDF(data, "class.seeAlso", this.comment().seeTags());
        TagInfo.makeHDF(data, "class.deprecated", this.deprecatedTags());
        TreeMap<String, ClassInfo> direct = new TreeMap<String, ClassInfo>();
        TreeMap<String, ClassInfo> indirect = new TreeMap<String, ClassInfo>();
        ClassInfo[] all = Converter.rootClasses();
        for (ClassInfo classInfo : all) {
            if (classInfo.superclass() != null && classInfo.superclass().equals(this)) {
                direct.put(classInfo.name(), classInfo);
                continue;
            }
            if (!classInfo.isDerivedFrom(this)) continue;
            indirect.put(classInfo.name(), classInfo);
        }
        i = 0;
        for (ClassInfo cl : direct.values()) {
            if (cl.checkLevel()) {
                cl.makeShortDescrHDF(data, "class.subclasses.direct." + i);
            }
            ++i;
        }
        i = 0;
        for (ClassInfo cl : indirect.values()) {
            if (cl.checkLevel()) {
                cl.makeShortDescrHDF(data, "class.subclasses.indirect." + i);
            }
            ++i;
        }
        if ("java.lang.Object".equals(qualified) || "java.io.Serializable".equals(qualified)) {
            data.setValue("class.subclasses.hidden", "1");
        } else {
            data.setValue("class.subclasses.hidden", "0");
        }
        i = 0;
        for (ClassInfo classInfo : inners) {
            if (classInfo.checkLevel()) {
                classInfo.makeShortDescrHDF(data, "class.inners." + i);
            }
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : enumConstants) {
            ((FieldInfo)docInfo).makeHDF(data, "class.enumConstants." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : fields) {
            if (!((FieldInfo)docInfo).isConstant()) continue;
            ((FieldInfo)docInfo).makeHDF(data, "class.constants." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : fields) {
            if (((FieldInfo)docInfo).isConstant()) continue;
            ((FieldInfo)docInfo).makeHDF(data, "class.fields." + i);
            ++i;
        }
        i = 0;
        for (DocInfo docInfo : ctors) {
            if (!((MemberInfo)docInfo).isPublic()) continue;
            ((MethodInfo)docInfo).makeHDF(data, "class.ctors.public." + i);
            ++i;
        }
        if (Doclava.checkLevel(3)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isProtected()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.protected." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(7)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isPackagePrivate()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.package." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(15)) {
            i = 0;
            for (DocInfo docInfo : ctors) {
                if (!((MemberInfo)docInfo).isPrivate()) continue;
                ((MethodInfo)docInfo).makeHDF(data, "class.ctors.private." + i);
                ++i;
            }
        }
        i = 0;
        for (DocInfo docInfo : methods) {
            if (!((MemberInfo)docInfo).isPublic()) continue;
            ((MethodInfo)docInfo).makeHDF(data, "class.methods.public." + i);
            ++i;
        }
        if (Doclava.checkLevel(3)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isProtected()) continue;
                methodInfo.makeHDF(data, "class.methods.protected." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(7)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isPackagePrivate()) continue;
                methodInfo.makeHDF(data, "class.methods.package." + i);
                ++i;
            }
        }
        if (Doclava.checkLevel(15)) {
            i = 0;
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isPrivate()) continue;
                methodInfo.makeHDF(data, "class.methods.private." + i);
                ++i;
            }
        }
        i = 0;
        for (AttributeInfo attributeInfo : selfAttributes) {
            if (!attributeInfo.checkLevel()) continue;
            attributeInfo.makeHDF(data, "class.attrs." + i);
            ++i;
        }
        TreeSet<ClassInfo> interfaces = new TreeSet<ClassInfo>();
        ClassInfo.addInterfaces(this.getInterfaces(), interfaces);
        ClassInfo cl = this.superclass();
        i = 0;
        while (cl != null) {
            ClassInfo.addInterfaces(cl.getInterfaces(), interfaces);
            ClassInfo.makeInheritedHDF(data, i, cl);
            cl = cl.superclass();
            ++i;
        }
        for (ClassInfo classInfo : interfaces) {
            ClassInfo.makeInheritedHDF(data, i, classInfo);
            ++i;
        }
    }

    private static void addInterfaces(ClassInfo[] ifaces, Set<ClassInfo> out) {
        for (ClassInfo cl : ifaces) {
            out.add(cl);
            ClassInfo.addInterfaces(cl.getInterfaces(), out);
        }
    }

    private static void makeInheritedHDF(Data data, int index, ClassInfo cl) {
        String kind;
        String base = "class.inherited." + index;
        data.setValue(base + ".qualified", cl.qualifiedName());
        if (cl.checkLevel()) {
            data.setValue(base + ".link", cl.htmlPage());
        }
        if ((kind = cl.kind()) != null) {
            data.setValue(base + ".kind", kind);
        }
        if (cl.isDefinedLocally()) {
            data.setValue(base + ".included", "true");
        } else {
            Doclava.federationTagger.tagAll(new ClassInfo[]{cl});
            if (!cl.getFederatedReferences().isEmpty()) {
                FederatedSite site = cl.getFederatedReferences().iterator().next();
                data.setValue(base + ".link", site.linkFor(cl.relativePath()));
                data.setValue(base + ".federated", site.name());
            }
        }
        int i = 0;
        for (AttributeInfo attributeInfo : cl.selfAttributes()) {
            attributeInfo.makeHDF(data, base + ".attrs." + i);
            ++i;
        }
        i = 0;
        for (MethodInfo methodInfo : cl.selfMethods()) {
            methodInfo.makeHDF(data, base + ".methods." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo fieldInfo : cl.selfFields()) {
            if (fieldInfo.isConstant()) continue;
            fieldInfo.makeHDF(data, base + ".fields." + i);
            ++i;
        }
        i = 0;
        for (FieldInfo fieldInfo : cl.selfFields()) {
            if (!fieldInfo.isConstant()) continue;
            fieldInfo.makeHDF(data, base + ".constants." + i);
            ++i;
        }
    }

    @Override
    public boolean isHidden() {
        int val = this.mHidden;
        if (val >= 0) {
            return val != 0;
        }
        boolean v = this.isHiddenImpl();
        this.mHidden = v ? 1 : 0;
        return v;
    }

    public boolean isHiddenImpl() {
        for (ClassInfo cl = this; cl != null; cl = cl.containingClass()) {
            PackageInfo pkg = cl.containingPackage();
            if (pkg != null && pkg.isHidden()) {
                return true;
            }
            if (!cl.comment().isHidden()) continue;
            return true;
        }
        return false;
    }

    private MethodInfo matchMethod(MethodInfo[] methods, String name, String[] params, String[] dimensions, boolean varargs) {
        for (MethodInfo method : methods) {
            if (!method.name().equals(name)) continue;
            if (params == null) {
                return method;
            }
            if (!method.matchesParams(params, dimensions, varargs)) continue;
            return method;
        }
        return null;
    }

    public MethodInfo findMethod(String name, String[] params, String[] dimensions, boolean varargs) {
        MethodInfo rv;
        if (this.mAllSelfMethods != null && (rv = this.matchMethod(this.methods(), name, params, dimensions, varargs)) != null) {
            return rv;
        }
        if (this.mAllConstructors != null && (rv = this.matchMethod(this.constructors(), name, params, dimensions, varargs)) != null) {
            return rv;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findMethod(name, params, dimensions, varargs);
        }
        return null;
    }

    public boolean containsMethod(MethodInfo method) {
        for (MethodInfo m : this.methods()) {
            if (!m.getHashableName().equals(method.getHashableName())) continue;
            return true;
        }
        return false;
    }

    private ClassInfo searchInnerClasses(String[] nameParts, int index) {
        ClassInfo[] inners;
        String part = nameParts[index];
        for (ClassInfo in : inners = this.mInnerClasses) {
            String[] innerParts = in.nameParts();
            if (!part.equals(innerParts[innerParts.length - 1])) continue;
            if (index == nameParts.length - 1) {
                return in;
            }
            return in.searchInnerClasses(nameParts, index + 1);
        }
        return null;
    }

    public ClassInfo extendedFindClass(String className) {
        return this.searchInnerClasses(className.split("\\."), 0);
    }

    public ClassInfo findClass(String className) {
        return Converter.obtainClass(this.mClass.findClass(className));
    }

    public ClassInfo findInnerClass(String className) {
        String[] nodes = className.split("\\.");
        ClassDoc cl = this.mClass;
        for (String n : nodes) {
            if ((cl = cl.findClass(n)) != null) continue;
            return null;
        }
        return Converter.obtainClass(cl);
    }

    public FieldInfo findField(String name) {
        for (FieldInfo f : this.fields()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        for (FieldInfo f : this.enumConstants()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        ClassInfo containing = this.containingClass();
        if (containing != null) {
            return containing.findField(name);
        }
        return null;
    }

    public static ClassInfo[] sortByName(ClassInfo[] classes) {
        int i;
        Object[] sorted = new Sorter[classes.length];
        for (i = 0; i < sorted.length; ++i) {
            ClassInfo cl = classes[i];
            sorted[i] = new Sorter(cl.name(), cl);
        }
        Arrays.sort(sorted);
        ClassInfo[] rv = new ClassInfo[classes.length];
        for (i = 0; i < rv.length; ++i) {
            rv[i] = (ClassInfo)((Sorter)sorted[i]).data;
        }
        return rv;
    }

    public boolean equals(ClassInfo that) {
        if (that != null) {
            return this.qualifiedName().equals(that.qualifiedName());
        }
        return false;
    }

    public void setNonWrittenConstructors(MethodInfo[] nonWritten) {
        this.mNonWrittenConstructors = nonWritten;
    }

    public MethodInfo[] getNonWrittenConstructors() {
        return this.mNonWrittenConstructors;
    }

    public String kind() {
        if (this.isOrdinaryClass()) {
            return "class";
        }
        if (this.isInterface()) {
            return "interface";
        }
        if (this.isEnum()) {
            return "enum";
        }
        if (this.isError()) {
            return "class";
        }
        if (this.isException()) {
            return "class";
        }
        if (this.isAnnotation()) {
            return "@interface";
        }
        return null;
    }

    public String scope() {
        if (this.isPublic()) {
            return "public";
        }
        if (this.isProtected()) {
            return "protected";
        }
        if (this.isPackagePrivate()) {
            return "";
        }
        if (this.isPrivate()) {
            return "private";
        }
        throw new RuntimeException("invalid scope for object " + this);
    }

    public void setHiddenMethods(MethodInfo[] mInfo) {
        this.mHiddenMethods = mInfo;
    }

    public MethodInfo[] getHiddenMethods() {
        return this.mHiddenMethods;
    }

    public String toString() {
        return this.qualifiedName();
    }

    public void setReasonIncluded(String reason) {
        this.mReasonIncluded = reason;
    }

    public String getReasonIncluded() {
        return this.mReasonIncluded;
    }

    private boolean implementsInterface(ClassInfo cl, String iface) {
        if (cl.qualifiedName().equals(iface)) {
            return true;
        }
        for (ClassInfo clImplements : cl.getInterfaces()) {
            if (!this.implementsInterface(clImplements, iface)) continue;
            return true;
        }
        return cl.mSuperclass != null && this.implementsInterface(cl.mSuperclass, iface);
    }

    public void addInterface(ClassInfo iface) {
        this.mRealInterfaces.add(iface);
    }

    public void addConstructor(ConstructorInfo cInfo) {
        this.mApiCheckConstructors.put(cInfo.getHashableName(), cInfo);
    }

    public void addField(FieldInfo fInfo) {
        this.mApiCheckFields.put(fInfo.name(), fInfo);
    }

    public void setSuperClass(ClassInfo superclass) {
        this.mSuperclass = superclass;
    }

    public Map<String, ConstructorInfo> allConstructorsMap() {
        return this.mApiCheckConstructors;
    }

    public Map<String, FieldInfo> allFields() {
        return this.mApiCheckFields;
    }

    public Map<String, MethodInfo> allMethods() {
        return this.mApiCheckMethods;
    }

    public Iterable<ClassInfo> hierarchy() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>(4);
        ClassInfo c = this;
        while (c != null) {
            result.add(c);
            c = c.mSuperclass;
        }
        return result;
    }

    public String superclassName() {
        if (this.mSuperclass == null) {
            if (this.mQualifiedName.equals("java.lang.Object")) {
                return null;
            }
            throw new IllegalStateException("Superclass not set for " + this.qualifiedName());
        }
        return this.mSuperclass.mQualifiedName;
    }

    public void setAnnotations(AnnotationInstanceInfo[] annotations) {
        this.mAnnotations = annotations;
    }

    public boolean isConsistent(ClassInfo cl) {
        MethodInfo mi;
        boolean consistent = true;
        if (this.isInterface() != cl.isInterface()) {
            Errors.error(Errors.CHANGED_CLASS, cl.position(), "Class " + cl.qualifiedName() + " changed class/interface declaration");
            consistent = false;
        }
        for (ClassInfo classInfo : this.mRealInterfaces) {
            if (this.implementsInterface(cl, classInfo.mQualifiedName)) continue;
            Errors.error(Errors.REMOVED_INTERFACE, cl.position(), "Class " + this.qualifiedName() + " no longer implements " + classInfo);
        }
        for (ClassInfo classInfo : cl.mRealInterfaces) {
            if (this.implementsInterface(this, classInfo.mQualifiedName)) continue;
            Errors.error(Errors.ADDED_INTERFACE, cl.position(), "Added interface " + classInfo + " to class " + this.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : this.mApiCheckMethods.values()) {
            if (cl.mApiCheckMethods.containsKey(methodInfo.getHashableName())) {
                if (methodInfo.isConsistent(cl.mApiCheckMethods.get(methodInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            mi = ClassInfo.overriddenMethod(methodInfo, cl);
            if (mi == null) {
                mi = ClassInfo.interfaceMethod(methodInfo, cl);
            }
            if (mi != null) continue;
            Errors.error(Errors.REMOVED_METHOD, methodInfo.position(), "Removed public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (MethodInfo methodInfo : cl.mApiCheckMethods.values()) {
            if (this.mApiCheckMethods.containsKey(methodInfo.getHashableName()) || (mi = ClassInfo.overriddenMethod(methodInfo, this)) != null) continue;
            Errors.error(Errors.ADDED_METHOD, methodInfo.position(), "Added public method " + methodInfo.qualifiedName());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : this.mApiCheckConstructors.values()) {
            if (cl.mApiCheckConstructors.containsKey(constructorInfo.getHashableName())) {
                if (constructorInfo.isConsistent(cl.mApiCheckConstructors.get(constructorInfo.getHashableName()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_METHOD, constructorInfo.position(), "Removed public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (ConstructorInfo constructorInfo : cl.mApiCheckConstructors.values()) {
            if (this.mApiCheckConstructors.containsKey(constructorInfo.getHashableName())) continue;
            Errors.error(Errors.ADDED_METHOD, constructorInfo.position(), "Added public constructor " + constructorInfo.prettySignature());
            consistent = false;
        }
        for (FieldInfo fieldInfo : this.mApiCheckFields.values()) {
            if (cl.mApiCheckFields.containsKey(fieldInfo.name())) {
                if (fieldInfo.isConsistent(cl.mApiCheckFields.get(fieldInfo.name()))) continue;
                consistent = false;
                continue;
            }
            Errors.error(Errors.REMOVED_FIELD, fieldInfo.position(), "Removed field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        for (FieldInfo fieldInfo : cl.mApiCheckFields.values()) {
            if (this.mApiCheckFields.containsKey(fieldInfo.name())) continue;
            Errors.error(Errors.ADDED_FIELD, fieldInfo.position(), "Added public field " + fieldInfo.qualifiedName());
            consistent = false;
        }
        if (this.mIsAbstract != cl.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, cl.position(), "Class " + cl.qualifiedName() + " changed abstract qualifier");
        }
        if (this.mIsFinal != cl.mIsFinal) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, cl.position(), "Class " + cl.qualifiedName() + " changed final qualifier");
        }
        if (this.mIsStatic != cl.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, cl.position(), "Class " + cl.qualifiedName() + " changed static qualifier");
        }
        if (!this.scope().equals(cl.scope())) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, cl.position(), "Class " + cl.qualifiedName() + " scope changed from " + this.scope() + " to " + cl.scope());
        }
        if (!this.isDeprecated() == cl.isDeprecated()) {
            consistent = false;
            Errors.error(Errors.CHANGED_DEPRECATED, cl.position(), "Class " + cl.qualifiedName() + " has changed deprecation state");
        }
        if (this.superclassName() != null) {
            if (cl.superclassName() == null || !this.superclassName().equals(cl.superclassName())) {
                consistent = false;
                Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + this.superclassName() + " to " + cl.superclassName());
            }
        } else if (cl.superclassName() != null) {
            consistent = false;
            Errors.error(Errors.CHANGED_SUPERCLASS, cl.position(), "Class " + this.qualifiedName() + " superclass changed from " + "null to " + cl.superclassName());
        }
        return consistent;
    }

    public static MethodInfo overriddenMethod(MethodInfo candidate, ClassInfo newClassObj) {
        if (newClassObj == null) {
            return null;
        }
        for (MethodInfo mi : newClassObj.mApiCheckMethods.values()) {
            if (!mi.matches(candidate)) continue;
            return mi;
        }
        return ClassInfo.overriddenMethod(candidate, newClassObj.mSuperclass);
    }

    public static MethodInfo interfaceMethod(MethodInfo candidate, ClassInfo newClassObj) {
        if (newClassObj == null) {
            return null;
        }
        for (ClassInfo interfaceInfo : newClassObj.getInterfaces()) {
            for (MethodInfo mi : interfaceInfo.mApiCheckMethods.values()) {
                if (!mi.matches(candidate)) continue;
                return mi;
            }
        }
        return ClassInfo.interfaceMethod(candidate, newClassObj.mSuperclass);
    }

    public boolean hasConstructor(MethodInfo constructor) {
        String name = constructor.getHashableName();
        for (ConstructorInfo ctor : this.mApiCheckConstructors.values()) {
            if (!name.equals(ctor.getHashableName())) continue;
            return true;
        }
        return false;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.mTypeInfo = typeInfo;
    }

    public String getSource() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(this.mPosition.file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            stringBuffer.append(line).append(System.getProperty("line.separator"));
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

