/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.NoOpStringInternStrategy;
import com.google.clearsilver.jsilver.data.StringInternStrategy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSilverOptions
implements Cloneable {
    private boolean cacheTemplates = true;
    private boolean compileTemplates = false;
    private int initialBufferSize = 8192;
    private boolean ignoreAttributes = false;
    private Map<Object, String> precompiledTemplateMap = null;
    private boolean useStrongCacheReferences = false;
    private EscapeMode escapeMode = EscapeMode.ESCAPE_NONE;
    private boolean propagateEscapeStatus = false;
    private StringInternStrategy stringInternStrategy = new NoOpStringInternStrategy();
    private boolean logEscapedVariables = false;
    private boolean useOutputBufferPool = false;
    private boolean stripHtmlWhiteSpace = false;
    private boolean stripStructuralWhiteSpace = false;
    private boolean allowGlobalDataModification = false;
    private boolean keepTemplateCacheFresh = false;
    private int loadPathCacheSize = 1000;

    public JSilverOptions setLoadPathCacheSize(int loadPathCacheSize) {
        this.loadPathCacheSize = loadPathCacheSize;
        return this;
    }

    public int getLoadPathCacheSize() {
        return this.loadPathCacheSize;
    }

    public JSilverOptions setCacheTemplates(boolean cacheTemplates) {
        this.cacheTemplates = cacheTemplates;
        return this;
    }

    public boolean getCacheTemplates() {
        return this.cacheTemplates;
    }

    public JSilverOptions setCompileTemplates(boolean compileTemplates) {
        this.compileTemplates = compileTemplates;
        return this;
    }

    public boolean getCompileTemplates() {
        return this.compileTemplates;
    }

    public JSilverOptions setIgnoreAttributes(boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
        return this;
    }

    public boolean getIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public JSilverOptions setInitialBufferSize(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
        return this;
    }

    public int getInitialBufferSize() {
        return this.initialBufferSize;
    }

    public JSilverOptions setPrecompiledTemplateMap(Map<Object, String> precompiledTemplateMap) {
        this.precompiledTemplateMap = precompiledTemplateMap;
        return this;
    }

    public Map<Object, String> getPrecompiledTemplateMap() {
        return this.precompiledTemplateMap;
    }

    public JSilverOptions setUseStrongCacheReferences(boolean value) {
        this.useStrongCacheReferences = value;
        return this;
    }

    public boolean getUseStrongCacheReferences() {
        return this.useStrongCacheReferences;
    }

    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    public JSilverOptions setEscapeMode(EscapeMode escapeMode) {
        this.escapeMode = escapeMode;
        return this;
    }

    public boolean getPropagateEscapeStatus() {
        return this.propagateEscapeStatus;
    }

    public JSilverOptions setPropagateEscapeStatus(boolean propagateEscapeStatus) {
        this.propagateEscapeStatus = propagateEscapeStatus;
        return this;
    }

    public void setStringInternStrategy(StringInternStrategy stringInternStrategy) {
        if (stringInternStrategy == null) {
            throw new IllegalArgumentException("StringInternStrategy should not be null.");
        }
        this.stringInternStrategy = stringInternStrategy;
    }

    public StringInternStrategy getStringInternStrategy() {
        return this.stringInternStrategy;
    }

    public JSilverOptions setUseOutputBufferPool(boolean value) {
        this.useOutputBufferPool = value;
        return this;
    }

    public boolean getUseOutputBufferPool() {
        return this.useOutputBufferPool;
    }

    public JSilverOptions setStripHtmlWhiteSpace(boolean value) {
        this.stripHtmlWhiteSpace = value;
        return this;
    }

    public boolean getStripHtmlWhiteSpace() {
        return this.stripHtmlWhiteSpace;
    }

    public JSilverOptions setStripStructuralWhiteSpace(boolean value) {
        this.stripStructuralWhiteSpace = value;
        return this;
    }

    public boolean getStripStructuralWhiteSpace() {
        return this.stripStructuralWhiteSpace;
    }

    public JSilverOptions setAllowGlobalDataModification(boolean allowGlobalDataModification) {
        this.allowGlobalDataModification = allowGlobalDataModification;
        return this;
    }

    public boolean getAllowGlobalDataModification() {
        return this.allowGlobalDataModification;
    }

    public JSilverOptions setKeepTemplateCacheFresh(boolean keepTemplateCacheFresh) {
        this.keepTemplateCacheFresh = keepTemplateCacheFresh;
        return this;
    }

    public boolean getKeepTemplateCacheFresh() {
        return this.keepTemplateCacheFresh;
    }

    public JSilverOptions clone() {
        try {
            return (JSilverOptions)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public boolean getLogEscapedVariables() {
        return this.logEscapedVariables;
    }

    public JSilverOptions setLogEscapedVariables(boolean logEscapedVariables) {
        this.logEscapedVariables = logEscapedVariables;
        return this;
    }
}

