/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TypeHandler4;
import com.db4o.internal.marshall.AbstractReadContext;
import com.db4o.internal.marshall.FieldListInfo;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectHeaderAttributes;

public class UnmarshallingContext
extends AbstractReadContext
implements FieldListInfo,
MarshallingInfo {
    private final ObjectReference _reference;
    private Object _object;
    private ObjectHeader _objectHeader;
    private int _addToIDTree;
    private boolean _checkIDTree;

    public UnmarshallingContext(Transaction transaction, Buffer buffer, ObjectReference objectReference, int n, boolean bl) {
        super(transaction, buffer);
        this._reference = objectReference;
        this._addToIDTree = n;
        this._checkIDTree = bl;
    }

    public UnmarshallingContext(Transaction transaction, ObjectReference objectReference, int n, boolean bl) {
        this(transaction, null, objectReference, n, bl);
    }

    public StatefulBuffer statefulBuffer() {
        StatefulBuffer statefulBuffer = new StatefulBuffer(this._transaction, this._buffer.length());
        statefulBuffer.setID(this.objectID());
        statefulBuffer.setInstantiationDepth(this.activationDepth());
        this._buffer.copyTo(statefulBuffer, 0, 0, this._buffer.length());
        statefulBuffer.offset(this._buffer.offset());
        return statefulBuffer;
    }

    public int objectID() {
        return this._reference.getID();
    }

    public Object read() {
        return this.readInternal(false);
    }

    public Object readPrefetch() {
        return this.readInternal(true);
    }

    private final Object readInternal(boolean bl) {
        Object object;
        if (!this.beginProcessing()) {
            return this._object;
        }
        this.readBuffer(this.objectID());
        if (this._buffer == null) {
            this.endProcessing();
            return this._object;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            this.endProcessing();
            return this._object;
        }
        this._reference.classMetadata(classMetadata);
        if (bl) {
            this.adjustActivationDepthForPrefetch();
        }
        if (this._checkIDTree && (object = this._transaction.objectForIdFromCache(this.objectID())) != null) {
            this._object = object;
            this.endProcessing();
            return this._object;
        }
        this._object = this.peekPersisted() ? this.classMetadata().instantiateTransient(this) : this.classMetadata().instantiate(this);
        this.endProcessing();
        return this._object;
    }

    private void adjustActivationDepthForPrefetch() {
        int n = this.classMetadata().configOrAncestorConfig() == null ? 1 : 0;
        this.activationDepth(n);
    }

    public Object readFieldValue(FieldMetadata fieldMetadata) {
        this.readBuffer(this.objectID());
        if (this._buffer == null) {
            return null;
        }
        ClassMetadata classMetadata = this.readObjectHeader();
        if (classMetadata == null) {
            return null;
        }
        if (!this._objectHeader.objectMarshaller().findOffset(classMetadata, this._objectHeader._headerAttributes, this._buffer, fieldMetadata)) {
            return null;
        }
        return fieldMetadata.read(this);
    }

    private ClassMetadata readObjectHeader() {
        this._objectHeader = new ObjectHeader(this.container(), this._buffer);
        ClassMetadata classMetadata = this._objectHeader.classMetadata();
        if (classMetadata == null) {
            return null;
        }
        return classMetadata;
    }

    private void readBuffer(int n) {
        if (this._buffer == null && n > 0) {
            this._buffer = this.container().readReaderByID(this._transaction, n);
        }
    }

    public ClassMetadata classMetadata() {
        return this._reference.classMetadata();
    }

    private boolean beginProcessing() {
        return this._reference.beginProcessing();
    }

    private void endProcessing() {
        this._reference.endProcessing();
    }

    public void setStateClean() {
        this._reference.setStateClean();
    }

    public Object persistentObject() {
        return this._object;
    }

    public void setObjectWeak(Object object) {
        this._reference.setObjectWeak(this.container(), object);
    }

    public Object readObject() {
        int n = this.readInt();
        int n2 = this._activationDepth - 1;
        if (this.peekPersisted()) {
            return this.container().peekPersisted(this.transaction(), n, n2, false);
        }
        Object object = this.container().getByID2(this.transaction(), n);
        if (object instanceof Db4oTypeImpl) {
            n2 = ((Db4oTypeImpl)object).adjustReadDepth(n2);
        }
        this.container().stillToActivate(this.transaction(), object, n2);
        return object;
    }

    private boolean peekPersisted() {
        return this._addToIDTree == -1;
    }

    public Object readObject(TypeHandler4 typeHandler4) {
        TypeHandler4 typeHandler42 = this.correctHandlerVersion(typeHandler4);
        if (!this.isIndirected(typeHandler42)) {
            return typeHandler42.read(this);
        }
        int n = this.readInt();
        this.readInt();
        if (n == 0) {
            return null;
        }
        int n2 = this.offset();
        this.seek(n);
        Object object = typeHandler42.read(this);
        this.seek(n2);
        return object;
    }

    public void adjustInstantiationDepth() {
        Config4Class config4Class = this.classConfig();
        if (config4Class != null) {
            this._activationDepth = config4Class.adjustActivationDepth(this._activationDepth);
        }
    }

    public Config4Class classConfig() {
        return this.classMetadata().config();
    }

    public ObjectReference reference() {
        return this._reference;
    }

    public void addToIDTree() {
        if (this._addToIDTree == 1) {
            this._reference.addExistingReferenceToIdTree(this.transaction());
        }
    }

    public void persistentObject(Object object) {
        this._object = object;
    }

    public ObjectHeaderAttributes headerAttributes() {
        return this._objectHeader._headerAttributes;
    }

    public boolean isNull(int n) {
        return this.headerAttributes().isNull(n);
    }

    public int handlerVersion() {
        return this._objectHeader.handlerVersion();
    }
}

