/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.MemoryFile;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.SerializedGraph;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransportObjectContainer;

public class Serializer {
    public static StatefulBuffer marshall(Transaction transaction, Object object) {
        SerializedGraph serializedGraph = Serializer.marshall(transaction.container(), object);
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, serializedGraph.length());
        statefulBuffer.append(serializedGraph._bytes);
        statefulBuffer.useSlot(serializedGraph._id, 0, serializedGraph.length());
        return statefulBuffer;
    }

    public static SerializedGraph marshall(ObjectContainerBase objectContainerBase, Object object) {
        MemoryFile memoryFile = new MemoryFile();
        memoryFile.setInitialSize(223);
        memoryFile.setIncrementSizeBy(300);
        TransportObjectContainer transportObjectContainer = new TransportObjectContainer(objectContainerBase, memoryFile);
        transportObjectContainer.produceClassMetadata(transportObjectContainer.reflector().forObject(object));
        transportObjectContainer.set(object);
        int n = (int)transportObjectContainer.getID(object);
        transportObjectContainer.close();
        return new SerializedGraph(n, memoryFile.getBytes());
    }

    public static Object unmarshall(ObjectContainerBase objectContainerBase, StatefulBuffer statefulBuffer) {
        return Serializer.unmarshall(objectContainerBase, statefulBuffer._buffer, statefulBuffer.getID());
    }

    public static Object unmarshall(ObjectContainerBase objectContainerBase, SerializedGraph serializedGraph) {
        return Serializer.unmarshall(objectContainerBase, serializedGraph._bytes, serializedGraph._id);
    }

    public static Object unmarshall(ObjectContainerBase objectContainerBase, byte[] byArray, int n) {
        if (n <= 0) {
            return null;
        }
        MemoryFile memoryFile = new MemoryFile(byArray);
        TransportObjectContainer transportObjectContainer = new TransportObjectContainer(objectContainerBase, memoryFile);
        Object object = transportObjectContainer.getByID(n);
        transportObjectContainer.activate(object, Integer.MAX_VALUE);
        transportObjectContainer.close();
        return object;
    }
}

