#ifndef _replyparser_h
#define _replyparser_h


#include <map>
#include <boost/shared_ptr.hpp>
#include <boost/signal.hpp>
#include "message.h"


// http://en.wikipedia.org/wiki/Composite_pattern
class ReplyParser
{
public:
  typedef boost::shared_ptr<ReplyParser> SPtr;

  virtual void parse(Message & replyMessage) = 0;
  virtual ~ReplyParser() {}
};


class CompositeReplyParser: public ReplyParser
{
private:
  struct ParsingEntry
  {
    int replyID;
    ReplyParser::SPtr sPtr;

    ParsingEntry(int replyID, ReplyParser::SPtr sPtr): replyID(replyID), sPtr(sPtr)
    {
    }
  };

  typedef std::map<int, ParsingEntry> mapType;
  mapType myMap;

public:
  void addReplyParser(int replyID, ReplyParser::SPtr sPtr);

  void parse(Message & replyMessage);
};


class TemplateReplyParser_0 : public ReplyParser
{
public:
  boost::signal<void ()> callWorkerSignal;

  void parse(Message & replyMessage)
  {
    callWorkerSignal();
  }
};


template<typename T1>
class TemplateReplyParser_1 : public ReplyParser
{
public:
  boost::signal<void (const T1&)> callWorkerSignal;

  void parse(Message & replyMessage)
  {
    T1 value1;
    popFront(replyMessage, value1);

    callWorkerSignal(value1);
  }
};


template<typename T1, typename T2>
class TemplateReplyParser_2 : public ReplyParser
{
public:
  boost::signal<void (const T1&, const T2&)> callWorkerSignal;

  void parse(Message & replyMessage)
  {
    T1 value1;
    T2 value2;
    popFront(replyMessage, value1);
    popFront(replyMessage, value2);

    callWorkerSignal(value1,value2);
  }
};


#endif
